/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.ItineraryStartNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultGuard;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQProcessStepRoutingAddressImpl;
import java.util.Set;

public class ProcessExitGuard
extends DefaultGuard {
    private boolean m_evaluateExit;
    private boolean m_isImplicit;
    private XQAbstractAddressImpl m_exitStepAddr;

    public ProcessExitGuard(ItineraryEndNode endNode) {
        super("Destination node " + endNode.getId());
        this.m_isImplicit = endNode.isImplicit();
        this.m_exitStepAddr = (XQAbstractAddressImpl)endNode.getEndpointRef();
    }

    public void setExitEvaluation(boolean value) {
        this.m_evaluateExit = value;
    }

    @Override
    public boolean evaluate(Token token) {
        XQAddress messageDestination;
        boolean result = true;
        if (token == null || token instanceof CompositeToken || token.isTokenOfType(Token.Type.FAULT, false) || token.isTokenOfType(Token.Type.RME, false)) {
            result = false;
        } else if (!token.isTokenOfType(Token.Type.NULL, false) && !this.m_isImplicit && (messageDestination = ((EsbMessageExchange)token.getData()).getDestinationAddress()) instanceof XQProcessStepRoutingAddressImpl) {
            return messageDestination.equals((Object)this.m_exitStepAddr);
        }
        if (this.m_evaluateExit) {
            result = ProcessExitGuard.evaluateExitStep(token);
        }
        return result;
    }

    protected static boolean evaluateExitStep(Token token) {
        XQProcessInstance procInst;
        Set<XQAddress> exitAddresses;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQAddress messageDestination = mex.getDestinationAddress();
        if (mex.isResponseToReplyTo()) {
            messageDestination = XQAddressFactoryImpl.getReplyToStatic();
        }
        if ((exitAddresses = (procInst = (XQProcessInstance)token.getProcessInstance()).getNextAddresses(token)) != null) {
            return exitAddresses.contains(messageDestination);
        }
        return token.getFromActivityNode() instanceof ItineraryStartNode;
    }
}

