/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.util.ValidationException;
import com.sonicsw.xqimpl.util.XQValidatingParams;

public class EndpointCfg {
    protected XQEndpointTypeConfig m_typeConfig;
    protected XQEndpointConfig m_config;
    protected XQValidatingParams m_params;

    public EndpointCfg(XQEndpointConfig config, XQEndpointTypeConfig typeConfig) throws XQEndpointCreationException {
        this.m_config = config;
        this.m_typeConfig = typeConfig;
        XQValidatingParams params = this.m_typeConfig.getParameters();
        this.m_params = params == null ? new XQValidatingParams() : (XQValidatingParams)params.clone();
        this.m_params.override((XQParameters)this.m_config.getParameters());
        try {
            this.m_params.validate();
        }
        catch (ValidationException ve) {
            throw new XQEndpointCreationException("Bad connection configuration: ", (Throwable)ve);
        }
    }

    public XQParameters getParameters() {
        return this.m_params;
    }

    public boolean isTemporary() {
        boolean ret = false;
        String val = this.m_params.getParameter("TemporaryEndpoint", 1);
        if (val != null) {
            ret = Boolean.valueOf(val);
        }
        return ret;
    }

    public XQEndpointConfig getConfig() {
        return this.m_config;
    }
}

