/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.script.ExtractedValue;
import com.sonicsw.xqimpl.script.ExtractionRuleComparator;
import com.sonicsw.xqimpl.script.IExtractionRule;
import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.Variable;
import com.sonicsw.xqimpl.script.VariableDirection;
import com.sonicsw.xqimpl.script.XFormUtil;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.Base64;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.URLUtil;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExtractionRules {
    private HashMap m_variableMap = new HashMap();
    private List m_variableList = new ArrayList();
    private boolean m_consumeAll = false;
    private XFormUtil m_xformUtil;
    private String m_encoding = null;
    private static XQLog log = XQLogImpl.getCategoryLog((int)64);

    public ExtractionRules(Element rulesElement, Namespaces nameSpaces, String encoding) throws ScriptEngineException {
        this.deserializeExtractionRules(rulesElement);
        this.m_xformUtil = new XFormUtil(nameSpaces);
        this.m_encoding = encoding;
    }

    public boolean hasExtractionRules() {
        return this.m_variableMap.size() > 0;
    }

    void validateVariables(Map scriptVariables) throws ScriptEngineException {
        for (String variableName : this.m_variableMap.keySet()) {
            Variable v = (Variable)scriptVariables.get(variableName);
            if (v == null) {
                throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
            }
            if (v.getDirection() == VariableDirection.IN) continue;
            throw new ScriptEngineException("extraction-rule-for-out-variable", 1);
        }
    }

    public ExtractedValue getVariableValue(String name, XQMessage message) throws ScriptEngineException, XQMessageException {
        IExtractionRule rule = (IExtractionRule)this.m_variableMap.get(name);
        if (rule != null) {
            return rule.extract(message);
        }
        return null;
    }

    private void deserializeExtractionRules(Element rulesElement) throws ScriptEngineException {
        String consumeAllAttr = rulesElement.getAttribute("consumeAll");
        if (consumeAllAttr != null && Boolean.valueOf(consumeAllAttr).equals(Boolean.TRUE)) {
            this.m_consumeAll = true;
        }
        NodeList tempNl = rulesElement.getChildNodes();
        block7: for (int i = 0; i < tempNl.getLength(); ++i) {
            Element elm;
            RuleData data;
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("extractionRule") || (data = this.deserializeNameValue(elm = (Element)n)) == null) continue;
            switch (data.type) {
                case 0: {
                    this.m_variableList.add(new VariableValueKey(data.name, -1));
                    this.m_variableMap.put(data.name, new SimpleExtractionRule(data.value, data.xpath, data.wrap, data.consume));
                    continue block7;
                }
                case 1: {
                    this.m_variableList.add(new VariableValueKey(data.name, -1));
                    this.m_variableMap.put(data.name, new ValueRefExtractionRule(data.value, data.xpath, data.wrap, data.consume, this.m_encoding));
                    continue block7;
                }
                case 3: {
                    this.m_variableList.add(new VariableValueKey(data.name, -1));
                    this.m_variableMap.put(data.name, new MessageContentIDExtractionRule(data.value, data.xpath, data.wrap, data.consume));
                    continue block7;
                }
                case 2: {
                    int index = Integer.parseInt(data.value);
                    this.m_variableList.add(new VariableValueKey(data.name, index));
                    this.m_variableMap.put(data.name, new MessagePartIndexExtractionRule(index, data.xpath, data.wrap, data.consume));
                    continue block7;
                }
                case 4: {
                    this.m_variableList.add(new VariableValueKey(data.name, -1));
                    this.m_variableMap.put(data.name, new MessageHeaderPropExtractionRule(data.value, data.xpath, data.wrap, data.consume));
                    continue block7;
                }
            }
        }
        Collections.sort(this.m_variableList);
    }

    private RuleData deserializeNameValue(Element ruleElm) throws ScriptEngineException {
        Element wrap;
        RuleData result = new RuleData();
        int type = 0;
        String consumeAttr = ruleElm.getAttribute("consume");
        boolean consume = false;
        if (consumeAttr != null) {
            consume = Boolean.valueOf(consumeAttr);
        }
        Element tempEl = DOMUtils.getImmediateChildElementByName((Element)ruleElm, (String)"simpleValue");
        type = 0;
        if (tempEl == null) {
            tempEl = DOMUtils.getImmediateChildElementByName((Element)ruleElm, (String)"valueRef");
            type = 1;
            if (tempEl == null) {
                tempEl = DOMUtils.getImmediateChildElementByName((Element)ruleElm, (String)"messageContentId");
                type = 3;
                if (tempEl == null) {
                    tempEl = DOMUtils.getImmediateChildElementByName((Element)ruleElm, (String)"messagePartIndex");
                    type = 2;
                    if (tempEl == null) {
                        tempEl = DOMUtils.getImmediateChildElementByName((Element)ruleElm, (String)"messageHeaderProperty");
                        type = 4;
                        if (tempEl == null) {
                            throw new ScriptEngineException("unknown-extraction-rule-type", 1);
                        }
                    }
                }
            }
        }
        if (tempEl == null) {
            return null;
        }
        result.type = type;
        result.consume = consume;
        Text name = DOMUtils.getFirstTextChild((Element)DOMUtils.getImmediateChildElementByName((Element)tempEl, (String)"variablename"));
        if (name == null) {
            throw new ScriptEngineException("extractionrule-variable-name-not-found", 1);
        }
        result.name = name.getData().trim();
        Element valueElement = DOMUtils.getImmediateChildElementByName((Element)tempEl, (String)"value");
        if (valueElement == null) {
            throw new ScriptEngineException("extractionrule-value-not-found", new Object[]{name.getData()}, 1);
        }
        Text value = DOMUtils.getFirstTextChild((Element)valueElement);
        result.value = value == null ? "" : value.getData().trim();
        Element xpath = DOMUtils.getImmediateChildElementByName((Element)tempEl, (String)"xpath");
        if (xpath != null) {
            this.populateResultData(xpath, result, false);
        }
        if ((wrap = DOMUtils.getImmediateChildElementByName((Element)tempEl, (String)"wrap")) != null) {
            this.populateResultData(wrap, result, true);
        }
        return result;
    }

    private void populateResultData(Element wrap, RuleData result, boolean isWrap) {
        String expressionStr;
        Text expression = DOMUtils.getFirstTextChild((Element)wrap);
        if (expression != null && (expressionStr = expression.getData().trim()) != null && expressionStr.length() > 0) {
            if (isWrap) {
                result.wrap = expressionStr;
            } else {
                result.xpath = expressionStr;
            }
        }
    }

    public void consumeParts(XQMessage message) throws ScriptEngineException, XQMessageException {
        if (message != null) {
            TreeSet<IExtractionRule> indexSensitiveER = new TreeSet<IExtractionRule>(new ExtractionRuleComparator());
            LinkedList<IExtractionRule> indexAgnosticER = new LinkedList<IExtractionRule>();
            for (VariableValueKey key : this.m_variableList) {
                IExtractionRule er = (IExtractionRule)this.m_variableMap.get(key.m_key);
                if (er.getIndex() != -1) {
                    indexSensitiveER.add(er);
                    continue;
                }
                indexAgnosticER.add(er);
            }
            int lastIndex = -1;
            while (!indexSensitiveER.isEmpty()) {
                IExtractionRule rule = (IExtractionRule)indexSensitiveER.last();
                if (rule.getIndex() == lastIndex) continue;
                lastIndex = rule.getIndex();
                rule.consume(message);
                indexSensitiveER.remove(rule);
            }
            for (IExtractionRule rule : indexAgnosticER) {
                rule.consume(message);
            }
        }
    }

    private final class RuleData {
        String name;
        String value;
        boolean consume;
        short type;
        String xpath;
        String wrap;

        private RuleData() {
        }
    }

    class VariableValueKey
    implements Comparable {
        private String m_key;
        private int m_index;

        VariableValueKey(String key, int index) {
            this.m_key = key;
            this.m_index = index;
        }

        public int compareTo(Object obj) {
            VariableValueKey key = (VariableValueKey)obj;
            if (this.m_index > key.m_index) {
                return -1;
            }
            if (this.m_index < key.m_index) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return this.m_key.equals(obj);
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }
    }

    private class SimpleExtractionRule
    extends BaseExtractionRule {
        private String m_value;

        SimpleExtractionRule(String value, String xpath, String wrapXML, boolean consume) {
            super(consume, xpath, wrapXML);
            this.m_value = value;
        }

        @Override
        public ExtractedValue extract(XQMessage msg) throws ScriptEngineException {
            log.logDebug("Extracted simple value: " + this.m_value);
            String content = this.performXForms(this.m_value);
            return new ExtractedValue("text/plain", content);
        }

        @Override
        public short getType() {
            return 0;
        }
    }

    class ValueRefExtractionRule
    extends BaseExtractionRule {
        private String m_valueURL;
        private String m_encoding;

        ValueRefExtractionRule(String valueURL, String xpath, String wrapXML, boolean consume, String encoding) {
            super(consume, xpath, wrapXML);
            this.m_valueURL = valueURL;
            this.m_encoding = encoding;
        }

        @Override
        public ExtractedValue extract(XQMessage msg) throws ScriptEngineException, XQMessageException {
            try {
                log.logDebug("Extracted value from URL: " + this.m_valueURL);
                InputStream stream = URLUtil.getInputStream((URL)new URL(this.m_valueURL));
                if (stream == null) {
                    throw new ScriptEngineException("extractionrule-valueref-not-found", new Object[]{this.m_valueURL}, 1);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int length = -1;
                byte[] buffer = new byte[1024];
                do {
                    if ((length = stream.read(buffer)) <= 0) continue;
                    baos.write(buffer, 0, length);
                } while (length != -1);
                stream.close();
                byte[] data = baos.toByteArray();
                if (this.hasXForms()) {
                    String content = Util.createStringFromByteArray(data, this.m_encoding);
                    content = this.performXForms(content);
                    return new ExtractedValue("text/plain", content);
                }
                return new ExtractedValue("application/octet-stream", data);
            }
            catch (MalformedURLException me) {
                ScriptEngineException se = new ScriptEngineException("bad-url-for-document", new Object[]{this.m_valueURL}, 2);
                se.setLinkedException(me);
                throw se;
            }
            catch (Exception e) {
                ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
                se.setLinkedException(e);
                throw se;
            }
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public short getType() {
            return 1;
        }
    }

    class MessageContentIDExtractionRule
    extends BaseExtractionRule {
        private String m_contentID;

        MessageContentIDExtractionRule(String contentID, String xpath, String wrapXML, boolean consume) {
            super(consume, xpath, wrapXML);
            this.m_contentID = contentID;
        }

        @Override
        public ExtractedValue extract(XQMessage msg) throws ScriptEngineException, XQMessageException {
            if (msg == null) {
                return null;
            }
            log.logDebug("Extracted value from message part contentID: " + this.m_contentID);
            XQPart part = msg.getPart(this.m_contentID);
            if (part.getContentType().equals("application/octet-stream") && this.m_xpath != null) {
                throw new ScriptEngineException("An xpath cannot be performed on binary data", 1);
            }
            if (!part.getContentType().equals("application/octet-stream")) {
                String content = null;
                if (this.m_xpath != null) {
                    NodeInfo nodeInfo = ((XQMessageInternal)msg).getPartAsNodeInfo(this.m_contentID, false);
                    content = this.performXPath(nodeInfo);
                } else {
                    content = part.getContent().toString();
                }
                content = this.performWrapAsXML(content);
                return new ExtractedValue(part.getContentType(), content);
            }
            if (this.m_wrapXML != null) {
                byte[] bytes = (byte[])part.getContent();
                String content = new String(Base64.encode((byte[])bytes));
                content = this.performWrapAsXML(content);
                return new ExtractedValue("text/xml", content);
            }
            return new ExtractedValue(part.getContentType(), part.getContent());
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public void consume(XQMessage msg) throws XQMessageException {
            if (this.consume()) {
                log.logDebug("Consumed message part at contentID: " + this.m_contentID);
                try {
                    msg.removePart(this.m_contentID);
                }
                catch (XQMessageException xQMessageException) {
                    // empty catch block
                }
            }
        }

        @Override
        public short getType() {
            return 3;
        }
    }

    private class MessagePartIndexExtractionRule
    extends BaseExtractionRule {
        private int m_index;

        MessagePartIndexExtractionRule(int index, String xpath, String wrapXML, boolean consume) {
            super(consume, xpath, wrapXML);
            this.m_index = index;
        }

        @Override
        public ExtractedValue extract(XQMessage msg) throws ScriptEngineException, XQMessageException {
            if (msg == null) {
                return null;
            }
            log.logDebug("Extracted value from message part index: " + this.m_index);
            XQPart part = msg.getPart(this.m_index);
            if (part.getContentType().equals("application/octet-stream") && this.m_xpath != null) {
                throw new ScriptEngineException("An xpath cannot be performed on binary data", 1);
            }
            if (!part.getContentType().equals("application/octet-stream")) {
                String content = null;
                if (this.m_xpath != null) {
                    NodeInfo nodeInfo = ((XQMessageInternal)msg).getPartAsNodeInfo(this.m_index, false);
                    content = this.performXPath(nodeInfo);
                } else {
                    content = part.getContent().toString();
                }
                content = this.performWrapAsXML(content);
                return new ExtractedValue(part.getContentType(), content);
            }
            if (this.m_wrapXML != null) {
                byte[] bytes = (byte[])part.getContent();
                String content = new String(Base64.encode((byte[])bytes));
                content = this.performWrapAsXML(content);
                return new ExtractedValue("text/xml", content);
            }
            return new ExtractedValue(part.getContentType(), part.getContent());
        }

        @Override
        public void consume(XQMessage msg) throws XQMessageException {
            if (this.consume()) {
                log.logDebug("Consumed message part at index: " + this.m_index);
                msg.removePart(this.m_index);
            }
        }

        @Override
        public int getIndex() {
            return this.m_index;
        }

        @Override
        public short getType() {
            return 2;
        }
    }

    class MessageHeaderPropExtractionRule
    extends BaseExtractionRule {
        private String m_prop;

        MessageHeaderPropExtractionRule(String property, String xpath, String wrapXML, boolean consume) {
            super(consume, xpath, wrapXML);
            this.m_prop = property;
        }

        @Override
        public ExtractedValue extract(XQMessage msg) throws ScriptEngineException, XQMessageException {
            if (msg == null) {
                return null;
            }
            String prop = null;
            log.logDebug("Extracted value from message header property: " + this.m_prop);
            Object tmp = msg.getHeaderValue(this.m_prop);
            if (tmp != null) {
                prop = tmp.toString();
            }
            if (prop == null) {
                throw new ScriptEngineException("header-not-found", new Object[]{this.m_prop}, 1);
            }
            String content = this.performXForms(prop);
            return new ExtractedValue("text/plain", content);
        }

        @Override
        public void consume(XQMessage msg) throws XQMessageException {
            if (this.consume() && msg.containsHeader(this.m_prop)) {
                log.logDebug("Consumed message property: " + this.m_prop);
                msg.removeHeader(this.m_prop);
            }
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public short getType() {
            return 4;
        }
    }

    private abstract class BaseExtractionRule
    implements IExtractionRule {
        private boolean m_consume = false;
        protected String m_xpath = null;
        protected String m_wrapXML = null;

        BaseExtractionRule(boolean consume, String xpath, String wrapXML) {
            this.m_consume = consume;
            this.m_xpath = xpath;
            this.m_wrapXML = wrapXML;
        }

        boolean consume() {
            if (ExtractionRules.this.m_consumeAll) {
                return true;
            }
            return this.m_consume;
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public void consume(XQMessage msg) throws XQMessageException {
        }

        protected String performXForms(String value) throws ScriptEngineException {
            String result = value;
            result = this.performXPath(result);
            result = this.performWrapAsXML(result);
            return result;
        }

        protected String performXPath(String value) throws ScriptEngineException {
            String result = value;
            if (this.m_xpath != null) {
                SequenceExtent xpathResult = ExtractionRules.this.m_xformUtil.performXPath(result, this.m_xpath);
                result = ExtractionRules.this.m_xformUtil.createStringFromXPathValue(xpathResult);
            }
            return result;
        }

        protected String performWrapAsXML(String value) throws ScriptEngineException {
            String result = value;
            if (this.m_wrapXML != null) {
                result = ExtractionRules.this.m_xformUtil.wrapAsXML(this.m_wrapXML, result);
            }
            return result;
        }

        protected String performXPath(NodeInfo value) throws ScriptEngineException {
            String result = null;
            SequenceExtent xpathResult = ExtractionRules.this.m_xformUtil.performXPath(value, this.m_xpath);
            result = ExtractionRules.this.m_xformUtil.createStringFromXPathValue(xpathResult);
            return result;
        }

        protected boolean hasXForms() {
            return this.m_xpath != null || this.m_wrapXML != null;
        }
    }
}

