/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.URLUtil;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.SaxonSerializationUtils;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XFormUtil
extends XMLUtils {
    private Map<String, Namespace> m_namespaceMap = null;
    private Namespaces m_namespaces = null;
    private static final String s_xmlNsNamespace = "http://www.w3.org/2000/xmlns/";

    public XFormUtil(Namespaces nameSpaces) {
        super(nameSpaces != null ? nameSpaces.getNamespaceList() : null, false);
        this.m_namespaces = nameSpaces;
    }

    public XFormUtil(Namespaces nameSpaces, boolean enableCache) {
        super(nameSpaces != null ? nameSpaces.getNamespaceList() : null, enableCache);
        this.m_namespaces = nameSpaces;
    }

    public XFormUtil(Map<String, Namespace> nameSpaceMap, Collection<Namespace> nameSpaces, boolean enableCache) {
        super(nameSpaces, enableCache);
        this.m_namespaceMap = nameSpaceMap;
    }

    public SequenceExtent performXPath(String value, String xpathExpression) throws ScriptEngineException {
        try {
            return this.computeXPath(value, xpathExpression);
        }
        catch (TransformerException tce) {
            throw Util.createParserException(tce, value);
        }
    }

    public SequenceExtent performXPath(Element value, String xpathExpression) throws ScriptEngineException {
        try {
            return this.computeXPath(value, xpathExpression);
        }
        catch (TransformerException tce) {
            ScriptEngineException e = new ScriptEngineException(tce.getMessage(), 1);
            e.setLinkedException(tce);
            throw e;
        }
    }

    public SequenceExtent performXPath(NodeInfo nodeInfo, String xpathExpression) throws ScriptEngineException {
        try {
            return this.computeXPath(nodeInfo, xpathExpression);
        }
        catch (TransformerException tce) {
            ScriptEngineException e = new ScriptEngineException(tce.getMessage(), 1);
            e.setLinkedException(tce);
            throw e;
        }
    }

    public String performXSLTfromURI(String value, String uri) throws ScriptEngineException {
        try {
            return this.computeXSLTfromURI(value, uri);
        }
        catch (Exception e) {
            throw Util.createParserException(e, value);
        }
    }

    public String performXSLT(String value, String xsltExpression) throws ScriptEngineException {
        try {
            return this.computeXSLT(value, xsltExpression);
        }
        catch (Exception e) {
            throw Util.createParserException(e, value);
        }
    }

    public String performXSLT(Element value, String xsltExpression) throws ScriptEngineException {
        try {
            return this.performXSLT(new DOMSource(value), xsltExpression);
        }
        catch (ScriptEngineException se) {
            throw se;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 1);
            se.setLinkedException(e);
            throw se;
        }
    }

    public String performXSLT(Source docSource, String xsltExpression) throws ScriptEngineException {
        InputStream inputStream = null;
        try {
            inputStream = URLUtil.getInputStream((URL)new URL(xsltExpression));
            if (inputStream == null) {
                throw new ScriptEngineException("parametermap-unable-to-load-xslt", new Object[]{xsltExpression}, 1);
            }
            String string = this.computeXSLT(docSource, new InputStreamReader(inputStream));
            return string;
        }
        catch (Exception e) {
            throw Util.createParserException(e, xsltExpression, true);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String wrapAsXML(String tagName, String value) throws ScriptEngineException {
        String prefix = XMLTypeUtils.getTypePrefix(tagName);
        String uri = null;
        if (prefix != null) {
            if (this.m_namespaceMap != null) {
                Namespace ns = this.m_namespaceMap.get(prefix);
                if (ns != null) {
                    uri = ns.getNamespaceUri();
                }
            } else if (this.m_namespaces != null) {
                uri = this.m_namespaces.getNamespaceURI(prefix);
            }
            if (uri == null) {
                throw new ScriptEngineException("xfrom-namespace-not-defined-for-prefix", new Object[]{prefix}, 1);
            }
        }
        Document doc = DOMUtils.createDocument();
        Element newElement = doc.createElementNS(uri, tagName);
        if (prefix != null) {
            newElement.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, uri);
        }
        Text node = doc.createTextNode(value);
        newElement.appendChild(node);
        return Util.getElementAsString(newElement, false);
    }

    public String createStringFromXPathValue(SequenceExtent xpathValue) throws ScriptEngineException {
        try {
            int xpLen = xpathValue.getLength();
            if (xpLen != 1) {
                throw new ScriptEngineException("xform-xpath-invalid-number-of-results", new Object[]{new Integer(xpLen)}, 1);
            }
            Item item = xpathValue.itemAt(0);
            if (item instanceof NodeInfo) {
                StringWriter writer = new StringWriter();
                SaxonSerializationUtils.serializeNodeToWriter((NodeInfo)((NodeInfo)item), (Writer)writer);
                return writer.toString();
            }
            return item.getStringValue();
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }
}

