/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQState;
import com.sonicsw.xqimpl.service.ContainerLifeCycleManager;
import com.sonicsw.xqimpl.service.LifeCycleManagerBase;
import com.sonicsw.xqimpl.service.XQServiceApplication;
import com.sonicsw.xqimpl.service.XQServiceNotifications;

public class ServiceLifeCycleManager
extends LifeCycleManagerBase {
    private XQState m_currentServiceState;
    private ContainerLifeCycleManager m_containerLifeCycle;
    private XQServiceApplication m_serviceApp;
    private volatile String m_lastError;
    private volatile boolean m_isAborting;
    private volatile XQServiceNotifications m_notificationsHelper;
    private Object m_serviceStartedNotifier = new Object();

    ServiceLifeCycleManager(XQServiceApplication serviceApplication, ContainerLifeCycleManager containerLifeCycle, XQServiceNotifications notificationsHelper, XQLog log) {
        super(log);
        this.m_serviceApp = serviceApplication;
        this.m_containerLifeCycle = containerLifeCycle;
        this.m_currentServiceState = XQState.UNINITIALIZED;
        this.m_notificationsHelper = notificationsHelper;
    }

    public synchronized boolean startService() {
        if (this.m_currentServiceState == XQState.STARTED) {
            this.ignoreSameState(XQState.STARTED, this.m_serviceApp.getName(), 0);
        } else if (this.m_currentServiceState == XQState.STARTING) {
            this.ignoreTransientState(XQState.STARTING, this.m_serviceApp.getName(), 0);
        } else if (this.m_currentServiceState == XQState.STOPPING) {
            this.ignoreTransientState(XQState.STOPPING, this.m_serviceApp.getName(), 0);
        } else if (this.m_currentServiceState == XQState.UNINITIALIZED) {
            this.throwInvalidState(XQState.UNINITIALIZED, this.m_serviceApp.getName(), 0);
        } else {
            try {
                this.m_currentServiceState = XQState.STARTING;
                this.clearStateVariables();
                Thread stateChangeThread = new Thread((Runnable)new ChangeServiceState(0), "Start Service Thread");
                stateChangeThread.start();
                return true;
            }
            catch (Throwable e) {
                this.m_lastError = e.toString();
            }
        }
        return false;
    }

    public synchronized boolean stopService() {
        if (this.m_currentServiceState == XQState.STOPPED) {
            this.ignoreSameState(XQState.STOPPED, this.m_serviceApp.getName(), 1);
        } else if (this.m_currentServiceState == XQState.STARTING) {
            this.ignoreTransientState(XQState.STARTING, this.m_serviceApp.getName(), 1);
        } else if (this.m_currentServiceState == XQState.STOPPING) {
            this.ignoreTransientState(XQState.STOPPING, this.m_serviceApp.getName(), 1);
        } else if (this.m_currentServiceState == XQState.UNINITIALIZED) {
            this.throwInvalidState(XQState.UNINITIALIZED, this.m_serviceApp.getName(), 1);
        } else {
            try {
                this.clearStateVariables();
                this.m_currentServiceState = XQState.STOPPING;
                Thread stateChangeThread = new Thread((Runnable)new ChangeServiceState(1), "Stop Service Thread");
                stateChangeThread.start();
                return true;
            }
            catch (Throwable e) {
                this.m_lastError = e.toString();
            }
        }
        return false;
    }

    public synchronized boolean abortService() {
        if (this.m_currentServiceState == XQState.STOPPED) {
            this.ignoreSameState(XQState.STOPPED, this.m_serviceApp.getName(), 2);
        } else if (this.m_currentServiceState == XQState.STARTING) {
            this.ignoreTransientState(XQState.STARTING, this.m_serviceApp.getName(), 2);
        } else if (this.m_currentServiceState == XQState.STOPPING) {
            this.ignoreTransientState(XQState.STOPPING, this.m_serviceApp.getName(), 2);
        } else if (this.m_currentServiceState == XQState.UNINITIALIZED) {
            this.throwInvalidState(XQState.UNINITIALIZED, this.m_serviceApp.getName(), 2);
        } else {
            try {
                this.clearStateVariables();
                this.m_isAborting = true;
                this.m_notificationsHelper.sendNotification("Abort");
                this.m_currentServiceState = XQState.STOPPING;
                Thread stateChangeThread = new Thread((Runnable)new ChangeServiceState(2), "Abort Service Thread");
                stateChangeThread.start();
                return true;
            }
            catch (Throwable e) {
                this.m_lastError = e.toString();
            }
        }
        return false;
    }

    public String getLastError() {
        return this.m_lastError;
    }

    @Override
    public boolean isServiceAborting() {
        return this.m_currentServiceState == XQState.STOPPING && this.m_isAborting;
    }

    public boolean wasServiceAborted() {
        return this.m_isAborting;
    }

    private void clearStateVariables() {
        this.m_lastError = null;
        this.m_isAborting = false;
    }

    public XQState getCurrentServiceState() {
        return this.m_currentServiceState;
    }

    public boolean stopContainer() {
        return this.m_containerLifeCycle.stopContainer();
    }

    public boolean abortContainer() {
        return this.m_containerLifeCycle.abortContainer();
    }

    public XQState getCurrentContainerState() {
        return this.m_containerLifeCycle.getCurrentContainerState();
    }

    @Override
    public boolean isContainerAborting() {
        return this.m_containerLifeCycle.isContainerAborting();
    }

    ContainerLifeCycleManager getContainerLifeCycleManager() {
        return this.m_containerLifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceState(XQState state) {
        if (state.getState() == XQState.STARTED.getState() || state.getState() == XQState.STARTING.getState()) {
            this.clearStateVariables();
        }
        this.m_currentServiceState = state;
        Object object = this.m_serviceStartedNotifier;
        synchronized (object) {
            if (this.m_currentServiceState.getState() == XQState.STARTED.getState()) {
                this.m_serviceStartedNotifier.notifyAll();
            }
        }
    }

    void setLastError(Throwable error) {
        this.m_lastError = error.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForServiceStartedStateOrTimeout(long timeout) {
        if (timeout <= 0L) {
            return;
        }
        long endTime = System.currentTimeMillis() + timeout;
        Object object = this.m_serviceStartedNotifier;
        synchronized (object) {
            while (this.m_currentServiceState.getState() != XQState.STARTED.getState()) {
                long remainingWaitTime = endTime - System.currentTimeMillis();
                if (remainingWaitTime <= 0L) {
                    return;
                }
                try {
                    this.m_serviceStartedNotifier.wait(remainingWaitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public void setLastError(String error) {
        this.m_lastError = error;
    }

    private class ChangeServiceState
    implements Runnable {
        private int m_action;

        private ChangeServiceState(int action) {
            this.m_action = action;
        }

        @Override
        public void run() {
            ServiceLifeCycleManager.this.m_log.logDebug(LifeCycleManagerBase.OPS[this.m_action] + " operation is being peformed on `" + ServiceLifeCycleManager.this.m_serviceApp.getName() + "`");
            try {
                switch (this.m_action) {
                    case 1: {
                        ServiceLifeCycleManager.this.m_serviceApp.stop();
                        break;
                    }
                    case 2: {
                        ServiceLifeCycleManager.this.m_serviceApp.stop();
                        break;
                    }
                    case 0: {
                        ServiceLifeCycleManager.this.m_serviceApp.start();
                    }
                }
            }
            catch (Throwable t) {
                ServiceLifeCycleManager.this.m_log.logWarning("Got following exception while performing " + LifeCycleManagerBase.OPS[this.m_action] + " on `" + ServiceLifeCycleManager.this.m_serviceApp.getName() + "`");
                ServiceLifeCycleManager.this.m_log.logWarning(t);
            }
        }
    }
}

