/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftCache {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object put(Object key, Object value) {
        this.processQueue();
        Value v = Value.create(key, value, this.queue);
        return Value.strip(this.map.put(key, v), true);
    }

    public Object get(Object key) {
        this.processQueue();
        return Value.strip(this.map.get(key), false);
    }

    public Object remove(Object key) {
        this.processQueue();
        return Value.strip(this.map.remove(key), true);
    }

    public void clear() {
        this.processQueue();
        for (Value v : this.map.values()) {
            if (v == null) continue;
            v.drop();
        }
        this.map.clear();
    }

    private void processQueue() {
        Value v;
        while ((v = (Value)this.queue.poll()) != null) {
            if (v.key == Value.DROPPED) continue;
            this.map.remove(v.key);
        }
    }

    private static class Value
    extends SoftReference {
        static final Object DROPPED = new Object();
        Object key;

        static Value create(Object k, Object v, ReferenceQueue q) {
            return v != null ? new Value(k, v, q) : null;
        }

        static Object strip(Object o, boolean drop) {
            if (o != null) {
                Value v = (Value)o;
                o = v.get();
                if (drop) {
                    v.drop();
                }
            }
            return o;
        }

        void drop() {
            this.clear();
            this.key = DROPPED;
        }

        private Value(Object k, Object v, ReferenceQueue q) {
            super(v, q);
            this.key = k;
        }
    }
}

