/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.connection;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.mux.MuxClient;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public final class ConnectionManager {
    private static final long TIMEOUT = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.connectionTimeout", 15000L));
    private static final long HANDSHAKE_TIMEOUT = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.handshakeTimeout", 15000L));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.ConnectionManager");
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final Set reaperSet = new HashSet();
    private final ConnectionEndpoint ep;
    private final List muxes = new ArrayList(1);
    private final List active = new ArrayList(1);
    private final Collection roactive = Collections.unmodifiableCollection(this.active);
    private final List idle = new ArrayList(1);
    private final Collection roidle = Collections.unmodifiableCollection(this.idle);
    private int pendingConnects = 0;

    public ConnectionManager(ConnectionEndpoint ep) {
        this.ep = ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutboundMux connect(OutboundRequestHandle handle) throws IOException {
        OutboundMux outboundMux;
        block31: {
            OutboundMux outboundMux2;
            block30: {
                ConnectionManager connectionManager;
                OutboundMux outboundMux3;
                block29: {
                    Object object = this;
                    synchronized (object) {
                        ++this.pendingConnects;
                    }
                    try {
                        OutboundMux mux;
                        object = reaperSet;
                        synchronized (object) {
                            if (reaperSet.isEmpty()) {
                                systemThreadPool.execute(new Reaper(), "ConnectionManager.Reaper");
                            }
                            reaperSet.add(this);
                        }
                        object = this;
                        synchronized (object) {
                            this.active.clear();
                            this.idle.clear();
                            int i = this.muxes.size();
                            while (--i >= 0) {
                                mux = (OutboundMux)this.muxes.get(i);
                                try {
                                    int n = mux.requestsInProgress();
                                    if (n == 0) {
                                        this.idle.add(mux.getConnection());
                                        continue;
                                    }
                                    if (n >= 128) continue;
                                    this.active.add(mux.getConnection());
                                }
                                catch (IOException e) {
                                    this.muxes.remove(i);
                                }
                            }
                            Connection c = this.ep.connect(handle, this.roactive, this.roidle);
                            if (c != null) {
                                int i2 = this.muxes.size();
                                while (--i2 >= 0) {
                                    OutboundMux mux2 = (OutboundMux)this.muxes.get(i2);
                                    if (c != mux2.getConnection()) continue;
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.log(Level.FINEST, "using {0}", c);
                                    }
                                    mux2.newRequestPending();
                                    outboundMux3 = mux2;
                                    // MONITOREXIT @DISABLED, blocks:[1, 20, 28, 12] lbl44 : MonitorExitStatement: MONITOREXIT : var2_2
                                    Object var10_14 = null;
                                    connectionManager = this;
                                    break block29;
                                }
                                OutboundMux mux3 = this.newOutboundMux(c);
                                mux3.newRequestPending();
                                this.muxes.add(mux3);
                                outboundMux2 = mux3;
                                // MONITOREXIT @DISABLED, blocks:[1, 28, 12] lbl54 : MonitorExitStatement: MONITOREXIT : var2_2
                                break block30;
                            }
                        }
                        Connection c = this.ep.connect(handle);
                        ConnectionManager connectionManager2 = this;
                        synchronized (connectionManager2) {
                            mux = this.newOutboundMux(c);
                            mux.newRequestPending();
                            this.muxes.add(mux);
                            outboundMux = mux;
                        }
                        break block31;
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        ConnectionManager connectionManager3 = this;
                        synchronized (connectionManager3) {
                            assert (this.pendingConnects > 0);
                            --this.pendingConnects;
                            throw throwable;
                        }
                    }
                }
                synchronized (connectionManager) {
                    assert (this.pendingConnects > 0);
                    --this.pendingConnects;
                    return outboundMux3;
                }
            }
            Object var10_15 = null;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                assert (this.pendingConnects > 0);
                --this.pendingConnects;
                return outboundMux2;
            }
        }
        Object var10_16 = null;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            assert (this.pendingConnects > 0);
            --this.pendingConnects;
            return outboundMux;
        }
    }

    synchronized boolean checkIdle(long now, List idle) {
        int i = this.muxes.size();
        while (--i >= 0) {
            OutboundMux mux = (OutboundMux)this.muxes.get(i);
            if (!mux.checkIdle(now)) continue;
            this.muxes.remove(i);
            idle.add(mux);
        }
        return this.pendingConnects == 0 && this.muxes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(OutboundMux mux) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.muxes.remove(mux);
        }
        mux.shutdown("writeRequestData failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OutboundMux newOutboundMux(Connection c) throws IOException {
        logger.log(Level.FINEST, "opened {0}", c);
        OutboundMux mux = null;
        try {
            mux = c.getChannel() == null ? new OutboundMux(c) : new OutboundMux(c, true);
            mux.setStartTimeout(HANDSHAKE_TIMEOUT);
            Object var4_3 = null;
            if (mux != null) return mux;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (mux != null) throw throwable;
            try {
                c.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            c.close();
            return mux;
        }
        catch (IOException e) {}
        return mux;
    }

    public OutboundRequestIterator newRequest(OutboundRequestHandle handle) {
        return new ReqIterator(handle);
    }

    private final class ReqIterator
    implements OutboundRequestIterator {
        private final OutboundRequestHandle handle;
        private boolean first = true;
        private OutboundMux mux;

        ReqIterator(OutboundRequestHandle handle) {
            this.handle = handle;
        }

        public synchronized boolean hasNext() {
            return this.first || this.mux != null && this.mux.shouldRetry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized OutboundRequest next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.mux = ConnectionManager.this.connect(this.handle);
            OutboundRequest req = this.mux.newRequest();
            Outbound sreq = null;
            try {
                Connection c = this.mux.getConnection();
                c.writeRequestData(this.handle, req.getRequestOutputStream());
                sreq = new Outbound(req, c, this.handle);
                Object var5_4 = null;
                if (sreq == null) {
                    ConnectionManager.this.remove(this.mux);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (sreq == null) {
                    ConnectionManager.this.remove(this.mux);
                }
                throw throwable;
            }
            return sreq;
        }
    }

    private static final class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done;
            ArrayList idle = new ArrayList(1);
            do {
                try {
                    Thread.sleep(TIMEOUT);
                }
                catch (InterruptedException e) {
                    return;
                }
                long now = System.currentTimeMillis();
                Set set = reaperSet;
                synchronized (set) {
                    Iterator iter = reaperSet.iterator();
                    while (iter.hasNext()) {
                        ConnectionManager mgr = (ConnectionManager)iter.next();
                        if (!mgr.checkIdle(now, idle)) continue;
                        iter.remove();
                    }
                    done = reaperSet.isEmpty();
                }
                int i = idle.size();
                while (--i >= 0) {
                    ((OutboundMux)idle.get(i)).shutdown("idle");
                }
                idle.clear();
            } while (!done);
        }
    }

    private static final class Outbound
    implements OutboundRequest {
        private final OutboundRequest req;
        private final Connection c;
        private final OutboundRequestHandle handle;
        private final InputStream in;
        private boolean status = true;

        Outbound(OutboundRequest req, Connection c, OutboundRequestHandle handle) {
            this.req = req;
            this.c = c;
            this.handle = handle;
            this.in = new Input(handle);
        }

        public OutputStream getRequestOutputStream() {
            return this.req.getRequestOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.in;
        }

        public void populateContext(Collection context) {
            this.c.populateContext(this.handle, context);
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            return this.c.getUnfulfilledConstraints(this.handle);
        }

        public boolean getDeliveryStatus() {
            return this.status && this.req.getDeliveryStatus();
        }

        public void abort() {
            this.req.abort();
        }

        private final class Input
        extends InputStream {
            private final InputStream in;
            private OutboundRequestHandle handle;

            Input(OutboundRequestHandle handle) {
                this.in = Outbound.this.req.getResponseInputStream();
                this.handle = handle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void readFirst() throws IOException {
                if (this.handle != null) {
                    try {
                        IOException e = Outbound.this.c.readResponseData(this.handle, this.in);
                        if (e != null) {
                            Outbound.this.status = false;
                            throw e;
                        }
                        Object var3_2 = null;
                        this.handle = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.handle = null;
                        throw throwable;
                    }
                }
            }

            public int read() throws IOException {
                this.readFirst();
                return this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.readFirst();
                return this.in.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                this.readFirst();
                return this.in.skip(n);
            }

            public int available() throws IOException {
                this.readFirst();
                return this.in.available();
            }

            public void close() throws IOException {
                this.in.close();
            }
        }
    }

    private final class OutboundMux
    extends MuxClient {
        private final Connection c;
        private final Object startLock;
        private boolean pendingStart;
        private int pendingNewRequests;
        private long idleTime;

        OutboundMux(Connection c) throws IOException {
            super(c.getOutputStream(), c.getInputStream());
            this.startLock = new Object();
            this.pendingStart = true;
            this.pendingNewRequests = 0;
            this.idleTime = 0L;
            this.c = c;
        }

        OutboundMux(Connection c, boolean ignore) throws IOException {
            super(c.getChannel());
            this.startLock = new Object();
            this.pendingStart = true;
            this.pendingNewRequests = 0;
            this.idleTime = 0L;
            this.c = c;
        }

        Connection getConnection() {
            return this.c;
        }

        void newRequestPending() {
            assert (Thread.holdsLock(ConnectionManager.this));
            ++this.pendingNewRequests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutboundRequest newRequest() throws IOException {
            Object object;
            block19: {
                ConnectionManager connectionManager;
                assert (!Thread.holdsLock(ConnectionManager.this));
                boolean ok = false;
                try {
                    object = this.startLock;
                    synchronized (object) {
                        if (this.pendingStart) {
                            this.pendingStart = false;
                            this.start();
                        }
                    }
                    ok = true;
                    Object var5_4 = null;
                    if (ok) break block19;
                    connectionManager = ConnectionManager.this;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!ok) {
                        ConnectionManager connectionManager2 = ConnectionManager.this;
                        synchronized (connectionManager2) {
                            assert (this.pendingNewRequests > 0);
                            --this.pendingNewRequests;
                        }
                    }
                    throw throwable;
                }
                synchronized (connectionManager) {
                    assert (this.pendingNewRequests > 0);
                    --this.pendingNewRequests;
                }
            }
            object = ConnectionManager.this;
            synchronized (object) {
                assert (this.pendingNewRequests > 0);
                --this.pendingNewRequests;
                this.idleTime = 0L;
                return super.newRequest();
            }
        }

        public int requestsInProgress() throws IOException {
            assert (Thread.holdsLock(ConnectionManager.this));
            return super.requestsInProgress() + this.pendingNewRequests;
        }

        boolean checkIdle(long now) {
            assert (Thread.holdsLock(ConnectionManager.this));
            try {
                if (this.requestsInProgress() == 0) {
                    if (this.idleTime == 0L) {
                        this.idleTime = now;
                    } else {
                        return now - this.idleTime > TIMEOUT;
                    }
                }
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }

        protected void handleDown() {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        boolean shouldRetry() {
            return false;
        }
    }
}

