/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.jeri.ssl.Utilities;

class CallContext
extends Utilities
implements OutboundRequestHandle {
    final Endpoint endpoint;
    final SslEndpointImpl endpointImpl;
    final Subject clientSubject;
    final boolean clientAuthRequired;
    final Set clientPrincipals;
    final Set serverPrincipals;
    final String[] cipherSuites;
    final boolean integrityRequired;
    final boolean integrityPreferred;
    final long connectionTime;

    static CallContext coerce(OutboundRequestHandle handle, Endpoint endpoint) {
        if (handle == null) {
            throw new NullPointerException("Handle cannot be null");
        }
        if (!(handle instanceof CallContext)) {
            throw new IllegalArgumentException("Handle must be of type CallContext: " + handle);
        }
        CallContext context = (CallContext)handle;
        if (!endpoint.equals(context.endpoint)) {
            throw new IllegalArgumentException("Handle has wrong endpoint -- was " + context.endpoint + ", should be " + endpoint);
        }
        return context;
    }

    CallContext(Endpoint endpoint, SslEndpointImpl endpointImpl, Subject clientSubject, boolean clientAuthRequired, Set clientPrincipals, Set serverPrincipals, List cipherSuites, boolean integrityRequired, boolean integrityPreferred, long connectionTime) {
        this.endpoint = endpoint;
        this.endpointImpl = endpointImpl;
        this.clientSubject = clientSubject;
        this.clientAuthRequired = clientAuthRequired;
        this.clientPrincipals = clientPrincipals;
        this.serverPrincipals = serverPrincipals;
        this.cipherSuites = cipherSuites.toArray(new String[cipherSuites.size()]);
        this.integrityRequired = integrityRequired;
        this.integrityPreferred = integrityPreferred;
        this.connectionTime = connectionTime;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("CallContext[");
        buff.append("\n  ").append(this.endpoint);
        buff.append("\n  clientSubject=");
        if (this.clientSubject == null) {
            buff.append("null");
        } else {
            buff.append("Subject@");
            buff.append(Integer.toHexString(System.identityHashCode(this.clientSubject)));
        }
        buff.append("\n  clientAuthRequired=").append(this.clientAuthRequired);
        buff.append("\n  clientPrincipals=").append(this.clientPrincipals);
        buff.append("\n  serverPrincipals=").append(this.serverPrincipals);
        buff.append("\n  cipherSuites=").append(CallContext.toString(this.cipherSuites));
        if (this.integrityRequired) {
            buff.append("\n  integrity=required");
        } else if (this.integrityPreferred) {
            buff.append("\n  integrity=preferred");
        }
        if (this.connectionTime != Long.MAX_VALUE) {
            buff.append("\n  connectionTime=").append(this.connectionTime);
        }
        buff.append("\n]");
        return buff.toString();
    }

    InvocationConstraints getUnfulfilledConstraints() {
        if (this.integrityRequired) {
            return INTEGRITY_REQUIRED;
        }
        if (this.integrityPreferred) {
            return INTEGRITY_PREFERRED;
        }
        return InvocationConstraints.EMPTY;
    }
}

