/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.AbstractDgcClient;
import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.logging.Levels;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.jeri.Endpoint;

public final class DgcClient
extends AbstractDgcClient {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicObjectEndpoint");
    private static final Class[] proxyInterfaces = new Class[]{DgcServer.class};
    private static final Uuid clientID = UuidFactory.generate();

    public void registerRefs(Endpoint endpoint, Collection refs) {
        super.registerRefs(endpoint, refs);
    }

    protected AbstractDgcClient.DgcProxy getDgcProxy(Object endpoint) {
        Endpoint e = (Endpoint)endpoint;
        BasicObjectEndpoint oe = new BasicObjectEndpoint(e, Jeri.DGC_ID, false);
        BasicInvocationHandler ih = new BasicInvocationHandler(oe, null);
        DgcServer proxy = (DgcServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), proxyInterfaces, (InvocationHandler)ih);
        return new DgcProxyImpl(proxy);
    }

    protected void freeEndpoint(Object endpoint) {
    }

    protected Object getRefEndpoint(Object ref) {
        BasicObjectEndpoint oei = (BasicObjectEndpoint)ref;
        assert (oei.getEnableDGC());
        return oei.getEndpoint();
    }

    protected Object getRefObjectID(Object ref) {
        BasicObjectEndpoint oei = (BasicObjectEndpoint)ref;
        assert (oei.getEnableDGC());
        return oei.getObjectIdentifier();
    }

    private class DgcProxyImpl
    implements AbstractDgcClient.DgcProxy {
        private final DgcServer dgcServer;

        DgcProxyImpl(DgcServer dgcServer) {
            this.dgcServer = dgcServer;
        }

        public long dirty(final long sequenceNum, Object[] ids, long duration) throws RemoteException {
            final Uuid[] idsCopy = new Uuid[ids.length];
            System.arraycopy(ids, 0, idsCopy, 0, ids.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sequenceNum={0}, ids={1} (clientID={2})", new Object[]{new Long(sequenceNum), Arrays.asList(idsCopy), clientID});
            }
            try {
                return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        long l = DgcProxyImpl.this.dgcServer.dirty(clientID, sequenceNum, idsCopy);
                        return new Long(l);
                    }
                }, null);
            }
            catch (PrivilegedActionException e) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "exception occurred", e.getCause());
                }
                throw (RemoteException)e.getCause();
            }
        }

        public void clean(final long sequenceNum, Object[] ids, final boolean strong) throws RemoteException {
            final Uuid[] idsCopy = new Uuid[ids.length];
            System.arraycopy(ids, 0, idsCopy, 0, ids.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sequenceNum={0}, ids={1}, strong={2} (clientID={3})", new Object[]{new Long(sequenceNum), Arrays.asList(idsCopy), strong, clientID});
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        DgcProxyImpl.this.dgcServer.clean(clientID, sequenceNum, idsCopy, strong);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException e) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "exception occurred", e.getCause());
                }
                throw (RemoteException)e.getCause();
            }
        }
    }
}

