/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.jeri.ssl.ConfidentialityStrength;
import net.jini.jeri.ssl.Utilities;

final class ConnectionContext
extends Utilities {
    private static final long OK = Long.MAX_VALUE;
    private static final long INTEGRITY = -3L;
    private static final long NOT_SUPPORTED = -4L;
    private static final ClientMinPrincipalType clientMinPrincipalType = new ClientMinPrincipalType(X500Principal.class);
    final String cipherSuite;
    final Principal client;
    final Principal server;
    private final boolean integrity;
    private final boolean clientSide;
    private boolean notSupported;
    private boolean integrityRequired;
    private boolean integrityPreferred;
    private long connectionTime = Long.MAX_VALUE;
    private int preferences;

    static ConnectionContext getInstance(String cipherSuite, Principal client, Principal server, boolean integrity, boolean clientSide, InvocationConstraints constraints) {
        ConnectionContext context = new ConnectionContext(cipherSuite, client, server, integrity, clientSide);
        return context.supported(constraints) ? context : null;
    }

    private ConnectionContext(String cipherSuite, Principal client, Principal server, boolean integrity, boolean clientSide) {
        this.cipherSuite = cipherSuite;
        this.client = client;
        this.server = server;
        this.integrity = integrity;
        this.clientSide = clientSide;
        boolean serverAuth = ConnectionContext.doesServerAuthentication(cipherSuite);
        if (serverAuth != (server != null) || client != null && server == null) {
            this.notSupported = true;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConnectionContext[");
        this.fieldsToString(sb);
        sb.append("]");
        return sb.toString();
    }

    void fieldsToString(StringBuffer sb) {
        sb.append(this.cipherSuite);
        if (this.client != null) {
            sb.append(", client: ").append(this.client);
        }
        if (this.server != null) {
            sb.append(", server: ").append(this.server);
        }
        if (this.integrityRequired) {
            sb.append(", integrity: required");
        } else if (this.integrityPreferred) {
            sb.append(", integrity: preferred");
        }
        if (this.connectionTime != Long.MAX_VALUE) {
            sb.append(", connectionTime = ").append(this.connectionTime);
        }
        sb.append(", preferences: ").append(this.preferences);
    }

    boolean getIntegrityRequired() {
        return this.integrityRequired;
    }

    boolean getIntegrityPreferred() {
        return this.integrityPreferred;
    }

    long getConnectionTime() {
        return this.connectionTime;
    }

    int getPreferences() {
        return this.preferences;
    }

    private boolean supported(InvocationConstraints constraints) {
        long r;
        if (this.notSupported) {
            return false;
        }
        Iterator i = constraints.requirements().iterator();
        while (i.hasNext()) {
            r = this.supported((InvocationConstraint)i.next());
            if (r == -4L) {
                return false;
            }
            if (r == -3L) {
                this.integrityRequired = true;
                continue;
            }
            if (this.connectionTime <= r) continue;
            this.connectionTime = r;
        }
        i = constraints.preferences().iterator();
        while (i.hasNext()) {
            r = this.supported((InvocationConstraint)i.next());
            if (r == -4L) continue;
            ++this.preferences;
            if (r == -3L) {
                if (this.integrityRequired) continue;
                this.integrityPreferred = true;
                continue;
            }
            if (this.connectionTime <= r) continue;
            this.connectionTime = r;
        }
        return !this.integrity || this.integrityRequired || this.integrityPreferred;
    }

    private long supported(InvocationConstraint constraint) {
        if (constraint instanceof ConstraintAlternatives) {
            return this.supported((ConstraintAlternatives)constraint);
        }
        if (constraint instanceof Integrity) {
            return this.integrity && constraint == Integrity.YES ? -3L : -4L;
        }
        if (constraint instanceof Confidentiality) {
            return ConnectionContext.ok(ConnectionContext.doesEncryption(this.cipherSuite) == (constraint == Confidentiality.YES));
        }
        if (constraint instanceof ConfidentialityStrength) {
            return ConnectionContext.ok(!ConnectionContext.doesEncryption(this.cipherSuite) || ConnectionContext.hasStrongCipherAlgorithm(this.cipherSuite) == (constraint == ConfidentialityStrength.STRONG));
        }
        if (constraint instanceof ClientAuthentication) {
            return ConnectionContext.ok(this.client == null == (constraint == ClientAuthentication.NO));
        }
        if (constraint instanceof ClientMinPrincipalType) {
            return ConnectionContext.ok(this.client == null || constraint.equals(clientMinPrincipalType));
        }
        if (constraint instanceof ClientMaxPrincipalType) {
            return ConnectionContext.ok(this.client == null || ((ClientMaxPrincipalType)constraint).elements().contains(X500Principal.class));
        }
        if (constraint instanceof ClientMinPrincipal) {
            if (this.client == null) {
                return Long.MAX_VALUE;
            }
            Set elements = ((ClientMinPrincipal)constraint).elements();
            return ConnectionContext.ok(elements.size() == 1 && elements.contains(this.client));
        }
        if (constraint instanceof ClientMaxPrincipal) {
            return ConnectionContext.ok(this.client == null || ((ClientMaxPrincipal)constraint).elements().contains(this.client));
        }
        if (constraint instanceof Delegation) {
            return ConnectionContext.ok(this.client == null || constraint == Delegation.NO);
        }
        if (constraint instanceof DelegationAbsoluteTime) {
            return Long.MAX_VALUE;
        }
        if (constraint instanceof DelegationRelativeTime) {
            return ConnectionContext.ok(!this.clientSide);
        }
        if (constraint instanceof ServerAuthentication) {
            return ConnectionContext.ok(this.server == null == (constraint == ServerAuthentication.NO));
        }
        if (constraint instanceof ServerMinPrincipal) {
            if (this.server == null) {
                return Long.MAX_VALUE;
            }
            Set elements = ((ServerMinPrincipal)constraint).elements();
            return ConnectionContext.ok(elements.size() == 1 && elements.contains(this.server));
        }
        if (constraint instanceof ConnectionAbsoluteTime) {
            return Math.max(((ConnectionAbsoluteTime)constraint).getTime(), 0L);
        }
        if (constraint instanceof ConnectionRelativeTime) {
            return ConnectionContext.ok(!this.clientSide);
        }
        return -4L;
    }

    private static long ok(boolean ok) {
        return ok ? Long.MAX_VALUE : -4L;
    }

    private long supported(ConstraintAlternatives constraint) {
        Set alts = constraint.elements();
        long connectionTime = -1L;
        Class<?> type = null;
        boolean supported = false;
        boolean integrity = false;
        for (InvocationConstraint alt : alts) {
            long r;
            if (type == null) {
                type = alt.getClass();
            } else if (type != alt.getClass()) {
                return -4L;
            }
            if ((r = this.supported(alt)) == -4L) continue;
            supported = true;
            if (r == -3L) {
                integrity = true;
                continue;
            }
            if (r <= connectionTime) continue;
            connectionTime = r;
        }
        if (!supported) {
            return -4L;
        }
        if (integrity) {
            return -3L;
        }
        if (connectionTime >= 0L) {
            return connectionTime;
        }
        return Long.MAX_VALUE;
    }
}

