/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.DgcRequestDispatcher;
import com.sun.jini.jeri.internal.runtime.ImplRefManager;
import com.sun.jini.jeri.internal.runtime.JvmLifeSupport;
import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.SequenceEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.ServerContext;
import net.jini.id.Uuid;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.security.SecurityContext;

final class Target {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
    private volatile ImplRefManager.ImplRef implRef;
    private final Uuid id;
    private final DgcRequestDispatcher[] requestDispatchers;
    private final boolean allowDGC;
    private final boolean keepAlive;
    private final SecurityContext securityContext;
    private final ClassLoader ccl;
    private final Lock lock = new ReentrantLock();
    private volatile InvocationDispatcher invocationDispatcher;
    private volatile boolean exported = false;
    private volatile boolean unexported = false;
    private volatile boolean success = false;
    private volatile boolean interrupted = false;
    private final Set<Uuid> referencedSet;
    private final Map<Uuid, SequenceEntry> sequenceTable;
    private final JvmLifeSupport keepAliveCount;
    private volatile boolean decrementedKeepAlive = false;
    private final ObjectTable objTable;
    private final Collection<Thread> calls = new ArrayList<Thread>();

    Target(Uuid id, DgcRequestDispatcher[] requestDispatchers, boolean allowDGC, boolean keepAlive, ObjectTable table, SecurityContext sc, ClassLoader contextCl, JvmLifeSupport counter) throws ExportException {
        this.objTable = table;
        this.id = id;
        this.requestDispatchers = requestDispatchers;
        this.allowDGC = allowDGC;
        this.keepAlive = keepAlive;
        this.keepAliveCount = counter;
        this.securityContext = sc;
        this.ccl = contextCl;
        if (allowDGC) {
            this.referencedSet = new HashSet<Uuid>(3);
            this.sequenceTable = new HashMap<Uuid, SequenceEntry>(3);
        } else {
            this.referencedSet = null;
            this.sequenceTable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void procRequestDispatchers() throws ExportException {
        if (this.exported) {
            throw new ExportException("Target already exported");
        }
        int i = 0;
        try {
            for (i = 0; i < this.requestDispatchers.length; ++i) {
                this.requestDispatchers[i].put(this);
            }
            this.success = true;
            Object var3_2 = null;
            if (this.success) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.success) throw throwable;
            for (int j = 0; j < i; ++j) {
                this.requestDispatchers[i].remove(this, false);
            }
            throw throwable;
        }
        for (int j = 0; j < i; ++j) {
            this.requestDispatchers[i].remove(this, false);
        }
        return;
    }

    void setImplRef(ImplRefManager.ImplRef implRef) throws ExportException {
        if (this.exported) {
            throw new ExportException("Target already exported");
        }
        this.implRef = implRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInvocationDispatcher(InvocationDispatcher id) {
        assert (id != null);
        this.lock.lock();
        try {
            assert (this.invocationDispatcher == null);
            this.invocationDispatcher = id;
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    void setExported() throws ExportException {
        if (this.exported) {
            throw new ExportException("Target already exported");
        }
        if (this.unexported) {
            throw new ExportException("Target cannot be re-exported");
        }
        if (this.implRef == null) {
            throw new ExportException("ImplRef cannot be null");
        }
        if (!this.success) {
            throw new ExportException("RequestDispatchers unsuccessful");
        }
        this.exported = true;
        if (this.keepAlive) {
            this.keepAliveCount.incrementKeepAliveCount();
        }
    }

    private void decrementKeepAliveCount() {
        if (this.keepAlive) {
            if (this.decrementedKeepAlive) {
                return;
            }
            this.decrementedKeepAlive = true;
            this.keepAliveCount.decrementKeepAliveCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unexport(boolean force) {
        block11: {
            if (!this.exported) {
                return true;
            }
            this.lock.lock();
            if (force || this.calls.isEmpty()) break block11;
            boolean bl = false;
            Object var5_5 = null;
            this.lock.unlock();
            return bl;
        }
        try {
            this.unexported = true;
            this.exported = false;
            if (force && !this.calls.isEmpty()) {
                this.interrupted = true;
                Iterator<Object> i = this.calls.iterator();
                while (i.hasNext()) {
                    i.next().interrupt();
                    i.remove();
                }
            }
            if (this.calls.isEmpty()) {
                this.decrementKeepAliveCount();
            }
            if (this.allowDGC) {
                if (!this.referencedSet.isEmpty()) {
                    for (Uuid clientID : this.referencedSet) {
                        this.objTable.unregisterTarget(this, clientID);
                    }
                    this.referencedSet.clear();
                }
                this.sequenceTable.clear();
            }
            Object var5_6 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        this.implRef.release(this);
        for (int i = 0; i < this.requestDispatchers.length; ++i) {
            this.requestDispatchers[i].remove(this, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collect() {
        if (!this.exported) {
            return;
        }
        this.lock.lock();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "garbage collection of object with id {0}", this.id);
            }
            this.unexported = true;
            this.exported = false;
            if (this.calls.isEmpty()) {
                this.decrementKeepAliveCount();
            }
            if (this.allowDGC) {
                assert (this.referencedSet.isEmpty());
                this.sequenceTable.clear();
            }
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
        for (int i = 0; i < this.requestDispatchers.length; ++i) {
            this.requestDispatchers[i].remove(this, true);
        }
    }

    Uuid getObjectIdentifier() {
        return this.id;
    }

    boolean getEnableDGC() {
        return this.allowDGC;
    }

    SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    ClassLoader getContextClassLoader() {
        return this.ccl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void referenced(Uuid clientID, long sequenceNum) {
        block10: {
            block11: {
                if (!this.allowDGC) {
                    return;
                }
                if (!this.exported) {
                    return;
                }
                this.lock.lock();
                try {
                    SequenceEntry entry;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}", new Object[]{this, clientID, new Long(sequenceNum)});
                    }
                    if ((entry = this.sequenceTable.get(clientID)) == null) {
                        entry = new SequenceEntry(sequenceNum);
                        this.sequenceTable.put(clientID, entry);
                    } else if (!entry.update(sequenceNum, false)) {
                        Object var7_4 = null;
                        this.lock.unlock();
                        return;
                    }
                    if (this.referencedSet.contains(clientID)) break block10;
                    if (this.referencedSet.isEmpty()) {
                        Remote impl = this.implRef.getImpl();
                        if (impl == null) {
                            break block11;
                        }
                        this.implRef.pin(this);
                    }
                    this.referencedSet.add(clientID);
                    this.objTable.registerTarget(this, clientID);
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            Object var7_5 = null;
            this.lock.unlock();
            return;
        }
        Object var7_6 = null;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unreferenced(Uuid clientID, long sequenceNum, boolean strong) {
        if (!this.allowDGC) {
            return;
        }
        if (!this.exported) {
            return;
        }
        this.lock.lock();
        try {
            SequenceEntry entry;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}, strong={3}", new Object[]{this, clientID, new Long(sequenceNum), strong});
            }
            if ((entry = this.sequenceTable.get(clientID)) == null) {
                if (strong) {
                    entry = new SequenceEntry(sequenceNum, strong);
                    this.sequenceTable.put(clientID, entry);
                }
            } else {
                if (!entry.update(sequenceNum, strong)) {
                    Object var7_5 = null;
                    this.lock.unlock();
                    return;
                }
                if (!entry.keep()) {
                    this.sequenceTable.remove(clientID);
                }
            }
            this.objTable.unregisterTarget(this, clientID);
            if (this.referencedSet.remove(clientID) && this.referencedSet.isEmpty()) {
                this.implRef.unpin(this);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var7_6 = null;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaseExpired(Uuid clientID) {
        assert (this.allowDGC);
        if (!this.exported) {
            return;
        }
        this.lock.lock();
        try {
            SequenceEntry entry;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, clientID={1}", new Object[]{this, clientID});
            }
            if ((entry = this.sequenceTable.get(clientID)) != null && !entry.keep()) {
                this.sequenceTable.remove(clientID);
            }
            if (this.referencedSet.remove(clientID) && this.referencedSet.isEmpty()) {
                this.implRef.unpin(this);
            }
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void interrupted(Thread currentThread) throws InterruptedException {
        if (currentThread.interrupted()) {
            throw new InterruptedException("Target interrupted during dispatch, unexported: " + this.unexported);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatch(InboundRequest request) throws IOException, ObjectTable.NoSuchObject {
        if (!this.exported) {
            if (!logger.isLoggable(Level.FINEST)) throw new ObjectTable.NoSuchObject();
            logger.log(Level.FINEST, "this={0}, not exported", this);
            throw new ObjectTable.NoSuchObject();
        }
        Thread current = Thread.currentThread();
        boolean exitNormally = true;
        boolean callerAdded = false;
        try {
            try {
                InvocationDispatcher id = null;
                this.lock.lockInterruptibly();
                try {
                    callerAdded = this.calls.add(current);
                    if (!this.exported || this.invocationDispatcher == null) {
                        if (!logger.isLoggable(Level.FINEST)) throw new ObjectTable.NoSuchObject();
                        logger.log(Level.FINEST, "this={0}, not exported", this);
                        throw new ObjectTable.NoSuchObject();
                    }
                    id = this.invocationDispatcher;
                    Object var7_7 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.lock.unlock();
                    throw throwable;
                }
                Remote impl = this.implRef.getImpl();
                if (impl == null) {
                    if (!logger.isLoggable(Level.FINEST)) throw new ObjectTable.NoSuchObject();
                    logger.log(Level.FINEST, "this={0}, garbage collected", this);
                    throw new ObjectTable.NoSuchObject();
                }
                this.interrupted(current);
                this.dispatch(request, id, impl, current);
                this.interrupted(current);
            }
            catch (InterruptedException ex) {
                exitNormally = false;
                request.abort();
                if (!this.interrupted) {
                    current.interrupt();
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, interrupted", this);
                }
                Object var9_12 = null;
                if (!exitNormally) {
                    if (!callerAdded) return;
                    if (this.interrupted) return;
                }
                this.lock.lock();
                try {}
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    this.lock.unlock();
                    throw throwable;
                }
                this.calls.remove(current);
                if (!this.exported && this.calls.isEmpty()) {
                    this.decrementKeepAliveCount();
                }
                Object var11_16 = null;
                this.lock.unlock();
                return;
            }
            Object var9_11 = null;
            if (!exitNormally) {
                if (!callerAdded) return;
                if (this.interrupted) return;
            }
            this.lock.lock();
            try {
                this.calls.remove(current);
                if (!this.exported && this.calls.isEmpty()) {
                    this.decrementKeepAliveCount();
                }
                Object var11_14 = null;
                this.lock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!exitNormally) {
                if (!callerAdded) throw throwable;
                if (this.interrupted) throw throwable;
            }
            this.lock.lock();
            try {}
            catch (Throwable throwable2) {
                Object var11_19 = null;
                this.lock.unlock();
                throw throwable2;
            }
            this.calls.remove(current);
            if (!this.exported && this.calls.isEmpty()) {
                this.decrementKeepAliveCount();
            }
            Object var11_18 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void dispatch(final InboundRequest request, final InvocationDispatcher id, final Remote impl, Thread t) throws IOException, ObjectTable.NoSuchObject {
        ClassLoader savedCcl = t.getContextClassLoader();
        try {
            try {
                if (this.ccl != savedCcl) {
                    t.setContextClassLoader(this.ccl);
                }
                AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, InterruptedException {
                        Target.this.dispatch(request, id, impl);
                        return null;
                    }
                }), this.securityContext.getAccessControlContext());
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            Object var8_6 = null;
            if (this.ccl != savedCcl || savedCcl != t.getContextClassLoader()) {
                t.setContextClassLoader(savedCcl);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (this.ccl != savedCcl || savedCcl != t.getContextClassLoader()) {
                t.setContextClassLoader(savedCcl);
            }
            throw throwable;
        }
    }

    private void dispatch(final InboundRequest request, final InvocationDispatcher id, final Remote impl) throws IOException, InterruptedException {
        request.checkPermissions();
        this.interrupted(Thread.currentThread());
        OutputStream out = request.getResponseOutputStream();
        out.write(1);
        final ArrayList context = new ArrayList(5);
        request.populateContext(context);
        ServerContext.doWithServerContext(new Runnable(){

            public void run() {
                id.dispatch(impl, request, context);
            }
        }, Collections.unmodifiableCollection(context));
    }

    public String toString() {
        return "Target@" + Integer.toHexString(this.hashCode()) + "[" + this.id + "]";
    }
}

