/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.Random;
import net.jini.io.context.AcknowledgmentSource;

public class HttpServerManager {
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private final AckListenerMap ackListeners;
    private final Object cookieLock = new Object();
    private long nextCookie = new Random().nextLong();

    public HttpServerManager(long ackTimeout) {
        this.ackListeners = new AckListenerMap(ackTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String newCookie() {
        Object object = this.cookieLock;
        synchronized (object) {
            return Long.toString(Math.abs(this.nextCookie++), 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAckListener(String cookie, AcknowledgmentSource.Listener listener) {
        if (cookie == null || listener == null) {
            throw new NullPointerException();
        }
        AckListenerMap ackListenerMap = this.ackListeners;
        synchronized (ackListenerMap) {
            LinkedList<AcknowledgmentSource.Listener> list = (LinkedList<AcknowledgmentSource.Listener>)this.ackListeners.get(cookie);
            if (list == null) {
                list = new LinkedList<AcknowledgmentSource.Listener>();
                this.ackListeners.put(cookie, list);
            }
            list.add(listener);
        }
    }

    void notifyAckListeners(String cookie) {
        if (cookie == null) {
            throw new NullPointerException();
        }
        final LinkedList list = (LinkedList)this.ackListeners.remove(cookie);
        if (list != null) {
            userThreadPool.execute(new Runnable(){

                public void run() {
                    HttpServerManager.doAckNotifications(list, true);
                }
            }, "Ack notifier");
        }
    }

    private static void doAckNotifications(LinkedList list, boolean recvd) {
        for (AcknowledgmentSource.Listener al : list) {
            try {
                al.acknowledgmentReceived(recvd);
            }
            catch (Throwable th) {}
        }
    }

    private static class AckListenerMap
    extends TimedMap {
        AckListenerMap(long timeout) {
            super(userThreadPool, timeout);
        }

        void evicted(Object key, Object value) {
            HttpServerManager.doAckNotifications((LinkedList)value, false);
        }
    }
}

