/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.DgcClient;
import com.sun.jini.jeri.internal.runtime.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.id.Uuid;
import net.jini.io.ObjectStreamContext;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class BasicObjectEndpoint
implements ObjectEndpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = 3235008605817758127L;
    private static final DgcClient dgcClient = new DgcClient();
    private static final Map streamBatches = new WeakHashMap(11);
    private final Endpoint ep;
    private final Uuid id;
    private final boolean dgc;
    private transient Object impl;

    public BasicObjectEndpoint(Endpoint ep, Uuid id, boolean enableDGC) {
        if (ep == null) {
            throw new NullPointerException("null endpoint");
        }
        if (id == null) {
            throw new NullPointerException("null object identifier");
        }
        this.ep = ep;
        this.id = id;
        this.dgc = enableDGC;
        if (this.dgc) {
            dgcClient.registerRefs(ep, Collections.singleton(this));
        }
    }

    BasicObjectEndpoint(Endpoint ep, Uuid id, boolean enableDGC, Object impl) {
        this.ep = ep;
        this.id = id;
        this.dgc = enableDGC;
        if (this.dgc) {
            this.impl = impl;
        }
    }

    public OutboundRequestIterator newCall(InvocationConstraints constraints) {
        final OutboundRequestIterator iter = this.ep.newRequest(constraints);
        return new OutboundRequestIterator(){

            public boolean hasNext() {
                return iter.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public OutboundRequest next() throws IOException {
                OutboundRequest call = iter.next();
                boolean ok = false;
                try {
                    BasicObjectEndpoint.this.id.write(call.getRequestOutputStream());
                    ok = true;
                    Object var4_3 = null;
                    if (!ok) {
                        call.abort();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!ok) {
                        call.abort();
                    }
                    throw throwable;
                }
                return call;
            }
        };
    }

    public RemoteException executeCall(OutboundRequest call) throws IOException {
        int status = call.getResponseInputStream().read();
        switch (status) {
            case -1: {
                throw new EOFException();
            }
            case 0: {
                return new NoSuchObjectException("no such object in table");
            }
            case 1: {
                return null;
            }
        }
        return new UnmarshalException("unexpected invocation status: " + Integer.toHexString(status));
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    public Uuid getObjectIdentifier() {
        return this.id;
    }

    public boolean getEnableDGC() {
        return this.dgc;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicObjectEndpoint)) {
            return false;
        }
        BasicObjectEndpoint other = (BasicObjectEndpoint)obj;
        return this.id.equals(other.id) && this.dgc == other.dgc && Util.sameClassAndEquals(this.ep, other.ep);
    }

    public boolean checkTrustEquivalence(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicObjectEndpoint)) {
            return false;
        }
        BasicObjectEndpoint other = (BasicObjectEndpoint)obj;
        return this.id.equals(other.id) && this.dgc == other.dgc && Util.checkTrustEquivalence(this.ep, other.ep);
    }

    public String toString() {
        return "BasicObjectEndpoint[" + (this.dgc ? "DGC," : "") + this.id + "," + this.ep + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.dgc && out instanceof ObjectStreamContext) {
            Collection context = ((ObjectStreamContext)((Object)out)).getObjectStreamContext();
            for (Object e : context) {
                if (!(e instanceof AcknowledgmentSource)) continue;
                AcknowledgmentSource ackSource = (AcknowledgmentSource)e;
                ackSource.addAcknowledgmentListener(new AckListener(this));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ep == null) {
            throw new InvalidObjectException("null endpoint");
        }
        if (this.id == null) {
            throw new InvalidObjectException("null object identifier");
        }
        if (this.dgc) {
            DgcBatchContext batchContext;
            Map map = streamBatches;
            synchronized (map) {
                batchContext = (DgcBatchContext)streamBatches.get(in);
                if (batchContext == null) {
                    batchContext = new DgcBatchContext();
                    try {
                        in.registerValidation(batchContext, 0);
                    }
                    catch (InvalidObjectException e) {
                        throw new AssertionError();
                    }
                    streamBatches.put(in, batchContext);
                }
            }
            batchContext.addLiveRef(this);
        }
    }

    private static class DgcBatchContext
    implements ObjectInputValidation {
        private final Map endpointTable = new HashMap(3);

        DgcBatchContext() {
        }

        void addLiveRef(BasicObjectEndpoint ref) {
            Endpoint endpoint = ref.getEndpoint();
            ArrayList<BasicObjectEndpoint> refList = (ArrayList<BasicObjectEndpoint>)this.endpointTable.get(endpoint);
            if (refList == null) {
                refList = new ArrayList<BasicObjectEndpoint>();
                this.endpointTable.put(endpoint, refList);
            }
            refList.add(ref);
        }

        public void validateObject() {
            for (Map.Entry entry : this.endpointTable.entrySet()) {
                Endpoint endpoint = (Endpoint)entry.getKey();
                Collection refList = (Collection)entry.getValue();
                dgcClient.registerRefs(endpoint, refList);
            }
            this.endpointTable.clear();
        }
    }

    private static class AckListener
    implements AcknowledgmentSource.Listener {
        private volatile BasicObjectEndpoint ref;

        AckListener(BasicObjectEndpoint ref) {
            this.ref = ref;
        }

        public void acknowledgmentReceived(boolean received) {
            this.ref = null;
        }
    }
}

