/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

class Header {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    private Map fields = new HashMap(5);

    Header() {
    }

    Header(InputStream in) throws IOException {
        String line = MessageReader.readLine(in);
        while (line != null && line.length() > 0) {
            String next = MessageReader.readLine(in);
            while (next != null && next.length() > 0 && Header.isSpaceOrTab(next.charAt(0))) {
                line = line + next;
                next = MessageReader.readLine(in);
            }
            int sepidx = line.indexOf(58);
            if (sepidx < 0) {
                throw new HttpParseException("header line missing separator");
            }
            String name = line.substring(0, sepidx).trim();
            String value = line.substring(sepidx + 1).trim();
            if (name.length() == 0) {
                throw new HttpParseException("invalid header field name");
            }
            this.addField(name, value);
            line = next;
        }
        if (line == null) {
            throw new HttpParseException("unexpected EOF in message header");
        }
    }

    String getField(String name) {
        return (String)this.fields.get(new FieldKey(name));
    }

    void setField(String name, String value) {
        FieldKey key = new FieldKey(name);
        if (value != null) {
            this.fields.put(key, value);
        } else {
            this.fields.remove(key);
        }
    }

    boolean containsValue(String name, String value, boolean ignoreCase) {
        String vlist = this.getField(name);
        if (vlist != null) {
            value = value.trim();
            StringTokenizer tok = new StringTokenizer(vlist, ",");
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken().trim();
                if (!(ignoreCase ? value.equalsIgnoreCase(v) : value.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    int size() {
        return this.fields.size();
    }

    void merge(Header header) {
        if (header != null) {
            for (Map.Entry e : header.fields.entrySet()) {
                this.addField(((FieldKey)e.getKey()).name, (String)e.getValue());
            }
        }
    }

    void write(OutputStream out) throws IOException {
        for (Map.Entry e : this.fields.entrySet()) {
            MessageWriter.writeLine(out, ((FieldKey)e.getKey()).name + ": " + (String)e.getValue());
        }
        MessageWriter.writeLine(out, "");
    }

    static String getDateString(long time) {
        return dateFormat.format(new Date(time));
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private void addField(String name, String value) {
        if (value != null) {
            FieldKey key = new FieldKey(name);
            String oldv = (String)this.fields.get(key);
            String newv = oldv != null ? oldv + ", " + value : value;
            this.fields.put(key, newv);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static class FieldKey {
        final String name;
        private final int hash;

        FieldKey(String name) {
            this.name = name;
            this.hash = name.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FieldKey) {
                return this.name.equalsIgnoreCase(((FieldKey)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

