/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.jeri.internal.http.HttpClientConnection;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.SslConnection;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;

public final class HttpsEndpoint
implements Endpoint,
Serializable,
TrustEquivalence {
    private static final long serialVersionUID = -3438786823613900804L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("serverHost", String.class), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("socketFactory", SocketFactory.class)};
    static final Map endpointMap = new HashMap();
    static final long IDLE_TIMEOUT;
    static final Executor systemExecutor;
    static final HttpClientManager httpClientManager;
    private transient HttpsEndpointImpl impl;

    public static HttpsEndpoint getInstance(String serverHost, int port) {
        return new HttpsEndpoint(serverHost, port, null);
    }

    public static HttpsEndpoint getInstance(String serverHost, int port, SocketFactory socketFactory) {
        return new HttpsEndpoint(serverHost, port, socketFactory);
    }

    private HttpsEndpoint(String serverHost, int port, SocketFactory socketFactory) {
        this.impl = new HttpsEndpointImpl(this, serverHost, port, socketFactory);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public String toString() {
        return "HttpsEndpoint" + this.impl.fieldsToString();
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof HttpsEndpoint && this.impl.equals(((HttpsEndpoint)object).impl);
    }

    public OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        return this.impl.newRequest(constraints);
    }

    public boolean checkTrustEquivalence(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof HttpsEndpoint && this.impl.equals(((HttpsEndpoint)obj).impl);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("serverHost", this.impl.serverHost);
        fields.put("port", this.impl.port);
        fields.put("socketFactory", this.impl.socketFactory);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        String serverHost = (String)fields.get("serverHost", null);
        int port = fields.get("port", 0);
        SocketFactory socketFactory = (SocketFactory)fields.get("socketFactory", null);
        if (serverHost == null) {
            throw new InvalidObjectException("serverHost cannot be null");
        }
        if (port <= 0 || port > 65535) {
            throw new InvalidObjectException("Invalid port: " + port);
        }
        this.impl = new HttpsEndpointImpl(this, serverHost, port, socketFactory);
    }

    static HttpSettings getHttpSettings() {
        return (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpSettings.getHttpSettings(true);
            }
        });
    }

    static {
        systemExecutor = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
        HttpSettings hs = HttpsEndpoint.getHttpSettings();
        IDLE_TIMEOUT = hs.getConnectionTimeout();
        httpClientManager = new HttpClientManager(hs.getResponseAckTimeout());
    }

    private static final class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done;
            ArrayList reap = new ArrayList(1);
            do {
                try {
                    Thread.sleep(IDLE_TIMEOUT);
                }
                catch (InterruptedException e) {
                    return;
                }
                long now = System.currentTimeMillis();
                Map map = endpointMap;
                synchronized (map) {
                    Iterator iter = endpointMap.values().iterator();
                    while (iter.hasNext()) {
                        EndpointInfo info = (EndpointInfo)iter.next();
                        if (!info.checkIdle(now, reap)) continue;
                        iter.remove();
                    }
                    done = endpointMap.isEmpty();
                }
                int i = reap.size();
                while (--i >= 0) {
                    try {
                        ((HttpsConnection)reap.get(i)).close();
                    }
                    catch (IOException e) {}
                }
                reap.clear();
            } while (!done);
        }
    }

    private static final class HttpsOutboundRequest
    implements OutboundRequest {
        private final OutboundRequest request;
        private final HttpsConnection connection;
        private final OutboundRequestHandle handle;

        HttpsOutboundRequest(OutboundRequest request, HttpsConnection connection, OutboundRequestHandle handle) {
            this.connection = connection;
            this.request = request;
            this.handle = handle;
        }

        public void populateContext(Collection context) {
            this.connection.populateContext(this.handle, context);
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            return this.connection.getUnfulfilledConstraints(this.handle);
        }

        public OutputStream getRequestOutputStream() {
            return this.request.getRequestOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.request.getResponseInputStream();
        }

        public boolean getDeliveryStatus() {
            return this.request.getDeliveryStatus();
        }

        public void abort() {
            this.request.abort();
        }
    }

    private static final class EndpointInfo {
        private final HttpsEndpointImpl endpoint;
        private String proxyHost = "";
        private int proxyPort = 0;
        private final List idle = new ArrayList(1);
        private final List inUse = new ArrayList(1);

        EndpointInfo(HttpsEndpointImpl endpoint) {
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpsConnection connect(CallContext context) throws IOException {
            HttpsConnection result;
            HttpSettings settings = HttpsEndpoint.getHttpSettings();
            String phost = settings.getProxyHost(this.endpoint.serverHost);
            int pport = phost.length() == 0 ? 0 : settings.getProxyPort();
            Object object = this;
            synchronized (object) {
                ArrayList reap = new ArrayList(0);
                if (!this.proxyHost.equals(phost) || this.proxyPort != pport) {
                    this.proxyHost = phost;
                    this.proxyPort = pport;
                    reap.addAll(this.idle);
                    this.idle.clear();
                } else {
                    this.checkIdle(System.currentTimeMillis(), reap);
                }
                int i = reap.size();
                while (--i >= 0) {
                    try {
                        ((HttpsConnection)reap.get(i)).close();
                    }
                    catch (IOException e) {}
                }
                result = (HttpsConnection)this.endpoint.connect(context, Collections.EMPTY_SET, this.idle);
                if (result != null) {
                    this.idle.remove(result);
                } else {
                    result = new HttpsConnection(this.endpoint, context, this.endpoint.serverHost, this.endpoint.port, phost, pport, this.endpoint.socketFactory);
                    result.establishCallContext();
                }
            }
            object = endpointMap;
            synchronized (object) {
                EndpointInfo info = (EndpointInfo)endpointMap.get(this.endpoint);
                if (info == null) {
                    if (endpointMap.isEmpty()) {
                        systemExecutor.execute(new Reaper(), "HttpsEndpointReaper");
                    }
                    endpointMap.put(this.endpoint, this);
                    info = this;
                }
                info.noteInUse(result);
            }
            return result;
        }

        synchronized void noteInUse(HttpsConnection connection) {
            this.inUse.add(connection);
        }

        synchronized void noteClosed(HttpsConnection connection) {
            this.inUse.remove(connection);
        }

        synchronized void noteIdle(HttpsConnection connection) {
            this.inUse.remove(connection);
            if (this.proxyHost.equals(connection.proxyHost) && this.proxyPort == connection.proxyPort) {
                this.idle.add(connection);
            } else {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        synchronized boolean checkIdle(long now, List reap) {
            int i = this.idle.size();
            while (--i >= 0) {
                HttpsConnection connection = (HttpsConnection)this.idle.get(i);
                if (!connection.checkIdle(now)) continue;
                reap.add(connection);
                this.idle.remove(connection);
            }
            return this.idle.isEmpty() && this.inUse.isEmpty();
        }
    }

    private static final class HttpClient
    extends HttpClientConnection {
        private final HttpsConnection connection;

        HttpClient(String host, int port, HttpsConnection connection) throws IOException {
            super(host, port, connection, httpClientManager);
            this.connection = connection;
        }

        HttpClient(String targetHost, int targetPort, String proxyHost, int proxyPort, HttpsConnection connection) throws IOException {
            super(targetHost, targetPort, proxyHost, proxyPort, true, true, connection, httpClientManager);
            this.connection = connection;
        }

        protected void idle() {
            this.connection.noteIdle();
        }

        public boolean shutdown(boolean force) {
            boolean result = super.shutdown(force);
            if (result) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    private static final class HttpsConnection
    extends SslConnection
    implements HttpClientSocketFactory {
        private final HttpsEndpointImpl endpoint;
        final String proxyHost;
        final int proxyPort;
        private HttpClientConnection httpClient;
        private long idleTime = 0L;

        HttpsConnection(HttpsEndpointImpl endpoint, CallContext context, String serverHost, int port, String proxyHost, int proxyPort, SocketFactory socketFactory) throws IOException {
            super(context, serverHost, port, socketFactory);
            this.endpoint = endpoint;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        void establishNewSocket() throws IOException {
            if (this.proxyHost.length() == 0) {
                this.httpClient = new HttpClient(this.serverHost, this.port, this);
            } else {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkConnect(this.serverHost, this.port);
                }
                try {
                    this.httpClient = (HttpClient)Security.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new HttpClient(HttpsConnection.this.serverHost, HttpsConnection.this.port, HttpsConnection.this.proxyHost, HttpsConnection.this.proxyPort, HttpsConnection.this);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
            }
        }

        OutboundRequest newRequest(CallContext callContext) throws IOException {
            HttpsOutboundRequest request = new HttpsOutboundRequest(this.httpClient.newRequest(), this, callContext);
            this.idleTime = 0L;
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            HttpsConnection httpsConnection = this;
            synchronized (httpsConnection) {
                if (this.closed) {
                    return;
                }
            }
            super.close();
            if (this.httpClient != null) {
                this.httpClient.shutdown(true);
                this.httpClient = null;
            }
        }

        boolean checkIdle(long now) {
            if (this.idleTime == 0L) {
                this.idleTime = now;
                return false;
            }
            return now - this.idleTime > IDLE_TIMEOUT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void noteIdle() {
            Map map = endpointMap;
            synchronized (map) {
                EndpointInfo info = (EndpointInfo)endpointMap.get(this.endpoint);
                if (info != null) {
                    info.noteIdle(this);
                }
                this.idleTime = 0L;
            }
        }

        public Socket createSocket(String host, int port) throws IOException {
            Socket s = this.createPlainSocket(host, port);
            if (this.proxyHost.length() == 0) {
                s = this.setSSLSocket((SSLSocket)this.sslSocketFactory.createSocket(s, host, port, true));
            }
            return s;
        }

        public Socket createTunnelSocket(Socket s) throws IOException {
            return this.setSSLSocket((SSLSocket)this.sslSocketFactory.createSocket(s, s.getInetAddress().getHostName(), s.getPort(), true));
        }

        private Socket setSSLSocket(SSLSocket newSocket) throws IOException {
            this.sslSocket = newSocket;
            this.establishSuites();
            return this.sslSocket;
        }

        boolean usesHttpProxy() {
            return this.proxyHost.length() != 0;
        }

        private boolean ping() throws IOException {
            return this.httpClient.ping();
        }

        protected String getProxyHost() {
            return this.proxyHost;
        }
    }

    private static final class HttpsEndpointImpl
    extends SslEndpointImpl {
        private long timeLastVerified;

        HttpsEndpointImpl(Endpoint endpoint, String serverHost, int port, SocketFactory socketFactory) {
            super(endpoint, serverHost, port, socketFactory);
        }

        OutboundRequestIterator newRequest(final CallContext callContext) {
            return new OutboundRequestIterator(){
                private boolean done;

                public synchronized boolean hasNext() {
                    return !this.done;
                }

                public synchronized OutboundRequest next() throws IOException {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return HttpsEndpointImpl.this.getOutboundRequest(callContext);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OutboundRequest getOutboundRequest(CallContext callContext) throws IOException {
            EndpointInfo info;
            HttpsConnection connection = null;
            Map map = endpointMap;
            synchronized (map) {
                info = (EndpointInfo)endpointMap.get(this);
                if (info == null) {
                    info = new EndpointInfo(this);
                }
            }
            connection = info.connect(callContext);
            boolean ok = false;
            try {
                HttpSettings settings;
                if (connection.usesHttpProxy() && (settings = HttpsEndpoint.getHttpSettings()).getPingProxyConnections()) {
                    long timeout = settings.getPingProxyConnectionTimeout();
                    long now = System.currentTimeMillis();
                    if (now - this.timeLastVerified > timeout) {
                        this.pingEndpoint(connection);
                        connection = info.connect(callContext);
                        this.timeLastVerified = System.currentTimeMillis();
                    }
                }
                OutboundRequest request = connection.newRequest(callContext);
                ok = true;
                logger.log(Level.FINE, "using {0}", connection);
                OutboundRequest outboundRequest = request;
                Object var11_11 = null;
                if (!ok) {
                    info.noteClosed(connection);
                }
                return outboundRequest;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var11_12 = null;
                    if (ok) break block9;
                    info.noteClosed(connection);
                }
                throw throwable;
            }
        }

        private void pingEndpoint(HttpsConnection connection) throws IOException {
            logger.log(Level.FINEST, "HTTP pinging {0}", connection);
            try {
                if (!connection.ping()) {
                    throw new IOException("HTTP ping via proxy failed.");
                }
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "pinging HTTP endpoint failed.");
                throw e;
            }
        }

        public Connection connect(OutboundRequestHandle handle) {
            throw new AssertionError((Object)"wrong connect method called");
        }
    }
}

