/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.jini.core.constraint.InvocationConstraint;

public final class DelegationAbsoluteTime
implements InvocationConstraint,
Serializable {
    private static final long serialVersionUID = -2807470616717350051L;
    private final long minStart;
    private final long maxStart;
    private final long minStop;
    private final long maxStop;
    private static SoftReference formatterRef;

    public DelegationAbsoluteTime(long minStart, long maxStart, long minStop, long maxStop) {
        if (minStart > maxStart || maxStart > minStop || minStop > maxStop) {
            throw new IllegalArgumentException("illegal times");
        }
        this.minStart = minStart;
        this.maxStart = maxStart;
        this.minStop = minStop;
        this.maxStop = maxStop;
    }

    public DelegationAbsoluteTime(Date minStart, Date maxStart, Date minStop, Date maxStop) {
        this(minStart.getTime(), maxStart.getTime(), minStop.getTime(), maxStop.getTime());
    }

    public long getMinStart() {
        return this.minStart;
    }

    public long getMaxStart() {
        return this.maxStart;
    }

    public long getMinStop() {
        return this.minStop;
    }

    public long getMaxStop() {
        return this.maxStop;
    }

    public int hashCode() {
        return (int)((long)DelegationAbsoluteTime.class.hashCode() + this.minStart + this.maxStart + this.minStop + this.maxStop);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DelegationAbsoluteTime)) {
            return false;
        }
        DelegationAbsoluteTime dc = (DelegationAbsoluteTime)obj;
        return this.minStart == dc.minStart && this.maxStart == dc.maxStart && this.minStop == dc.minStop && this.maxStop == dc.maxStop;
    }

    public String toString() {
        SimpleDateFormat formatter = DelegationAbsoluteTime.getFormatter();
        FieldPosition pos = new FieldPosition(0);
        StringBuffer buf = new StringBuffer(95);
        buf.append("DelegationAbsoluteTime[start: ");
        DelegationAbsoluteTime.format(this.minStart, this.maxStart, formatter, buf, pos);
        buf.append(", stop: ");
        DelegationAbsoluteTime.format(this.minStop, this.maxStop, formatter, buf, pos);
        buf.append(']');
        return buf.toString();
    }

    private static void format(long min, long max, SimpleDateFormat formatter, StringBuffer buf, FieldPosition pos) {
        if (min == max) {
            formatter.format(new Date(min), buf, pos);
        } else {
            buf.append('[');
            formatter.format(new Date(min), buf, pos);
            buf.append(", ");
            formatter.format(new Date(max), buf, pos);
            buf.append(']');
        }
    }

    private static synchronized SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = null;
        if (formatterRef != null) {
            formatter = (SimpleDateFormat)formatterRef.get();
        }
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSSS zzz", Locale.US);
            formatterRef = new SoftReference<SimpleDateFormat>(formatter);
        }
        return formatter;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.minStart > this.maxStart || this.maxStart > this.minStop || this.minStop > this.maxStop) {
            throw new InvalidObjectException("invalid times");
        }
    }
}

