/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import com.sun.jini.jeri.internal.http.Request;
import com.sun.jini.jeri.internal.http.ServerInfo;
import com.sun.jini.jeri.internal.http.StartLine;
import com.sun.jini.jeri.internal.http.TimedConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.OutboundRequest;

public class HttpClientConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final String clientString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + HttpClientConnection.class.getName();
        }
    });
    private static final int DIRECT = 0;
    private static final int PROXIED = 1;
    private static final int TUNNELED = 2;
    private static final int IDLE = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private final int mode;
    private final Object stateLock = new Object();
    private int state = 0;
    private final HttpClientManager manager;
    private ServerInfo targetInfo;
    private ServerInfo proxyInfo;
    private final boolean persist;
    private String[] acks;
    private Socket sock;
    private OutputStream out;
    private InputStream in;

    public HttpClientConnection(String host, int port, HttpClientSocketFactory factory, HttpClientManager manager) throws IOException {
        this.manager = manager;
        this.mode = 0;
        this.targetInfo = manager.getServerInfo(host, port);
        this.persist = true;
        this.setupConnection(factory);
    }

    public HttpClientConnection(String targetHost, int targetPort, String proxyHost, int proxyPort, boolean tunnel, boolean persist, HttpClientSocketFactory factory, HttpClientManager manager) throws IOException {
        this.manager = manager;
        this.mode = tunnel ? 2 : 1;
        this.targetInfo = manager.getServerInfo(targetHost, targetPort);
        this.proxyInfo = manager.getServerInfo(proxyHost, proxyPort);
        this.persist = persist || tunnel;
        this.setupConnection(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() throws IOException {
        this.markBusy();
        this.fetchServerInfo();
        try {
            boolean bl = this.ping(false);
            Object var3_2 = null;
            this.markIdle();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.markIdle();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest() throws IOException {
        OutboundRequestImpl req = null;
        this.markBusy();
        this.fetchServerInfo();
        try {
            OutboundRequestImpl outboundRequestImpl = req = new OutboundRequestImpl();
            Object var4_3 = null;
            if (req == null) {
                this.markIdle();
            }
            return outboundRequestImpl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (req != null) break block3;
                this.markIdle();
            }
            throw throwable;
        }
    }

    protected void idle() {
    }

    public Socket getSocket() {
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean force) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            if (!force && this.state == 1) {
                return false;
            }
            this.state = 2;
        }
        this.disconnect();
        return true;
    }

    private void fetchServerInfo() {
        ServerInfo sinfo = this.manager.getServerInfo(this.targetInfo.host, this.targetInfo.port);
        if (sinfo.timestamp > this.targetInfo.timestamp) {
            this.targetInfo = sinfo;
        }
        if (this.mode != 0) {
            sinfo = this.manager.getServerInfo(this.proxyInfo.host, this.proxyInfo.port);
            if (sinfo.timestamp > this.proxyInfo.timestamp) {
                this.proxyInfo = sinfo;
            }
        }
    }

    private void flushServerInfo() {
        this.manager.cacheServerInfo(this.targetInfo);
        if (this.mode != 0) {
            this.manager.cacheServerInfo(this.proxyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBusy() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                throw new IOException("connection busy");
            }
            if (this.state == 2) {
                throw new IOException("connection closed");
            }
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            this.state = 0;
        }
        this.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupConnection(HttpClientSocketFactory factory) throws IOException {
        boolean ok = false;
        try {
            for (int i = 0; i < 4; ++i) {
                if (this.sock == null) {
                    this.connect(factory);
                }
                if (this.mode == 1 && this.proxyInfo.timestamp == -1L) {
                    this.requestProxyOptions();
                    continue;
                }
                if (this.targetInfo.timestamp == -1L) {
                    this.ping(true);
                    continue;
                }
                ok = true;
                Object var5_4 = null;
                if (!ok) {
                    this.disconnect();
                }
                return;
            }
            Object var5_5 = null;
            if (!ok) {
                this.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!ok) {
                this.disconnect();
            }
            throw throwable;
        }
        throw new ConnectException("failed to establish HTTP connection");
    }

    private void connect(HttpClientSocketFactory factory) throws IOException {
        this.disconnect();
        for (int i = 0; i < 2; ++i) {
            if (this.sock == null) {
                ServerInfo sinfo = this.mode == 0 ? this.targetInfo : this.proxyInfo;
                this.sock = factory.createSocket(sinfo.host, sinfo.port);
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.in = new BufferedInputStream(this.sock.getInputStream());
            }
            if (this.mode != 2) {
                return;
            }
            if (!this.requestProxyConnect()) continue;
            this.sock = factory.createTunnelSocket(this.sock);
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.in = new BufferedInputStream(this.sock.getInputStream());
            return;
        }
        throw new ConnectException("failed to establish proxy tunnel");
    }

    private void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
            this.out = null;
            this.in = null;
        }
    }

    private boolean ping(boolean setup) throws IOException {
        Header inHeader;
        StartLine inLine;
        StartLine outLine = this.createPostLine();
        Header outHeader = this.createPostHeader(outLine);
        outHeader.setField("RMI-Request-Type", "ping");
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(outLine);
        writer.writeHeader(outHeader);
        writer.writeTrailer(null);
        do {
            MessageReader reader = new MessageReader(this.in, false);
            inLine = reader.readStartLine();
            inHeader = reader.readHeader();
            inHeader.merge(reader.readTrailer());
        } while (inLine.status / 100 == 1);
        this.analyzePostResponse(inLine, inHeader);
        if (!this.supportsPersist(inLine, inHeader)) {
            if (setup) {
                this.disconnect();
            } else {
                this.shutdown(true);
            }
        }
        return inLine.status / 100 == 2;
    }

    private boolean requestProxyOptions() throws IOException {
        Header inHeader;
        StartLine inLine;
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(new StartLine(1, 1, "OPTIONS", "*"));
        writer.writeHeader(this.createOptionsHeader());
        writer.writeTrailer(null);
        do {
            MessageReader reader = new MessageReader(this.in, false);
            inLine = reader.readStartLine();
            inHeader = reader.readHeader();
            inHeader.merge(reader.readTrailer());
        } while (inLine.status / 100 == 1);
        this.analyzeProxyResponse(inLine, inHeader);
        if (!this.supportsPersist(inLine, inHeader)) {
            this.disconnect();
        }
        return inLine.status / 100 == 2;
    }

    private boolean requestProxyConnect() throws IOException {
        Header inHeader;
        StartLine inLine;
        StartLine outLine = new StartLine(1, 1, "CONNECT", this.targetInfo.host + ":" + this.targetInfo.port);
        Header outHeader = this.createConnectHeader();
        String auth = this.proxyInfo.getAuthString("http", outLine.method, outLine.uri);
        if (auth != null) {
            outHeader.setField("Proxy-Authorization", auth);
        }
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(outLine);
        writer.writeHeader(outHeader);
        writer.writeTrailer(null);
        do {
            MessageReader reader = new MessageReader(this.in, true);
            inLine = reader.readStartLine();
            inHeader = reader.readHeader();
            inHeader.merge(reader.readTrailer());
        } while (inLine.status / 100 == 1);
        this.analyzeProxyResponse(inLine, inHeader);
        if (inLine.status / 100 == 2) {
            return true;
        }
        if (!this.supportsPersist(inLine, inHeader)) {
            this.disconnect();
        }
        return false;
    }

    private StartLine createPostLine() {
        String uri = this.mode == 1 ? "http://" + this.targetInfo.host + ":" + this.targetInfo.port + "/" : "/";
        return new StartLine(1, 1, "POST", uri);
    }

    private Header createBaseHeader() {
        Header header = new Header();
        long now = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(now));
        header.setField("User-Agent", clientString);
        return header;
    }

    private Header createConnectHeader() {
        Header header = this.createBaseHeader();
        header.setField("Host", this.targetInfo.host + ":" + this.targetInfo.port);
        return header;
    }

    private Header createOptionsHeader() {
        Header header = this.createBaseHeader();
        header.setField("Host", this.proxyInfo.host + ":" + this.proxyInfo.port);
        if (!this.persist) {
            header.setField("Connection", "close");
        }
        return header;
    }

    private Header createPostHeader(StartLine sline) {
        Header header = this.createBaseHeader();
        header.setField("Host", this.targetInfo.host + ":" + this.targetInfo.port);
        header.setField("Connection", this.persist ? "TE" : "close, TE");
        header.setField("TE", "trailers");
        String auth = this.targetInfo.getAuthString("http", sline.method, sline.uri);
        if (auth != null) {
            header.setField("Authorization", auth);
        }
        if (this.mode == 1 && (auth = this.proxyInfo.getAuthString("http", sline.method, sline.uri)) != null) {
            header.setField("Proxy-Authorization", auth);
        }
        this.acks = this.manager.getUnsentAcks(this.targetInfo.host, this.targetInfo.port);
        if (this.acks.length > 0) {
            String ackList = this.acks[0];
            for (int i = 1; i < this.acks.length; ++i) {
                ackList = ackList + ", " + this.acks[i];
            }
            header.setField("RMI-Response-Ack", ackList);
        }
        return header;
    }

    private void analyzePostResponse(StartLine inLine, Header inHeader) {
        long now = System.currentTimeMillis();
        String str = inHeader.getField("WWW-Authenticate");
        if (str != null) {
            try {
                this.targetInfo.setAuthInfo(str);
            }
            catch (HttpParseException ex) {
                // empty catch block
            }
            this.targetInfo.timestamp = now;
        } else {
            str = inHeader.getField("Authentication-Info");
            if (str != null) {
                try {
                    this.targetInfo.updateAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
                this.targetInfo.timestamp = now;
            }
        }
        if (this.mode != 0) {
            str = inHeader.getField("Proxy-Authenticate");
            if (str != null) {
                try {
                    this.proxyInfo.setAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
                this.proxyInfo.timestamp = now;
            } else {
                str = inHeader.getField("Proxy-Authentication-Info");
                if (str != null) {
                    try {
                        this.proxyInfo.updateAuthInfo(str);
                    }
                    catch (HttpParseException ex) {
                        // empty catch block
                    }
                    this.proxyInfo.timestamp = now;
                }
            }
        }
        if (this.mode != 1) {
            this.targetInfo.major = inLine.major;
            this.targetInfo.minor = inLine.minor;
            this.targetInfo.timestamp = now;
        } else {
            if (inLine.status == 407) {
                this.proxyInfo.major = inLine.major;
                this.proxyInfo.minor = inLine.minor;
            }
            this.proxyInfo.timestamp = now;
        }
        if (inLine.status / 100 == 2) {
            this.manager.clearUnsentAcks(this.targetInfo.host, this.targetInfo.port, this.acks);
            this.targetInfo.timestamp = now;
        }
        this.flushServerInfo();
    }

    private void analyzeProxyResponse(StartLine inLine, Header inHeader) {
        this.proxyInfo.major = inLine.major;
        this.proxyInfo.minor = inLine.minor;
        this.proxyInfo.timestamp = System.currentTimeMillis();
        String str = inHeader.getField("Proxy-Authenticate");
        if (str != null) {
            try {
                this.proxyInfo.setAuthInfo(str);
            }
            catch (HttpParseException ex) {}
        } else {
            str = inHeader.getField("Proxy-Authentication-Info");
            if (str != null) {
                try {
                    this.proxyInfo.updateAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
            }
        }
        this.flushServerInfo();
    }

    private boolean supportsChunking() {
        ServerInfo si = this.mode == 1 ? this.proxyInfo : this.targetInfo;
        return StartLine.compareVersions(si.major, si.minor, 1, 1) >= 0;
    }

    private boolean supportsPersist(StartLine sline, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (!this.persist) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0;
    }

    private class OutboundRequestImpl
    extends Request
    implements OutboundRequest {
        private final MessageWriter writer;
        private MessageReader reader;
        private StartLine inLine;
        private Header inHeader;
        private boolean persist = false;

        OutboundRequestImpl() throws IOException {
            StartLine outLine = HttpClientConnection.this.createPostLine();
            Header outHeader = HttpClientConnection.this.createPostHeader(outLine);
            outHeader.setField("RMI-Request-Type", "standard");
            this.writer = new MessageWriter(HttpClientConnection.this.out, HttpClientConnection.this.supportsChunking());
            this.writer.writeStartLine(outLine);
            this.writer.writeHeader(outHeader);
            this.writer.flush();
        }

        public void populateContext(Collection context) {
            if (context == null) {
                throw new NullPointerException();
            }
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            throw new AssertionError();
        }

        public OutputStream getRequestOutputStream() {
            return this.getOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.getInputStream();
        }

        void startOutput() throws IOException {
        }

        void write(byte[] b, int off, int len) throws IOException {
            this.writer.writeContent(b, off, len);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            while (true) {
                this.reader = new MessageReader(HttpClientConnection.this.in, false);
                this.inLine = this.reader.readStartLine();
                this.inHeader = this.reader.readHeader();
                if (this.inLine.status / 100 != 1) {
                    return this.inLine.status / 100 == 2;
                }
                this.reader.readTrailer();
            }
        }

        int read(byte[] b, int off, int len) throws IOException {
            return this.reader.readContent(b, off, len);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            this.inHeader.merge(this.reader.readTrailer());
            HttpClientConnection.this.analyzePostResponse(this.inLine, this.inHeader);
            this.persist = HttpClientConnection.this.supportsPersist(this.inLine, this.inHeader);
        }

        void addAckListener(AcknowledgmentSource.Listener listener) {
            throw new UnsupportedOperationException();
        }

        void done(boolean corrupt) {
            if (corrupt || !this.persist) {
                HttpClientConnection.this.shutdown(true);
            } else {
                HttpClientConnection.this.markIdle();
            }
        }
    }
}

