/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.mux.Session;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public class MuxServer
extends Mux {
    private static final int serverInitialInboundRation = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.connection.mux.server.initialInboundRation", 32768));
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private final RequestDispatcher requestDispatcher;
    private final SecurityContext securityContext;

    public MuxServer(OutputStream out, InputStream in, RequestDispatcher requestDispatcher) throws IOException {
        super(out, in, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    public MuxServer(SocketChannel channel, RequestDispatcher requestDispatcher) throws IOException {
        super(channel, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String message) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.serverConnectionReady && this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
            }
            this.setDown(message, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownGracefully() {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
                this.setDown("mux connection shut down gracefully", null);
                return true;
            }
            return false;
        }
    }

    protected void checkPermissions() {
    }

    protected InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints.requirements().isEmpty()) {
            return InvocationConstraints.EMPTY;
        }
        throw new UnsupportedConstraintException("cannot satisfy constraints: " + constraints);
    }

    protected void populateContext(Collection context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen(int sessionID) throws ProtocolException {
        Session session;
        assert (!Thread.holdsLock(this.muxLock));
        Object object = this.muxLock;
        synchronized (object) {
            if (!this.busySessions.get(sessionID)) {
                this.dispatchNewRequest(sessionID);
                return;
            }
            session = (Session)this.sessions.get(new Integer(sessionID));
            assert (session != null);
        }
        session.handleOpen();
        object = this.muxLock;
        synchronized (object) {
            this.dispatchNewRequest(sessionID);
        }
    }

    private void dispatchNewRequest(int sessionID) throws ProtocolException {
        assert (Thread.holdsLock(this.muxLock));
        if (this.muxDown) {
            throw new ProtocolException("connection down, cannot add new session");
        }
        final Session session = new Session(this, sessionID, 1);
        this.addSession(sessionID, session);
        try {
            userThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    final InboundRequest request = session.getInboundRequest();
                    try {
                        AccessController.doPrivileged(MuxServer.this.securityContext.wrap(new PrivilegedAction(){

                            public Object run() {
                                MuxServer.this.requestDispatcher.dispatch(request);
                                return null;
                            }
                        }), MuxServer.this.securityContext.getAccessControlContext());
                        Object var3_2 = null;
                        request.abort();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        request.abort();
                        throw throwable;
                    }
                }
            }, "mux request dispatch");
        }
        catch (OutOfMemoryError e) {
            try {
                logger.log(Level.WARNING, "could not create thread for request dispatch", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            session.abort();
        }
    }
}

