/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;

class Constraint {
    private Constraint() {
    }

    static Object[] trim(Object[] elements, int len) {
        if (len == elements.length) {
            return elements;
        }
        Object[] nelements = (Object[])Array.newInstance(elements.getClass().getComponentType(), len);
        System.arraycopy(elements, 0, nelements, 0, len);
        return nelements;
    }

    static int hash(Object[] elements) {
        int h = 0;
        int i = elements.length;
        while (--i >= 0) {
            h += elements[i].hashCode();
        }
        return h;
    }

    static boolean equal(Object[] arr1, Object[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = arr1.length;
        while (--i >= 0) {
            if (Constraint.contains(arr2, arr2.length, arr1[i])) continue;
            return false;
        }
        return true;
    }

    static boolean contains(Object[] arr, int i, Object obj) {
        while (--i >= 0) {
            if (!obj.equals(arr[i])) continue;
            return true;
        }
        return false;
    }

    static String toString(Object[] a) {
        String val;
        int i;
        if (a.length == 0) {
            return "{}";
        }
        if (a.length == 1) {
            String s = a[0] instanceof Class ? ((Class)a[0]).getName() : a[0].toString();
            return "{" + s + "}";
        }
        Object[] as = new String[a.length];
        int len = a.length * 2;
        if (a[0] instanceof Class) {
            i = a.length;
            while (--i >= 0) {
                val = ((Class)a[i]).getName();
                as[i] = val;
                len += val.length();
            }
        } else {
            i = a.length;
            while (--i >= 0) {
                val = a[i].toString();
                as[i] = val;
                len += val.length();
            }
        }
        Arrays.sort(as);
        StringBuffer buf = new StringBuffer(len);
        buf.append("{");
        for (int i2 = 0; i2 < as.length; ++i2) {
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append((String)as[i2]);
        }
        buf.append("}");
        return buf.toString();
    }

    static Principal[] reduce(Collection c) {
        try {
            return Constraint.reduce0(c.toArray(new Principal[c.size()]));
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException("element of collection is not a Principal");
        }
    }

    static Principal[] reduce(Principal[] principals) {
        return Constraint.reduce0((Principal[])principals.clone());
    }

    private static Principal[] reduce0(Principal[] principals) {
        if (principals.length == 0) {
            throw new IllegalArgumentException("cannot create constraint with no elements");
        }
        int i = 0;
        for (int j = 0; j < principals.length; ++j) {
            Principal p = principals[j];
            if (p == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(principals, i, p)) continue;
            principals[i++] = p;
        }
        return (Principal[])Constraint.trim(principals, i);
    }

    static void verify(Principal[] principals) throws InvalidObjectException {
        if (principals == null || principals.length == 0) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        int i = principals.length;
        while (--i >= 0) {
            Principal p = principals[i];
            if (p == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (!Constraint.contains(principals, i, p)) continue;
            throw new InvalidObjectException("cannot create constraint with duplicate elements");
        }
    }

    static Class[] reduce(Collection c, boolean keepSupers) {
        try {
            return Constraint.reduce0(c.toArray(new Class[c.size()]), keepSupers);
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException("element of collection is not a Class");
        }
    }

    static Class[] reduce(Class[] classes, boolean keepSupers) {
        return Constraint.reduce0((Class[])classes.clone(), keepSupers);
    }

    private static Class[] reduce0(Class[] classes, boolean keepSupers) {
        if (classes.length == 0) {
            throw new IllegalArgumentException("cannot create constraint with no elements");
        }
        int i = 0;
        block0: for (int j = 0; j < classes.length; ++j) {
            Class cj = classes[j];
            Constraint.verify(cj);
            int k = i;
            while (--k >= 0) {
                Class ck = classes[k];
                if (!keepSupers ? cj.isAssignableFrom(ck) : ck.isAssignableFrom(cj)) continue block0;
                if (!(keepSupers ? cj.isAssignableFrom(ck) : ck.isAssignableFrom(cj))) continue;
                classes[k] = classes[--i];
            }
            classes[i++] = cj;
        }
        return (Class[])Constraint.trim(classes, i);
    }

    static void verify(Class c) {
        if (c == null) {
            throw new NullPointerException("elements cannot be null");
        }
        if (c.isArray() || c.isPrimitive() || Modifier.isFinal(c.getModifiers()) && !Principal.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("invalid class");
        }
    }

    static void verify(Class[] classes) throws InvalidObjectException {
        if (classes == null || classes.length == 0) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        int i = classes.length;
        while (--i >= 0) {
            Class ci = classes[i];
            if (ci == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (ci.isArray() || ci.isPrimitive() || Modifier.isFinal(ci.getModifiers()) && !Principal.class.isAssignableFrom(ci)) {
                throw new InvalidObjectException("invalid class");
            }
            int j = i;
            while (--j >= 0) {
                Class cj = classes[j];
                if (!ci.isAssignableFrom(cj) && !cj.isAssignableFrom(ci)) continue;
                throw new InvalidObjectException("cannot create constraint with redundant elements");
            }
        }
    }
}

