/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.logging.Levels;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.AuthenticationPermission;

class ServerAuthManager
extends AuthManager {
    private static final Logger logger = serverLogger;
    private final SSLSessionContext sslSessionContext;
    private final X500PrivateCredential[] readOnlyPrivateCredentials;
    private final Map credentialCache = new HashMap(2);
    private Reference sessionCache = new SoftReference<Object>(null);
    private long credentialsValidUntil = 0L;

    ServerAuthManager(Subject subject, Set permittedPrincipals, SSLSessionContext sslSessionContext) throws NoSuchAlgorithmException {
        super(subject, permittedPrincipals, null);
        this.sslSessionContext = sslSessionContext;
        this.readOnlyPrivateCredentials = !this.subjectIsReadOnly || subject == null ? null : (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate getServerCertificate(SSLSession session) {
        Map map = this.credentialCache;
        synchronized (map) {
            X500PrivateCredential cred;
            Object val;
            if (this.sslSessionContext.getSession(session.getId()) != null && (val = this.credentialCache.get(ServerAuthManager.getKeyAlgorithm(session.getCipherSuite()))) instanceof X500PrivateCredential && !(cred = (X500PrivateCredential)val).isDestroyed()) {
                return cred.getCertificate();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCredentials(SSLSession session, Subject clientSubject) throws GeneralSecurityException {
        Map map = this.credentialCache;
        synchronized (map) {
            if (this.sslSessionContext.getSession(session.getId()) == null) {
                throw new SecurityException("Session not valid");
            }
            Object val = this.credentialCache.get(ServerAuthManager.getKeyAlgorithm(session.getCipherSuite()));
            if (val == null) {
                throw new SecurityException("No credential cached for key type");
            }
            if (val instanceof String) {
                throw new SecurityException((String)val);
            }
            X500PrivateCredential cred = (X500PrivateCredential)val;
            if (cred.isDestroyed()) {
                throw new SecurityException("Private credentials are destroyed");
            }
            if (this.subjectIsReadOnly && session.equals(this.sessionCache.get()) && System.currentTimeMillis() < this.credentialsValidUntil) {
                return;
            }
            this.credentialsValidUntil = this.checkCredentials(cred, clientSubject, "accept");
            this.sessionCache = new SoftReference<SSLSession>(session);
        }
    }

    private long checkCredentials(X500PrivateCredential cred, Subject clientSubject, String permissionAction) {
        Subject subject = this.getSubject();
        if (subject == null) {
            throw new SecurityException("Missing subject");
        }
        X509Certificate cert = cred.getCertificate();
        if (SubjectCredentials.getPrincipal(subject, cert) == null) {
            throw new SecurityException("Missing principal");
        }
        CertPath chain = SubjectCredentials.getCertificateChain(subject, cert);
        if (chain == null) {
            throw new SecurityException("Missing public credentials");
        }
        long validUntil = ServerAuthManager.certificatesValidUntil(chain);
        if (clientSubject != null) {
            assert (clientSubject.isReadOnly());
            CertPath clientChain = (CertPath)clientSubject.getPublicCredentials().iterator().next();
            validUntil = Math.min(validUntil, ServerAuthManager.certificatesValidUntil(clientChain));
        }
        if (System.currentTimeMillis() > validUntil) {
            throw new SecurityException("Certificates no longer valid");
        }
        String peer = this.getPeerPrincipalName(clientSubject);
        X500PrivateCredential pc = this.getPrivateCredential(cert, peer, permissionAction);
        if (pc == null) {
            throw new SecurityException("Missing private credentials");
        }
        if (!this.equalPrivateCredentials(cred, pc)) {
            throw new SecurityException("Wrong private credential");
        }
        return validUntil;
    }

    private String getPeerPrincipalName(Subject peerSubject) {
        if (peerSubject == null) {
            return null;
        }
        assert (peerSubject.isReadOnly());
        Principal p = peerSubject.getPrincipals().iterator().next();
        return p.getName();
    }

    Logger getLogger() {
        return logger;
    }

    X500PrivateCredential getPrivateCredential(X509Certificate cert) {
        return this.getPrivateCredential(cert, null, "listen");
    }

    private X500PrivateCredential getPrivateCredential(X509Certificate cert, String peer, String permissionAction) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.getAuthPermission(cert, peer, permissionAction));
        }
        if (this.subjectIsReadOnly) {
            int i = this.readOnlyPrivateCredentials.length;
            while (--i >= 0) {
                X500PrivateCredential xpc = this.readOnlyPrivateCredentials[i];
                if (!cert.equals(xpc.getCertificate())) continue;
                return xpc;
            }
            return null;
        }
        return (X500PrivateCredential)AccessController.doPrivileged(new SubjectCredentials.GetPrivateCredentialAction(subject, cert));
    }

    private AuthenticationPermission getAuthPermission(X509Certificate cert, String peer, String action) {
        Set<X500Principal> server = Collections.singleton(cert.getSubjectX500Principal());
        Set<X500Principal> client = peer == null ? null : Collections.singleton(new X500Principal(peer));
        return new AuthenticationPermission(server, client, action);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return null;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        Object[] result = this.getAliases(keyType, issuers);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "get server aliases for key type {0}\nand issuers {1}\nreturns {2}", new Object[]{keyType, ServerAuthManager.toString(issuers), ServerAuthManager.toString(result)});
        }
        return result;
    }

    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String result;
        X500PrivateCredential cred = null;
        Map map = this.credentialCache;
        synchronized (map) {
            Object val = this.credentialCache.get(keyType);
            if (val instanceof X500PrivateCredential) {
                cred = (X500PrivateCredential)val;
                try {
                    this.checkCredentials(cred, null, "listen");
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        ServerAuthManager.logThrow(logger, Levels.HANDLED, ServerAuthManager.class, "chooseServerAlias", "choose server alias for key type {0}\nand issuers {1}\ncaught exception", new Object[]{keyType, ServerAuthManager.toString(issuers)}, e);
                    }
                    cred = null;
                    this.credentialCache.remove(keyType);
                    Enumeration<byte[]> en = this.sslSessionContext.getIds();
                    while (en.hasMoreElements()) {
                        String suite;
                        SSLSession session = this.sslSessionContext.getSession(en.nextElement());
                        if (session == null || !keyType.equals(ServerAuthManager.getKeyAlgorithm(suite = session.getCipherSuite()))) continue;
                        session.invalidate();
                    }
                }
            }
            if (cred == null) {
                Exception exception = null;
                try {
                    cred = this.chooseCredential(keyType, issuers);
                    if (cred != null) {
                        this.credentialCache.put(keyType, cred);
                    }
                }
                catch (GeneralSecurityException e) {
                    exception = e;
                }
                catch (SecurityException e) {
                    exception = e;
                }
                if (exception != null) {
                    this.credentialCache.put(keyType, exception.getMessage());
                    return null;
                }
            }
        }
        String string = result = cred == null ? null : SubjectCredentials.getCertificateName(cred.getCertificate());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose server alias for key type {0}\nissuers {1}\nreturns {2}", new Object[]{keyType, ServerAuthManager.toString(issuers), result});
        }
        return result;
    }
}

