/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.request.impl;

import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.RemoteRunContext;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.RunStartLocation;
import com.sonicsw.esb.run.impl.Run;
import com.sonicsw.esb.run.request.BreakpointRequest;
import com.sonicsw.esb.run.request.EventRequest;
import com.sonicsw.esb.run.request.ReceiveRMEMessageRequest;
import com.sonicsw.esb.run.request.ReceiveResponseMessageRequest;
import com.sonicsw.esb.run.request.SendRunMessageRequest;
import com.sonicsw.esb.run.request.StepRequest;
import com.sonicsw.esb.run.request.impl.ReceiveFaultMessageRequest;
import com.sonicsw.esb.run.request.impl.StepIntoRequest;
import com.sonicsw.esb.run.request.impl.StepNextRequest;
import com.sonicsw.esb.run.request.impl.StepOutRequest;
import com.sonicsw.xq.XQMessage;
import java.util.LinkedList;
import java.util.List;

public class EventRequestManager
implements com.sonicsw.esb.run.request.EventRequestManager {
    protected final List m_requests = new LinkedList();
    protected final Run m_run;

    public EventRequestManager(Run test) {
        this.m_run = test;
    }

    public BreakpointRequest createBreakpointRequest(Location location) throws RunException {
        com.sonicsw.esb.run.request.impl.BreakpointRequest request = new com.sonicsw.esb.run.request.impl.BreakpointRequest(this.m_run.getRunProxy(), location);
        this.addRequest((EventRequest)request, location);
        return request;
    }

    public StepRequest createStepIntoRequest(RemoteRunContext remoteRunContext, Location location) throws RunException {
        StepIntoRequest request = new StepIntoRequest(this.m_run.getRunProxy(), remoteRunContext, location);
        this.addRequest((EventRequest)request, location);
        return request;
    }

    public StepRequest createStepNextRequest(RemoteRunContext remoteRunContext, Location location) throws RunException {
        StepNextRequest request = new StepNextRequest(this.m_run.getRunProxy(), remoteRunContext, location);
        this.addRequest((EventRequest)request, location);
        return request;
    }

    public StepRequest createStepOutRequest(RemoteRunContext remoteRunContext, Location location) throws RunException {
        StepOutRequest request = new StepOutRequest(this.m_run.getRunProxy(), remoteRunContext, location);
        this.addRequest((EventRequest)request, location);
        return request;
    }

    public SendRunMessageRequest createSendRunMessageRequest(XQMessage message) throws RunException {
        com.sonicsw.esb.run.impl.RunStartLocation l = new com.sonicsw.esb.run.impl.RunStartLocation();
        com.sonicsw.esb.run.request.impl.SendRunMessageRequest request = new com.sonicsw.esb.run.request.impl.SendRunMessageRequest(this.m_run.getRunProxy(), (Location)l, message, this.m_run);
        this.deleteAllSendRunMessageRequests();
        this.addRequest((EventRequest)request, (Location)l);
        return request;
    }

    public ReceiveResponseMessageRequest createReceiveResponseMessageRequest() throws RunException {
        com.sonicsw.esb.run.impl.RunStartLocation l = new com.sonicsw.esb.run.impl.RunStartLocation();
        com.sonicsw.esb.run.request.impl.ReceiveResponseMessageRequest request = new com.sonicsw.esb.run.request.impl.ReceiveResponseMessageRequest(this.m_run.getRunProxy(), (Location)l);
        this.addRequest((EventRequest)request, (Location)l);
        return request;
    }

    public com.sonicsw.esb.run.request.ReceiveFaultMessageRequest createReceiveFaultMessageRequest() throws RunException {
        com.sonicsw.esb.run.impl.RunStartLocation l = new com.sonicsw.esb.run.impl.RunStartLocation();
        ReceiveFaultMessageRequest request = new ReceiveFaultMessageRequest(this.m_run.getRunProxy(), (Location)l);
        this.addRequest((EventRequest)request, (Location)l);
        return request;
    }

    public ReceiveRMEMessageRequest createReceiveRMEMessageRequest() throws RunException {
        com.sonicsw.esb.run.impl.RunStartLocation l = new com.sonicsw.esb.run.impl.RunStartLocation();
        com.sonicsw.esb.run.request.impl.ReceiveRMEMessageRequest request = new com.sonicsw.esb.run.request.impl.ReceiveRMEMessageRequest(this.m_run.getRunProxy(), (Location)l);
        this.addRequest((EventRequest)request, (Location)l);
        return request;
    }

    public List getEventRequests() {
        return this.m_requests;
    }

    public List getEventRequests(Location atLocation) {
        LinkedList<EventRequest> requestsAtLocation = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!request.getLocation().same(atLocation)) continue;
            requestsAtLocation.add(request);
        }
        return requestsAtLocation;
    }

    public void deleteEventRequest(EventRequest requestToDelete) {
        this.m_requests.remove(requestToDelete);
    }

    public void deleteEventRequests(List requestsToDelete) {
        this.m_requests.removeAll(requestsToDelete);
    }

    public List getBreakpointRequests() {
        List breakpointRequests = this.retrieveBreakpointRequests();
        return breakpointRequests;
    }

    public List getStepRequests() {
        LinkedList<EventRequest> stepRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof StepRequest)) continue;
            stepRequests.add(request);
        }
        return stepRequests;
    }

    public void deleteAllBreakpointRequests() {
        List breakpointRequests = this.retrieveBreakpointRequests();
        this.m_requests.removeAll(breakpointRequests);
    }

    private List retrieveBreakpointRequests() {
        LinkedList<EventRequest> breakpointRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof BreakpointRequest)) continue;
            breakpointRequests.add(request);
        }
        return breakpointRequests;
    }

    public List getSendRunMessageRequests() {
        List sendMessageRequests = this.createMessageRequest();
        return sendMessageRequests;
    }

    public void deleteAllSendRunMessageRequests() {
        List sendTestMessageRequests = this.createMessageRequest();
        this.m_requests.removeAll(sendTestMessageRequests);
    }

    private List createMessageRequest() {
        LinkedList<EventRequest> sendTestMessageRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof SendRunMessageRequest)) continue;
            sendTestMessageRequests.add(request);
        }
        return sendTestMessageRequests;
    }

    public List getReceiveResponseMessageRequests() {
        LinkedList<EventRequest> receiveMessageRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof ReceiveResponseMessageRequest)) continue;
            receiveMessageRequests.add(request);
        }
        return receiveMessageRequests;
    }

    public List getReceiveFaultMessageRequests() {
        LinkedList<EventRequest> receiveMessageRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof com.sonicsw.esb.run.request.ReceiveFaultMessageRequest)) continue;
            receiveMessageRequests.add(request);
        }
        return receiveMessageRequests;
    }

    public List getReceiveRMEMessageRequests() {
        LinkedList<EventRequest> receiveMessageRequests = new LinkedList<EventRequest>();
        for (EventRequest request : this.m_requests) {
            if (!(request instanceof ReceiveRMEMessageRequest)) continue;
            receiveMessageRequests.add(request);
        }
        return receiveMessageRequests;
    }

    protected void addRequest(EventRequest request, Location location) throws RunException {
        this.m_requests.add(request);
        if (location instanceof RunStartLocation) {
            this.m_run.processStartLocationRequest(request);
        }
    }
}

