/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.asi.samples;

import javax.ejb.EJBContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class SonicSampleHelper {
    public static final int UNKNOWN_TXN_TYPE = -1;
    public static final int XA_TXN_TYPE = 1;
    public static final int NON_XA_TXN_TYPE = 2;
    private int m_txnType = -1;
    private final EJBContext m_ctx;

    public SonicSampleHelper(EJBContext ctx) {
        this.m_ctx = ctx;
    }

    public int getAppServerTxnType() {
        if (this.m_ctx != null && this.m_txnType == -1) {
            try {
                this.m_ctx.getRollbackOnly();
                this.m_txnType = 1;
            }
            catch (IllegalStateException ise) {
                this.m_txnType = 2;
            }
        }
        return this.m_txnType;
    }

    public boolean forceRollback(Message msg) {
        try {
            if (!msg.getJMSRedelivered() && msg instanceof TextMessage) {
                return this.forceRollback(((TextMessage)msg).getText());
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return false;
    }

    public boolean forceRollback(String text) {
        return this.m_txnType == 1 && text.indexOf("rollback") != -1;
    }
}

