/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.asi.samples;

import com.sonicsw.sonicmq.asi.samples.SonicSampleHelper;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class SonicSampleMDB
implements MessageDrivenBean,
MessageListener {
    private MessageDrivenContext m_ctx = null;
    private SonicSampleHelper m_helper = null;
    private int m_deliveredLimit = 10;

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.m_ctx = messageDrivenContext;
        this.m_helper = new SonicSampleHelper((EJBContext)this.m_ctx);
    }

    public void ejbCreate() {
        System.out.println("SonicSampleMDB.ejbCreate(), bean instance " + this.hashCode());
    }

    public void ejbRemove() throws EJBException {
        System.out.println("SonicSampleMDB.ejbRemove(), bean instance " + this.hashCode());
    }

    public void onMessage(Message message) {
        try {
            String destinationName;
            String destinationType;
            Destination destination;
            int deliveredCount = message.getIntProperty("JMSXDeliveryCount");
            if (deliveredCount > this.m_deliveredLimit) {
                System.out.println("Message delivered count " + deliveredCount + " greater than delivered limit " + this.m_deliveredLimit + ". Returning from onMessage() without further processing");
            }
            if ((destination = message.getJMSDestination()) instanceof Queue) {
                destinationType = "Queue";
                destinationName = ((Queue)destination).getQueueName();
            } else {
                destinationType = "Topic";
                destinationName = ((Topic)destination).getTopicName();
            }
            boolean forceRollback = false;
            TextMessage tm = (TextMessage)message;
            String phrase1 = "Message \"" + tm.getText() + "\", which was sent to " + destinationType + " " + destinationName + ", has been " + (message.getJMSRedelivered() ? "re" : "") + "delivered to SonicSampleMDB bean instance " + this.hashCode();
            String phrase2 = this.m_helper.getAppServerTxnType() == 1 ? ((forceRollback = this.m_helper.forceRollback(message)) ? " in an XA transaction that will be rolled back." : " in an XA transaction that will be committed.") : ".";
            System.out.println(phrase1 + phrase2);
            if (forceRollback) {
                this.m_ctx.setRollbackOnly();
                System.out.println("setRollbackOnly=" + this.m_ctx.getRollbackOnly());
            }
        }
        catch (JMSException e) {
            System.out.println("SonicSampleMDB.onMessage() unexpected exception " + String.valueOf((Object)e));
            e.printStackTrace();
        }
    }
}

