/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.asi.samples;

import com.sonicsw.sonicmq.asi.samples.SonicSampleHelper;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SonicSampleMDBReply
implements MessageDrivenBean,
MessageListener {
    private MessageDrivenContext m_ctx = null;
    private SonicSampleHelper m_helper = null;
    private ConnectionFactory m_outboundCF = null;
    private Destination m_outboundDest = null;
    private int m_deliveredLimit = 10;

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.m_ctx = messageDrivenContext;
        this.m_helper = new SonicSampleHelper((EJBContext)this.m_ctx);
    }

    public void ejbCreate() {
        System.out.println("SonicSampleMDBWithReply.ejbCreate(), bean instance " + this.hashCode());
        try {
            InitialContext jndi = new InitialContext();
            this.m_outboundDest = (Destination)jndi.lookup("java:comp/env/jms/SonicSampleOutboundDestination");
            boolean gotConnFactory = true;
            try {
                this.m_outboundCF = (ConnectionFactory)jndi.lookup("java:comp/env/jms/SonicSampleOutboundConnectionFactory");
                if (this.m_outboundCF == null) {
                    gotConnFactory = false;
                }
            }
            catch (Exception e) {
                gotConnFactory = false;
            }
            if (!gotConnFactory) {
                this.m_outboundCF = (ConnectionFactory)jndi.lookup("SonicJMS.Default.ConnectionFactory");
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void ejbRemove() throws EJBException {
        System.out.println("SonicSampleMDBWithReply.ejbRemove(), bean instance " + this.hashCode());
    }

    public void onMessage(Message message) {
        try {
            String destinationName;
            String destinationType;
            Destination inboundDest;
            int deliveredCount = message.getIntProperty("JMSXDeliveryCount");
            if (deliveredCount > this.m_deliveredLimit) {
                System.out.println("Message delivered count " + deliveredCount + " greater than delivered limit " + this.m_deliveredLimit + ". Returning from onMessage() without further processing");
            }
            if ((inboundDest = message.getJMSDestination()) instanceof Queue) {
                destinationType = "Queue";
                destinationName = ((Queue)inboundDest).getQueueName();
            } else {
                destinationType = "Topic";
                destinationName = ((Topic)inboundDest).getTopicName();
            }
            boolean forceRollback = false;
            TextMessage tm = (TextMessage)message;
            String phrase1 = "Message text \"" + tm.getText() + "\", which was sent to " + destinationType + " " + destinationName + ", has been " + (message.getJMSRedelivered() ? "re" : "") + "delivered to SonicSampleMDBWithReply bean instance " + this.hashCode();
            String phrase2 = this.m_helper.getAppServerTxnType() == 1 ? ((forceRollback = this.m_helper.forceRollback(message)) ? " in an XA transaction that will be rolled back." : " in an XA transaction that will be committed.") : ".";
            System.out.println(phrase1 + phrase2);
            String replyPhrase = this.sendReply(tm.getText(), forceRollback);
            System.out.println(replyPhrase);
            if (forceRollback) {
                this.m_ctx.setRollbackOnly();
                System.out.println("setRollbackOnly=" + this.m_ctx.getRollbackOnly());
            }
        }
        catch (JMSException e) {
            System.out.println("SonicSampleMDBWithReply.onMessage() unexpected exception " + String.valueOf((Object)e));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendReply(String originalText, boolean forceRollback) {
        String returnMsg = "Error sending reply to '" + originalText + "'. See application server log for more information.";
        Connection conn = null;
        int txnType = this.m_helper.getAppServerTxnType();
        try {
            String msgAction;
            conn = this.m_outboundCF.createConnection();
            Session session = conn.createSession(false, 1);
            conn.start();
            MessageProducer producer = session.createProducer(this.m_outboundDest);
            StringBuffer buffer = new StringBuffer("SonicSampleMDBWithReply " + this.hashCode() + " sending reply to \"" + originalText + "\" to " + String.valueOf(this.m_outboundDest));
            if (txnType == 1) {
                if (forceRollback) {
                    buffer.append(" in an XA transaction that will be rolled back.");
                } else {
                    buffer.append(" in an XA transaction that will be committed.");
                }
            } else {
                buffer.append(".");
            }
            TextMessage textMsg = session.createTextMessage(buffer.toString());
            producer.send((Message)textMsg);
            if (forceRollback) {
                this.m_ctx.setRollbackOnly();
                msgAction = "Rolled back the following message sent to ";
            } else {
                msgAction = "Sent the following message to ";
            }
            returnMsg = msgAction + String.valueOf(this.m_outboundDest) + ":\n" + textMsg.getText();
        }
        catch (Exception e) {
            returnMsg = "Exception " + String.valueOf(e) + " occurred sending reply'" + originalText + "' see Application Server log for more information.";
            System.out.println("SonicSampleMDBWithReply exception " + String.valueOf(e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    returnMsg = returnMsg + " Exception " + String.valueOf(e) + " occurred closing connection." + originalText;
                }
            }
        }
        return returnMsg;
    }
}

