/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.asi.samples;

import com.sonicsw.sonicmq.asi.samples.SonicSampleHelper;
import java.rmi.RemoteException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class SonicSampleSSB
implements SessionBean {
    private SessionContext m_ctx = null;
    private SonicSampleHelper m_helper = null;

    public void ejbCreate() throws EJBException, RemoteException {
        System.out.println("SonicSampleSSB.ebjCreate bean instance " + String.valueOf(this));
    }

    public void ejbRemove() throws EJBException, RemoteException {
        System.out.println("SonicSampleSSB.ebjRemove bean instance " + String.valueOf(this));
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        System.out.println("SonicSampleSSB.setSessionContext bean instance " + String.valueOf(this) + " session context " + String.valueOf(sessionContext));
        this.m_ctx = sessionContext;
        this.m_helper = new SonicSampleHelper((EJBContext)this.m_ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMessage(String message) {
        System.out.println("SonicSampleSSB.sendMessage bean instance " + String.valueOf(this));
        String returnMsg = "Error sending message'" + message + "'. See application server log for more information.";
        Connection conn = null;
        int txnType = this.m_helper.getAppServerTxnType();
        try {
            String msgAction;
            InitialContext jndi = new InitialContext();
            Object ref = jndi.lookup("java:comp/env/jms/SonicSampleSSBConnectionFactory");
            ConnectionFactory cf = (ConnectionFactory)ref;
            conn = cf.createConnection();
            Session session = conn.createSession(false, 1);
            conn.start();
            Destination outDest = (Destination)jndi.lookup("java:comp/env/jms/SonicSampleSSBDestination");
            MessageProducer producer = session.createProducer(outDest);
            boolean forceRollback = false;
            String phrase1 = "SonicSampleSSB " + this.hashCode() + " received request to send \"" + message + "\" to " + String.valueOf(outDest);
            String phrase2 = txnType == 1 ? ((forceRollback = this.m_helper.forceRollback(message)) ? " in an XA transaction that will be rolled back." : " in an XA transaction that will be committed.") : ".";
            TextMessage textMsg = session.createTextMessage(phrase1 + phrase2);
            producer.send((Message)textMsg);
            if (forceRollback) {
                this.m_ctx.setRollbackOnly();
                msgAction = "Rolled back the following message sent to ";
            } else {
                msgAction = "Sent the following message to ";
            }
            returnMsg = msgAction + String.valueOf(outDest) + ":\n" + textMsg.getText();
        }
        catch (Exception e) {
            returnMsg = "Exception " + String.valueOf(e) + " occurred sending message'" + message + "' see Application Server log for more information.";
            System.out.println("SonicSampleSSB exception " + String.valueOf(e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("SonicSampleSSB exception closing connection" + String.valueOf(e));
                    e.printStackTrace();
                }
            }
        }
        System.out.println(returnMsg);
        return returnMsg;
    }
}

