/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSTopicSubscriberAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicXASession;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.transaction.xa.XAResource;
import org.w3c.dom.Document;
import progress.message.jclient.MultiTopic;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.XMLMessage;
import progress.message.jclient.xa.XASession;

public class SonicXASessionAdapter
extends JMSSessionAdapter
implements SonicXASession {
    private XASession m_session;
    private progress.message.jclient.Session m_jclientSession;

    public SonicXASessionAdapter(JMSConnectionAdapter adapter, XASession session, JMSSessionManagedConnection mc) {
        super(adapter, (Session)session, mc);
        this.m_session = session;
        this.m_jclientSession = (progress.message.jclient.Session)session;
    }

    public void setDeferredAck(boolean deferredAck) throws JMSException {
        this.checkClosed();
        this.m_session.setDeferredAck(deferredAck);
    }

    public boolean isDeferredAck() throws JMSException {
        this.checkClosed();
        return this.m_session.isDeferredAck();
    }

    public Session getSession() throws JMSException {
        this.checkClosed();
        return this.m_session.getSession();
    }

    public XAResource getXAResource() {
        return this.m_session.getXAResource();
    }

    public XMLMessage createXMLMessage() throws JMSException {
        return this.m_jclientSession.createXMLMessage();
    }

    public XMLMessage createXMLMessage(String string) throws JMSException {
        return this.m_jclientSession.createXMLMessage(string);
    }

    public XMLMessage createXMLMessage(Document document) throws JMSException {
        return this.m_jclientSession.createXMLMessage(document);
    }

    public MultipartMessage createMultipartMessage() throws JMSException {
        return this.m_jclientSession.createMultipartMessage();
    }

    public void commit(String uuid) throws JMSException {
        this.m_jclientSession.commit(uuid);
    }

    public void commit(String uuid, long lifespan) throws JMSException {
        this.m_jclientSession.commit(uuid, lifespan);
    }

    public void setTxnBatchSize(int size) throws JMSException {
        this.m_jclientSession.setTxnBatchSize(size);
    }

    public int getTxnBatchSize() throws JMSException {
        return this.m_jclientSession.getTxnBatchSize();
    }

    public void setAckBatchingEnabled(boolean enabled) throws JMSException {
        this.m_jclientSession.setAckBatchingEnabled(enabled);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, long expiration) throws JMSException {
        TopicSubscriber subscriber = this.m_jclientSession.createDurableSubscriber(topic, name, expiration);
        return new JMSTopicSubscriberAdapter(subscriber, this.getManagedConnection());
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal, long expiration) throws JMSException {
        TopicSubscriber subscriber = this.m_jclientSession.createDurableSubscriber(topic, name, selector, noLocal, expiration);
        return new JMSTopicSubscriberAdapter(subscriber, this.getManagedConnection());
    }

    public void setFlowControlDisabled(boolean disable) {
        this.m_jclientSession.setFlowControlDisabled(disable);
    }

    public void setDurableMessageOrder(boolean order) {
        this.m_jclientSession.setDurableMessageOrder(order);
    }

    public boolean getDurableMessageOrder() {
        return this.m_jclientSession.getDurableMessageOrder();
    }

    public void setFlowToDisk(int ftd) {
        this.m_jclientSession.setFlowToDisk(ftd);
    }

    public int getFlowToDisk() {
        return this.m_jclientSession.getFlowToDisk();
    }

    public MultiTopic createMultiTopic() throws JMSException {
        this.checkClosed();
        return this.m_jclientSession.createMultiTopic();
    }

    public void setSplitMultiTopicDelivery(boolean arg0) {
        this.m_jclientSession.setSplitMultiTopicDelivery(arg0);
    }

    public boolean getSplitMultiTopicDelivery() {
        return this.m_jclientSession.getSplitMultiTopicDelivery();
    }

    public String getSessionName() {
        return this.m_session.getSessionName();
    }

    public void setSendTimeout(int milliseconds) throws JMSException {
        this.m_jclientSession.setSendTimeout(milliseconds);
    }

    public int getSendTimeout() {
        return this.m_jclientSession.getSendTimeout();
    }
}

