/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.JCAJMSConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ISessionCreator;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class JMSConnectionAdapter
implements JCAJMSConnection,
ISessionCreator {
    private static long s_applicationID = 0L;
    private static Object s_appIDSyncObject = new Object();
    private Connection m_connection;
    protected ConnectionManager m_cm;
    protected ManagedConnectionFactory m_mcf;
    private ConnectionTracking m_tracking;
    private boolean m_closed = false;
    private long m_appID;
    private String m_username;
    private boolean m_poolSessions = true;
    private ExceptionListener m_exceptionListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSConnectionAdapter(ConnectionTracking tracking, Connection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        this.m_connection = connection;
        this.m_mcf = mcf;
        this.m_cm = cm;
        this.m_tracking = tracking;
        this.m_username = mcf.getUsername();
        this.m_poolSessions = tracking.getPoolSessions();
        Object object = s_appIDSyncObject;
        synchronized (object) {
            this.m_appID = s_applicationID++;
        }
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(false, transacted, ackMode, this, this.getConnectionID(), 0, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            return (JMSSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        boolean transacted = sessionMode == 0;
        return this.createSession(transacted, sessionMode);
    }

    public Session createSession() throws JMSException {
        boolean transacted = false;
        return this.createSession(false, 1);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.m_connection.getClientID();
    }

    public void setClientID(String string) throws JMSException {
        this.checkClosed();
        this.m_connection.setClientID(string);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.m_connection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.m_exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        ConnectionTracking tracking = this.getConnectionTracking();
        if (this.m_exceptionListener != null) {
            tracking.removeExceptionListener(this.m_exceptionListener);
        }
        this.m_exceptionListener = exceptionListener;
        tracking.addExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.m_tracking.start(this.m_appID);
        this.m_connection.start();
    }

    public void stop() throws JMSException {
        this.checkClosed();
        this.m_tracking.stop(this.m_appID);
        this.m_connection.start();
    }

    public void close() throws JMSException {
        if (!this.m_closed) {
            if (this.m_exceptionListener != null) {
                this.getConnectionTracking().removeExceptionListener(this.m_exceptionListener);
            }
            this.m_closed = true;
            this.m_tracking.close(this.m_appID);
            JMSConnectionPool.freeCurrent(this.m_tracking);
            JMSConnectionPool.freeReference(this.m_tracking);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return this.m_connection.createConnectionConsumer(destination, messageSelector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return this.m_connection.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subsriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return this.m_connection.createDurableConnectionConsumer(topic, subsriptionName, messageSelector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return this.m_connection.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        Session session = mc.getJMSSession();
        if (session == null) {
            session = this.m_connection.createSession(isTransacted, ackMode);
            JMSConnectionPool.addReference(this.m_tracking);
            this.m_tracking.addChildObject(mc);
        }
        this.trackSession(mc);
        return new JMSSessionAdapter(this, (Session)((progress.message.jclient.Session)session), mc);
    }

    public void trackSession(JMSSessionManagedConnection mc) throws JMSException {
        JMSConnectionPool.addCurrent(this.m_tracking);
        this.getConnectionTracking().addAppChildObject(this.getAppID(), mc);
    }

    @Override
    public void cleanupSession(JMSSessionManagedConnection mc) {
        this.m_tracking.removeAppChildObject(this.m_appID, mc);
        JMSConnectionPool.freeCurrent(this.m_tracking);
    }

    @Override
    public void destroySession(JMSSessionManagedConnection mc) {
        this.m_tracking.removeChildObject(mc);
        JMSConnectionPool.freeReference(this.m_tracking);
    }

    protected void checkClosed() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public long getConnectionID() {
        return this.m_tracking.getConnectionID();
    }

    public long getAppID() {
        return this.m_appID;
    }

    public ConnectionTracking getConnectionTracking() {
        return this.m_tracking;
    }

    @Override
    public String getJMSProviderName() throws JMSException {
        return this.m_connection.getMetaData().getJMSProviderName();
    }

    @Override
    public String getJMSProviderVersion() throws JMSException {
        return this.m_connection.getMetaData().getProviderVersion();
    }

    public void setPoolSessions(boolean poolSessions) {
        this.m_poolSessions = poolSessions;
    }

    public boolean getPoolSessions() {
        return this.m_poolSessions;
    }

    public boolean getPreserveSessionsMidTxn() {
        return this.m_tracking.getPreserveSessionsMidTxn();
    }
}

