/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.IConnectionTrackingFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JCAGlobalProperties;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class JMSConnectionPool {
    private static Hashtable s_availableConnections = new Hashtable();
    private static Hashtable s_unavailableConnections = new Hashtable();
    private static Object m_poolSyncObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionTracking retrieveConnection(Object key, String username, String password) throws JMSException {
        Object object = m_poolSyncObject;
        synchronized (object) {
            LinkedList connections = (LinkedList)s_availableConnections.get(key);
            if (connections == null) {
                RAUtils.printDebug("UNABLE to find connections in available connections");
                return null;
            }
            Iterator iter = connections.iterator();
            int currentLowestCount = Integer.MAX_VALUE;
            ConnectionTracking currentLowestTracking = null;
            while (iter.hasNext()) {
                ConnectionTracking tracking = (ConnectionTracking)iter.next();
                if (!tracking.isForSameUser(username, password)) continue;
                int currentCount = tracking.getCurrentCount();
                if (currentCount == 0) {
                    JMSConnectionPool.addCurrent(tracking);
                    JMSConnectionPool.addReference(tracking);
                    if (RAUtils.isDebugEnabled()) {
                        RAUtils.printDebug("Added reference: " + tracking.getReferenceCount());
                    }
                    return tracking;
                }
                if (currentCount >= currentLowestCount) continue;
                currentLowestCount = currentCount;
                currentLowestTracking = tracking;
            }
            if (currentLowestTracking != null) {
                JMSConnectionPool.addCurrent(currentLowestTracking);
                JMSConnectionPool.addReference(currentLowestTracking);
                if (RAUtils.isDebugEnabled()) {
                    RAUtils.printDebug("Added reference: " + currentLowestTracking.getReferenceCount());
                    RAUtils.printDebug("RETURNING a pooled ConnectionTracking object");
                }
            }
            return currentLowestTracking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionTracking addConnection(IConnectionTrackingFactory ctf, Connection connection, String username, String password, Object key) throws JMSException {
        Object object = m_poolSyncObject;
        synchronized (object) {
            ConnectionTracking tracking = ctf.createConnectionTracking(key, connection, username, password);
            tracking.incCurrentCount();
            tracking.incReferenceCount();
            if (RAUtils.isDebugEnabled()) {
                RAUtils.printDebug("New connection, reference count is: " + tracking.getReferenceCount());
            }
            Hashtable targetTable = null;
            int refsPerConnection = JCAGlobalProperties.getReferencesPerConnection();
            if (refsPerConnection > 0 && tracking.getCurrentCount() >= refsPerConnection) {
                targetTable = s_unavailableConnections;
                tracking.setAvailable(false);
            } else {
                targetTable = s_availableConnections;
                tracking.setAvailable(true);
            }
            LinkedList<ConnectionTracking> connections = (LinkedList<ConnectionTracking>)targetTable.get(key);
            if (connections == null) {
                connections = new LinkedList<ConnectionTracking>();
                targetTable.put(key, connections);
            }
            connections.add(tracking);
            return tracking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCurrent(ConnectionTracking tracking) throws JMSException {
        Object object = m_poolSyncObject;
        synchronized (object) {
            if (tracking.isClosed()) {
                throw new IllegalStateException("Connection is closed");
            }
            Object key = tracking.getKey();
            tracking.incCurrentCount();
            if (tracking.isAvailable() && JCAGlobalProperties.getReferencesPerConnection() > 0 && tracking.getCurrentCount() >= JCAGlobalProperties.getReferencesPerConnection()) {
                LinkedList<ConnectionTracking> connections = (LinkedList<ConnectionTracking>)s_availableConnections.get(key);
                if (connections == null) {
                    RAUtils.printError("Connections not found upon add reference");
                    return;
                }
                connections.remove(tracking);
                if (connections.size() == 0) {
                    s_availableConnections.remove(key);
                }
                if ((connections = (LinkedList)s_unavailableConnections.get(key)) == null) {
                    connections = new LinkedList<ConnectionTracking>();
                    s_unavailableConnections.put(key, connections);
                }
                tracking.setAvailable(false);
                connections.add(tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeCurrent(ConnectionTracking tracking) {
        Object object = m_poolSyncObject;
        synchronized (object) {
            if (tracking.isClosed()) {
                return;
            }
            tracking.decCurrentCount();
            if (!tracking.isAvailable() && tracking.getCurrentCount() < JCAGlobalProperties.getReferencesPerConnection()) {
                Object key = tracking.getKey();
                LinkedList<ConnectionTracking> connections = (LinkedList<ConnectionTracking>)s_unavailableConnections.get(key);
                if (connections == null) {
                    RAUtils.printError("Connections not found upon free");
                    return;
                }
                RAUtils.printDebug("Freeing a ConnectionTracking obejct");
                connections.remove(tracking);
                if (connections.size() == 0) {
                    s_unavailableConnections.remove(key);
                }
                if ((connections = (LinkedList)s_availableConnections.get(key)) == null) {
                    connections = new LinkedList<ConnectionTracking>();
                    s_availableConnections.put(key, connections);
                }
                tracking.setAvailable(true);
                connections.add(tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReference(ConnectionTracking tracking) {
        Object object = m_poolSyncObject;
        synchronized (object) {
            if (tracking.isClosed()) {
                return;
            }
            tracking.incReferenceCount();
            if (RAUtils.isDebugEnabled()) {
                RAUtils.printDebug("Reference Count is now: " + tracking.getReferenceCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeReference(ConnectionTracking tracking) {
        Object object = m_poolSyncObject;
        synchronized (object) {
            if (tracking.isClosed()) {
                return;
            }
            tracking.decReferenceCount();
            int referenceCount = tracking.getReferenceCount();
            if (RAUtils.isDebugEnabled()) {
                RAUtils.printDebug("Reference count is now: " + referenceCount + " After free");
            }
            if (referenceCount <= 0) {
                block8: {
                    RAUtils.printDebug("Closing JMS Connection");
                    try {
                        tracking.getConnection().close();
                    }
                    catch (JMSException e) {
                        if (!RAUtils.isDebugEnabled()) break block8;
                        RAUtils.printStackTrace("Unexpected exception from tracking connection close", e);
                    }
                }
                JMSConnectionPool.cleanupConnection(tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupConnection(ConnectionTracking tracking) {
        Object object = m_poolSyncObject;
        synchronized (object) {
            LinkedList connections;
            tracking.setClosed();
            Hashtable target = s_availableConnections;
            if (!tracking.isAvailable()) {
                target = s_unavailableConnections;
            }
            if ((connections = (LinkedList)target.get(tracking.getKey())) != null) {
                connections.remove(tracking);
                if (connections.size() == 0) {
                    target.remove(tracking.getKey());
                }
            }
        }
    }

    public static Object getSyncObject() {
        return m_poolSyncObject;
    }

    public static int getConnectionCount() {
        return JMSConnectionPool.getTableConnectionCount(s_unavailableConnections) + JMSConnectionPool.getTableConnectionCount(s_availableConnections);
    }

    private static int getTableConnectionCount(Hashtable table) {
        int sum = 0;
        Enumeration connEnum = table.elements();
        while (connEnum.hasMoreElements()) {
            LinkedList list = (LinkedList)connEnum.nextElement();
            sum += list.size();
        }
        return sum;
    }
}

