/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.JCAGlobalProperties;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionManager;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicPropertiesHolder;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicConnectionFactoryProperties;
import java.io.PrintWriter;
import java.util.Set;
import javax.jms.JMSException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import progress.message.jclient.ConnectionFactory;

public class SonicManagedConnectionFactory
extends SonicPropertiesHolder
implements JMSManagedConnectionFactory,
SonicConnectionFactoryProperties {
    private ConnectionFactory m_factory = null;
    private Reference m_ref = null;
    protected ConnectionManager m_cm = null;
    private transient PrintWriter m_logWriter;

    protected void initConnectionManager(ConnectionManager cxManager) {
        Integer referencesPerConnection = this.getJCAJMSMaxReferencesPerConnection();
        if (referencesPerConnection != null) {
            JCAGlobalProperties.setReferencesPerConnection(referencesPerConnection);
        }
        this.m_cm = cxManager != null ? cxManager : new JMSConnectionManager();
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.initConnectionManager(cxManager);
        return this.createConnectionFactoryInternal();
    }

    public Object createConnectionFactory() throws ResourceException {
        this.initConnectionManager(new JMSConnectionManager());
        return this.createConnectionFactoryInternal();
    }

    protected Object createConnectionFactoryInternal() throws ResourceException {
        try {
            ConnectionFactory clonedFactory = new ConnectionFactory("");
            this.copyProperties(clonedFactory);
            return new SonicConnectionFactoryAdapter(clonedFactory, this.m_cm, this);
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        return new JMSSessionManagedConnection(this, subject, info);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        for (Object obj : connectionSet) {
            JMSSessionManagedConnection mc;
            if (!(obj instanceof JMSSessionManagedConnection) || (mc = (JMSSessionManagedConnection)obj).isDestroyed() || !mc.isCRIEqual((JMSConnectionRequestInfo)info)) continue;
            RAUtils.printDebug("FOUND MATCHING SESSION");
            return mc;
        }
        RAUtils.printDebug("DID NOT FIND MATCHING SESSION");
        return null;
    }

    private void initLogWriter() {
        if (this.m_logWriter == null) {
            this.m_logWriter = new PrintWriter(System.out);
        }
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.m_logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.initLogWriter();
        return this.m_logWriter;
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(this.getBrokerURL());
        buffer.append(this.getUsername());
        return buffer.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        SonicManagedConnectionFactory factory;
        if (obj == null) {
            return false;
        }
        if (obj instanceof SonicManagedConnectionFactory && (factory = (SonicManagedConnectionFactory)obj).getType() == this.getType()) {
            return super.equals(obj);
        }
        return false;
    }

    public Reference getReference() {
        return this.m_ref;
    }

    public void setReference(Reference ref) {
        this.m_ref = ref;
    }

    protected ConnectionManager getCM() {
        return this.m_cm;
    }

    public int getType() {
        return 0;
    }
}

