/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ILifeCycleable;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSExceptionListenerWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.resource.ResourceException;

public class ConnectionTracking {
    private static long s_connectionCounter = 0L;
    private long m_connectID = 0L;
    private Connection m_jmsConnection;
    private volatile int m_currentCount = 0;
    private volatile int m_referenceCount = 0;
    private String m_username;
    private String m_password;
    private boolean m_isAvailable = true;
    private HashSet m_childObjects = new HashSet();
    private Hashtable m_connectionObjectTracking = new Hashtable();
    private Object m_key;
    private volatile boolean m_isClosed = false;
    private Set m_exceptionListeners = Collections.synchronizedSet(new HashSet());
    private boolean m_poolSessions = true;
    private boolean m_preserveSessionsMidTxn = false;

    public ConnectionTracking(Object key, Connection connection, String username, String password) throws JMSException {
        this.m_connectID = ConnectionTracking.allocateConnectionID();
        this.m_jmsConnection = connection;
        this.m_username = username;
        this.m_password = password;
        this.m_key = key;
        this.registerListeners();
    }

    private static synchronized long allocateConnectionID() {
        return s_connectionCounter++;
    }

    int getCurrentCount() {
        return this.m_currentCount;
    }

    void incCurrentCount() {
        ++this.m_currentCount;
    }

    void decCurrentCount() {
        --this.m_currentCount;
    }

    int getReferenceCount() {
        return this.m_referenceCount;
    }

    void incReferenceCount() {
        ++this.m_referenceCount;
    }

    void decReferenceCount() {
        --this.m_referenceCount;
    }

    public Connection getConnection() {
        return this.m_jmsConnection;
    }

    public long getConnectionID() {
        return this.m_connectID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppChildObject(long appId, ILifeCycleable child) throws JMSException {
        Cloneable cloneable;
        if (this.m_isClosed) {
            throw new IllegalStateException("Connection is closed");
        }
        Long key = new Long(appId);
        LinkedList<ILifeCycleable> children = (LinkedList<ILifeCycleable>)this.m_connectionObjectTracking.get(key);
        if (children == null) {
            cloneable = this.m_connectionObjectTracking;
            synchronized (cloneable) {
                children = (LinkedList)this.m_connectionObjectTracking.get(key);
                if (children == null) {
                    children = new LinkedList<ILifeCycleable>();
                    this.m_connectionObjectTracking.put(key, children);
                }
            }
        }
        cloneable = children;
        synchronized (cloneable) {
            children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildObject(ILifeCycleable child) {
        HashSet hashSet = this.m_childObjects;
        synchronized (hashSet) {
            this.m_childObjects.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppChildObject(long appId, ILifeCycleable child) {
        Long key = new Long(appId);
        LinkedList children = (LinkedList)this.m_connectionObjectTracking.get(key);
        if (children == null) {
            return;
        }
        LinkedList linkedList = children;
        synchronized (linkedList) {
            children.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildObject(ILifeCycleable child) {
        HashSet hashSet = this.m_childObjects;
        synchronized (hashSet) {
            this.m_childObjects.remove(child);
        }
    }

    public boolean isForSameUser(String username, String password) {
        return this.bothNullOrEqual(this.m_username, username) && this.bothNullOrEqual(this.m_password, password);
    }

    private boolean bothNullOrEqual(Object object1, Object object2) {
        return RAUtils.bothNullOrEqual(object1, object2);
    }

    public Object getKey() {
        return this.m_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long appID) throws JMSException {
        Long key = new Long(appID);
        LinkedList children = (LinkedList)this.m_connectionObjectTracking.get(key);
        if (children == null) {
            return;
        }
        LinkedList linkedList = children;
        synchronized (linkedList) {
            children = (LinkedList)children.clone();
            for (ILifeCycleable child : children) {
                child.close();
            }
        }
        this.m_connectionObjectTracking.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long appID) throws JMSException {
        Long key = new Long(appID);
        LinkedList children = (LinkedList)this.m_connectionObjectTracking.get(key);
        if (children == null) {
            return;
        }
        LinkedList linkedList = children;
        synchronized (linkedList) {
            children = (LinkedList)children.clone();
            for (ILifeCycleable child : children) {
                child.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long appID) throws JMSException {
        Long key = new Long(appID);
        LinkedList children = (LinkedList)this.m_connectionObjectTracking.get(key);
        if (children == null) {
            return;
        }
        LinkedList linkedList = children;
        synchronized (linkedList) {
            children = (LinkedList)children.clone();
            for (ILifeCycleable child : children) {
                child.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        HashSet hashSet = this.m_childObjects;
        synchronized (hashSet) {
            return this.m_childObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppChildCount(long appID) {
        LinkedList list = (LinkedList)this.m_connectionObjectTracking.get(new Long(appID));
        if (list != null) {
            LinkedList linkedList = list;
            synchronized (linkedList) {
                return list.size();
            }
        }
        return 0;
    }

    public boolean isAvailable() {
        return this.m_isAvailable;
    }

    public void setAvailable(boolean available) {
        this.m_isAvailable = available;
    }

    public void setClosed() {
        this.m_isClosed = true;
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public boolean getPoolSessions() {
        return this.m_poolSessions;
    }

    public void setPoolSessions(boolean poolSessions) {
        this.m_poolSessions = poolSessions;
    }

    public boolean getPreserveSessionsMidTxn() {
        return this.m_preserveSessionsMidTxn;
    }

    public void setPreserveSessionsMidTxn(boolean preserveSessionsMidTxn) {
        this.m_preserveSessionsMidTxn = preserveSessionsMidTxn;
    }

    public void registerListeners() throws JMSException {
        Connection connection = this.getConnection();
        connection.setExceptionListener((ExceptionListener)new JMSExceptionListenerWrapper(this));
    }

    public void addExceptionListener(ExceptionListener listener) {
        if (listener != null) {
            this.m_exceptionListeners.add(listener);
        }
    }

    public void removeExceptionListener(ExceptionListener listener) {
        if (listener != null) {
            this.m_exceptionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFailed() {
        Object object = JMSConnectionPool.getSyncObject();
        synchronized (object) {
            JMSConnectionPool.cleanupConnection(this);
            this.setClosed();
        }
        object = this.m_childObjects;
        synchronized (object) {
            for (ILifeCycleable child : (HashSet)this.m_childObjects.clone()) {
                try {
                    child.error(null);
                }
                catch (ResourceException e) {
                    if (!RAUtils.isDebugEnabled()) continue;
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    public void fireExceptionListeners(JMSException e) {
        for (ExceptionListener listener : this.m_exceptionListeners) {
            listener.onException(e);
        }
    }
}

