/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.JCAJMSSession;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSMessageConsumerAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSMessageProducerAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSQueueBrowserAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSTemporaryQueueAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSTemporaryTopicAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSTopicSubscriberAdapter;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class JMSSessionAdapter
implements JCAJMSSession {
    private Session m_session;
    private JMSSessionManagedConnection m_mc;
    private boolean m_closed = false;
    private JMSConnectionAdapter m_connectionAdapter;

    public JMSSessionAdapter(JMSConnectionAdapter connection, Session session, JMSSessionManagedConnection mc) {
        this.m_session = session;
        this.m_mc = mc;
        this.m_connectionAdapter = connection;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        return this.m_session.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return this.m_session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        return this.m_session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.m_session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.m_session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.checkClosed();
        this.m_session.commit();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        this.m_session.rollback();
    }

    public void close() throws JMSException {
        if (this.m_closed) {
            return;
        }
        this.setClosed();
        this.m_mc.sendEvent(1, null, this);
    }

    public void recover() throws JMSException {
        this.checkClosed();
        this.m_session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.m_session.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        this.m_session.setMessageListener(messageListener);
    }

    public void run() {
        this.m_session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        MessageProducer mp = this.m_session.createProducer(destination);
        return new JMSMessageProducerAdapter(mp, this.getManagedConnection());
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createConsumer(destination);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createConsumer(destination, selector);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createConsumer(destination, selector, noLocal);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createSharedConsumer(topic, name);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name, String selector) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createSharedConsumer(topic, name, selector);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public Queue createQueue(String queue) throws JMSException {
        this.checkClosed();
        return this.m_session.createQueue(queue);
    }

    public Topic createTopic(String topic) throws JMSException {
        this.checkClosed();
        return this.m_session.createTopic(topic);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkClosed();
        TopicSubscriber subscriber = this.m_session.createDurableSubscriber(topic, name);
        return new JMSTopicSubscriberAdapter(subscriber, this.getManagedConnection());
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        TopicSubscriber subscriber = this.m_session.createDurableSubscriber(topic, name, selector, noLocal);
        return new JMSTopicSubscriberAdapter(subscriber, this.getManagedConnection());
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createDurableConsumer(topic, name);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createDurableConsumer(topic, name, selector, noLocal);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createSharedDurableConsumer(topic, name);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String selector) throws JMSException {
        this.checkClosed();
        MessageConsumer consumer = this.m_session.createSharedDurableConsumer(topic, name, selector);
        return new JMSMessageConsumerAdapter(consumer, this.getManagedConnection());
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        QueueBrowser browser = this.m_session.createBrowser(queue);
        return new JMSQueueBrowserAdapter(browser, this.getManagedConnection());
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        QueueBrowser browser = this.m_session.createBrowser(queue, selector);
        return new JMSQueueBrowserAdapter(browser, this.getManagedConnection());
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        TemporaryQueue queue = this.m_session.createTemporaryQueue();
        return new JMSTemporaryQueueAdapter(queue, this.m_connectionAdapter.getAppID(), this.m_connectionAdapter.getConnectionTracking());
    }

    public TemporaryQueue createTemporaryQueue(String customId) throws JMSException {
        this.checkClosed();
        TemporaryQueue queue = ((progress.message.jclient.Session)this.m_session).createTemporaryQueue(customId);
        return new JMSTemporaryQueueAdapter(queue, this.m_connectionAdapter.getAppID(), this.m_connectionAdapter.getConnectionTracking());
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        TemporaryTopic topic = this.m_session.createTemporaryTopic();
        return new JMSTemporaryTopicAdapter(topic, this.m_connectionAdapter.getAppID(), this.m_connectionAdapter.getConnectionTracking());
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        this.m_session.unsubscribe(name);
    }

    public Session getWrappedSession() {
        return this.m_session;
    }

    public JMSSessionManagedConnection getManagedConnection() {
        return this.m_mc;
    }

    public void setClosed() {
        this.m_closed = true;
    }

    protected void checkClosed() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public void stop() throws JMSException {
    }

    public void start() throws JMSException {
    }
}

