/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.IJMSXAResource;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements IJMSXAResource {
    private XAResource m_res;
    private boolean m_inTransaction = false;
    private Xid m_xidInTransaction = null;
    private JMSSessionManagedConnection m_mc = null;

    public XAResourceWrapper(XAResource res, JMSSessionManagedConnection mc) {
        this.m_res = res;
        this.m_mc = mc;
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper CTOR, managed connection=" + String.valueOf(this.m_mc));
        }
    }

    public XAResourceWrapper(XAResource res) {
        this.m_res = res;
        this.printDebug("\nXAResourceWrapper CTOR");
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.commit: " + XAResourceWrapper.xidToString(xid) + "," + onePhase);
        }
        this.m_res.commit(xid, onePhase);
        this.leaveTransaction(xid);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.end: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(flags));
        }
        this.m_res.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.forget: " + XAResourceWrapper.xidToString(xid));
        }
        this.m_res.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.m_res.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)xares;
            boolean result = this.m_res.isSameRM(other.m_res);
            if (RAUtils.isDebugEnabled()) {
                this.printDebug("\nXAResourceWrapper.isSameRM: " + this.m_res.hashCode() + "," + String.valueOf(other.m_res) + "," + result);
            }
            return result;
        }
        boolean result = this.m_res.isSameRM(xares);
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.isSameRM: " + this.m_res.hashCode() + "," + String.valueOf(xares) + "," + result);
        }
        return result;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.prepare: " + XAResourceWrapper.xidToString(xid));
        }
        int result = this.m_res.prepare(xid);
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("prepare result = " + XAResourceWrapper.flagToString(result) + " " + XAResourceWrapper.xidToString(xid));
        }
        return result;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.recover: " + XAResourceWrapper.flagToString(flag));
        }
        return this.m_res.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            if (RAUtils.isDebugEnabled()) {
                this.printDebug("\nXAResourceWrapper.rollback: " + XAResourceWrapper.xidToString(xid));
            }
            this.m_res.rollback(xid);
        }
        finally {
            this.leaveTransaction(xid);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.m_res.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.start: " + XAResourceWrapper.xidToString(xid) + "," + XAResourceWrapper.flagToString(flags));
        }
        this.enterTransaction(xid);
        this.m_res.start(xid, flags);
    }

    private void print(String s) {
        RAUtils.print(Thread.currentThread().getName() + " XAResource=" + this.hashCode() + " " + s);
    }

    private void printDebug(String s) {
        if (RAUtils.isDebugEnabled()) {
            RAUtils.printDebug(Thread.currentThread().getName() + " XAResource=" + this.hashCode() + " " + s);
        }
    }

    public static String xidToString(Xid xid) {
        return "GlobalId=" + new String(xid.getGlobalTransactionId()) + ", BranchQual=" + new String(xid.getBranchQualifier());
    }

    public static String flagToString(int flag) {
        switch (flag) {
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
            case 3: {
                return "XA_RDONLY";
            }
        }
        return Integer.toHexString(flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof XAResourceWrapper) {
            XAResource other = ((XAResourceWrapper)obj).m_res;
            return this.m_res.equals(other);
        }
        if (obj instanceof XAResource) {
            XAResource other = (XAResource)obj;
            return this.m_res.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this.m_res.hashCode();
    }

    @Override
    public synchronized boolean isInTransaction() {
        return this.m_inTransaction;
    }

    private synchronized void enterTransaction(Xid xid) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.enterTransaction: " + XAResourceWrapper.xidToString(xid));
        }
        while (this.isInTransaction() && !xid.equals(this.m_xidInTransaction)) {
            try {
                if (RAUtils.isDebugEnabled()) {
                    this.printDebug("\nin XAResourceWrapper enterTransaction: waiting for transaction to complete on another thread" + XAResourceWrapper.xidToString(xid));
                }
                this.wait();
            }
            catch (InterruptedException e) {
                throw new XAException("Thread interrupted in XAResourceWrapper.enterTransaction() while waiting for transaction to complete on another thread");
            }
        }
        this.m_xidInTransaction = xid;
        this.m_inTransaction = true;
    }

    private synchronized void leaveTransaction(Xid xid) throws XAException {
        if (RAUtils.isDebugEnabled()) {
            this.printDebug("\nXAResourceWrapper.leaveTransaction: " + XAResourceWrapper.xidToString(xid));
        }
        if (!this.isInTransaction()) {
            throw new XAException("leaveTransaction() called when not in a transaction, XAResource: " + String.valueOf(this.m_res));
        }
        if (xid.equals(this.m_xidInTransaction)) {
            this.m_xidInTransaction = null;
        }
        this.m_inTransaction = false;
        this.notifyAll();
    }

    public synchronized void waitForCompletion() throws XAException {
        this.printDebug("\nXAResourceWrapper.waitForCompletion");
        while (this.isInTransaction()) {
            try {
                if (RAUtils.isDebugEnabled()) {
                    this.printDebug("\nin XAResourceWrapper waitForCompletion waiting for transaction to complete on another thread");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                throw new XAException("Thread interrupted XAResourceWrapper.waitForCompletion() while waiting for transaction to complete on another thread");
            }
        }
    }
}

