/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicConnection;
import java.io.IOException;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.spi.ConnectionManager;
import progress.message.jclient.Channel;
import progress.message.jclient.ConnectionStateChangeListener;
import progress.message.jclient.RejectionListener;

public class SonicConnectionAdapter
extends JMSConnectionAdapter
implements SonicConnection {
    private progress.message.jclient.Connection m_connection;
    private ConnectionStateChangeListener m_conListener = null;
    private RejectionListener m_rejectionListener = null;

    public SonicConnectionAdapter(ConnectionTracking tracking, progress.message.jclient.Connection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        super(tracking, (Connection)connection, cm, mcf);
        this.m_connection = connection;
    }

    public boolean isEnterpriseEnabled() {
        return this.m_connection.isEnterpriseEnabled();
    }

    public String getBrokerURL() {
        return this.m_connection.getBrokerURL();
    }

    public String getRoutingNodeName() {
        return this.m_connection.getRoutingNodeName();
    }

    public String[] getStandbyBrokerReconnectURLs() {
        return this.m_connection.getStandbyBrokerReconnectURLs();
    }

    public String[] getBrokerReconnectURLs() {
        return this.m_connection.getBrokerReconnectURLs();
    }

    public int getConnectionState() {
        return this.m_connection.getConnectionState();
    }

    public void setConnectionStateChangeListener(ConnectionStateChangeListener connectionStateChangeListener) {
        SonicConnectionTracking sonicTracking = (SonicConnectionTracking)this.getConnectionTracking();
        if (this.m_conListener != null) {
            sonicTracking.removeConnectionListener(this.m_conListener);
        }
        sonicTracking.addConnectionListener(connectionStateChangeListener);
        this.m_conListener = connectionStateChangeListener;
    }

    public boolean isFaultTolerant() {
        return this.m_connection.isFaultTolerant();
    }

    public boolean isSecure() {
        return this.m_connection.isSecure();
    }

    public ConnectionStateChangeListener getConnectionStateChangeListener() {
        return this.m_conListener;
    }

    public String getConnectID() {
        return this.m_connection.getConnectID();
    }

    @Override
    public String getUsername() {
        return this.m_connection.getUsername();
    }

    public void setPingInterval(long interval) {
        this.m_connection.setPingInterval(interval);
    }

    public int getMonitorInterval() {
        return this.m_connection.getMonitorInterval();
    }

    public void setRejectionListener(RejectionListener rejectionListener) throws JMSException {
        this.checkClosed();
        SonicConnectionTracking sonicTracking = (SonicConnectionTracking)this.getConnectionTracking();
        if (this.m_rejectionListener != null) {
            sonicTracking.removeRejectionListener(this.m_rejectionListener);
        }
        this.m_rejectionListener = rejectionListener;
        ((SonicConnectionTracking)this.getConnectionTracking()).addRejectionListener(rejectionListener);
    }

    public boolean hasUnfinishedChannel(String channelID) throws JMSException {
        this.checkClosed();
        return this.m_connection.hasUnfinishedChannel(channelID);
    }

    public boolean hasUnfinishedChannels() throws JMSException {
        this.checkClosed();
        return this.m_connection.hasUnfinishedChannels();
    }

    public Channel getChannel(String channelID) throws JMSException, IOException {
        this.checkClosed();
        return this.m_connection.getChannel(channelID);
    }

    public Enumeration getUnfinishedChannels() throws JMSException, IOException {
        this.checkClosed();
        return this.m_connection.getUnfinishedChannels();
    }

    public Enumeration getUnfinishedChannelIDs() throws JMSException, IOException {
        this.checkClosed();
        return this.m_connection.getUnfinishedChannelIDs();
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        Session session = mc.getJMSSession();
        if (session == null) {
            session = this.m_connection.createSession(isTransacted, ackMode);
            JMSConnectionPool.addReference(this.getConnectionTracking());
            this.getConnectionTracking().addChildObject(mc);
        }
        this.trackSession(mc);
        SonicSessionAdapter adapter = new SonicSessionAdapter((JMSConnectionAdapter)this, (progress.message.jclient.Session)session, mc);
        return adapter;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        SonicConnectionTracking tracking = (SonicConnectionTracking)this.getConnectionTracking();
        if (this.m_rejectionListener != null) {
            tracking.removeRejectionListener(this.m_rejectionListener);
        }
        if (this.m_conListener != null) {
            tracking.removeConnectionListener(this.m_conListener);
        }
    }

    public Session createSession(boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }
}

