/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSContextAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.ISonicFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionFactoryPropertiesImpl;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicPooledConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicConnectionFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.naming.Reference;
import javax.resource.spi.ConnectionManager;
import progress.message.jclient.JMSExceptionUtils;

public class SonicConnectionFactoryAdapter
extends SonicConnectionFactoryPropertiesImpl
implements SonicConnectionFactory,
ISonicFactory {
    private Reference m_ref = null;
    private final progress.message.jclient.ConnectionFactory m_factory;
    private final ConnectionManager m_cm;
    private final JMSManagedConnectionFactory m_mcf;

    public SonicConnectionFactoryAdapter(progress.message.jclient.ConnectionFactory factory, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        Boolean preserveSessionsMidTxn;
        this.m_factory = factory;
        this.m_cm = cm;
        this.m_mcf = mcf;
        Boolean poolSessions = ((SonicManagedConnectionFactory)mcf).getJCAJMSPoolSessions();
        if (poolSessions != null) {
            this.setJCAJMSPoolSessions(poolSessions);
        }
        if ((preserveSessionsMidTxn = ((SonicManagedConnectionFactory)mcf).getJCAJMSPreserveSessionsMidTxn()) != null) {
            this.setJCAJMSPreserveSessionsMidTxn(preserveSessionsMidTxn);
        }
        this.initFactory(this.m_factory);
    }

    public Connection createConnection() throws JMSException {
        ConnectionTracking tracking = SonicPooledConnectionFactory.getPooledCF().createPooledConnection(this);
        return new SonicConnectionAdapter(tracking, (progress.message.jclient.Connection)tracking.getConnection(), this.getCM(), this.getMCF());
    }

    public Connection createConnection(String username, String password) throws JMSException {
        ConnectionTracking tracking = SonicPooledConnectionFactory.getPooledCF().createPooledConnection(this, username, password);
        SonicConnectionAdapter connection = new SonicConnectionAdapter(tracking, (progress.message.jclient.Connection)tracking.getConnection(), this.getCM(), this.getMCF());
        connection.setUsername(username);
        return connection;
    }

    public JMSContext createContext() {
        try {
            Connection connection = this.createConnection();
            return new JMSContextAdapter(connection);
        }
        catch (JMSException jmse) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)jmse);
        }
    }

    public JMSContext createContext(String userName, String password) {
        try {
            Connection connection = this.createConnection(userName, password);
            return new JMSContextAdapter(connection);
        }
        catch (JMSException jmse) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)jmse);
        }
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        SonicUtils.validateSessionMode(sessionMode);
        try {
            Connection connection = this.createConnection(userName, password);
            return new JMSContextAdapter(connection, sessionMode);
        }
        catch (JMSException jmse) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)jmse);
        }
    }

    public JMSContext createContext(int sessionMode) {
        SonicUtils.validateSessionMode(sessionMode);
        try {
            Connection connection = this.createConnection();
            return new JMSContextAdapter(connection, sessionMode);
        }
        catch (JMSException jmse) {
            throw JMSExceptionUtils.convertToRuntimeException((JMSException)jmse);
        }
    }

    @Override
    public final Connection getConnection() throws JMSException {
        return this.createConnection();
    }

    @Override
    public final JMSManagedConnectionFactory getMCF() {
        return this.m_mcf;
    }

    protected final ConnectionManager getCM() {
        return this.m_cm;
    }

    @Override
    public short getType() {
        return 0;
    }

    @Override
    public ConnectionFactory getFactory() {
        return this.m_factory;
    }

    @Override
    public progress.message.jclient.ConnectionFactory getMQConnectionFactory() {
        return this.m_factory;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ISonicFactory && ((ISonicFactory)obj).getType() == this.getType()) {
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public ConnectionTracking createConnectionTracking(Object key, Connection connection, String username, String password) throws JMSException {
        Boolean preserveSessionsMidTxn;
        Boolean poolSessions;
        Long pingInterval = this.getPingInterval();
        SonicConnectionTracking tracking = new SonicConnectionTracking(key, connection, username, password);
        if (pingInterval != null && pingInterval != 0L) {
            tracking.setInitialPingInterval(pingInterval);
        }
        if ((poolSessions = this.getJCAJMSPoolSessions()) != null) {
            tracking.setPoolSessions(poolSessions);
        }
        if ((preserveSessionsMidTxn = this.getJCAJMSPreserveSessionsMidTxn()) != null) {
            tracking.setPreserveSessionsMidTxn(preserveSessionsMidTxn);
        }
        return tracking;
    }

    public Reference getReference() {
        return this.m_ref;
    }

    public void setReference(Reference ref) {
        this.m_ref = ref;
    }
}

