/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.ISonicFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.QueueConnectionFactory;
import progress.message.jclient.TopicConnectionFactory;
import progress.message.jclient.xa.XAConnectionFactory;
import progress.message.jclient.xa.XAQueueConnectionFactory;
import progress.message.jclient.xa.XATopicConnectionFactory;

public class SonicPooledConnectionFactory {
    private static SonicPooledConnectionFactory s_cf = null;

    public static synchronized SonicPooledConnectionFactory getPooledCF() {
        if (s_cf == null) {
            s_cf = new SonicPooledConnectionFactory();
        }
        return s_cf;
    }

    public ConnectionTracking createPooledConnection(ISonicFactory factory) throws JMSException {
        return this.createPooledConnection(factory, factory.getType());
    }

    public ConnectionTracking createPooledConnection(ISonicFactory factory, String username, String password) throws JMSException {
        return this.createPooledConnection(factory, username, password, factory.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionTracking createPooledConnection(ISonicFactory factory, int type) throws JMSException {
        Object object = JMSConnectionPool.getSyncObject();
        synchronized (object) {
            ConnectionTracking tracking = JMSConnectionPool.retrieveConnection(factory, null, null);
            if (tracking == null) {
                javax.jms.ConnectionFactory jmsFactory = factory.getFactory();
                Connection connection = this.getConnection(jmsFactory, type);
                tracking = JMSConnectionPool.addConnection(factory, connection, null, null, factory);
            }
            return tracking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionTracking createPooledConnection(ISonicFactory factory, String username, String password, int type) throws JMSException {
        Object object = JMSConnectionPool.getSyncObject();
        synchronized (object) {
            ConnectionTracking tracking = JMSConnectionPool.retrieveConnection(factory, username, password);
            if (tracking == null) {
                javax.jms.ConnectionFactory jmsFactory = factory.getFactory();
                Connection connection = this.getConnection(jmsFactory, type, username, password);
                tracking = JMSConnectionPool.addConnection(factory, connection, username, password, factory.clone());
            }
            return tracking;
        }
    }

    private Connection getConnection(javax.jms.ConnectionFactory jmsFactory, int type, String username, String password) throws JMSException {
        Connection connection = null;
        switch (type) {
            case 0: {
                connection = ((ConnectionFactory)jmsFactory).createConnection(username, password);
                break;
            }
            case 2: {
                connection = ((QueueConnectionFactory)jmsFactory).createQueueConnection(username, password);
                break;
            }
            case 1: {
                connection = ((TopicConnectionFactory)jmsFactory).createTopicConnection(username, password);
                break;
            }
            case 3: {
                connection = ((XAConnectionFactory)jmsFactory).createXAConnection(username, password);
                break;
            }
            case 5: {
                connection = ((XAQueueConnectionFactory)jmsFactory).createXAQueueConnection(username, password);
                break;
            }
            case 4: {
                connection = ((XATopicConnectionFactory)jmsFactory).createXATopicConnection(username, password);
            }
        }
        return connection;
    }

    private Connection getConnection(javax.jms.ConnectionFactory jmsFactory, int type) throws JMSException {
        Connection connection = null;
        switch (type) {
            case 0: {
                connection = ((ConnectionFactory)jmsFactory).createConnection();
                break;
            }
            case 2: {
                connection = ((QueueConnectionFactory)jmsFactory).createQueueConnection();
                break;
            }
            case 1: {
                connection = ((TopicConnectionFactory)jmsFactory).createTopicConnection();
                break;
            }
            case 3: {
                connection = ((XAConnectionFactory)jmsFactory).createXAConnection();
                break;
            }
            case 5: {
                connection = ((XAQueueConnectionFactory)jmsFactory).createXAQueueConnection();
                break;
            }
            case 4: {
                connection = ((XATopicConnectionFactory)jmsFactory).createXATopicConnection();
            }
        }
        return connection;
    }
}

