/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicActivation;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicActivationSpec;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicServerSession;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class SonicServerSessionPool
implements ServerSessionPool {
    private final SonicActivation m_activation;
    private ArrayList m_availableSessions = new ArrayList();
    private ArrayList m_sessionsInUse = new ArrayList();
    private ConnectionConsumer m_consumer = null;
    private boolean m_stopped = false;

    public SonicServerSessionPool(SonicActivation activation) {
        this.m_activation = activation;
    }

    public SonicActivation getActivation() {
        return this.m_activation;
    }

    public void start() throws Exception {
        RAUtils.printDebug("SonicServerSessionPool.start() on Thread " + Thread.currentThread().getName());
        this.setupSessions();
        this.setupConsumer();
    }

    public void stop() {
        RAUtils.printDebug("SonicServerSessionPool.stop() on Thread " + Thread.currentThread().getName());
        this.teardownConsumer();
        this.teardownSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        SonicServerSession session = null;
        ArrayList arrayList = this.m_availableSessions;
        synchronized (arrayList) {
            while (true) {
                if (this.m_stopped) {
                    throw new JMSException("Unable to get a server session because the session pool is stopped");
                }
                if (!this.m_availableSessions.isEmpty()) break;
                if (this.getSessionCount() < this.m_activation.getActivationSpec().getMaxSessionsAsInt()) {
                    this.createServerSession();
                    continue;
                }
                try {
                    RAUtils.printDebug("SonicServerSessionPool.getServerSession() " + Thread.currentThread().getName() + "wait for available session");
                    this.m_availableSessions.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RAUtils.printDebug("SonicServerSessionPool.getServerSession() " + Thread.currentThread().getName() + " wait for available session ended");
            }
            session = (SonicServerSession)this.m_availableSessions.remove(0);
            this.m_sessionsInUse.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnServerSession(SonicServerSession serverSession) {
        ArrayList arrayList = this.m_availableSessions;
        synchronized (arrayList) {
            if (this.m_stopped) {
                RAUtils.printDebug("SonicServerSessionPool.returnServerSession() on " + Thread.currentThread().getName() + " m_stopped = " + this.m_stopped);
                serverSession.teardown();
            } else {
                if (!this.m_activation.isDeliveryTransacted()) {
                    try {
                        Session jmsSession = serverSession.getSession();
                        int ackMode = jmsSession.getAcknowledgeMode();
                        if (ackMode == 2 || ackMode == 1004) {
                            serverSession.getSession().recover();
                        }
                    }
                    catch (JMSException e) {
                        RAUtils.printException("Unexpected exception from Session.recover()", e);
                        e.printStackTrace();
                    }
                }
                RAUtils.printDebug("ServerSessionPool.returnServerSession() adding " + String.valueOf(serverSession) + " to pool");
                this.m_availableSessions.add(serverSession);
            }
            this.m_sessionsInUse.remove(serverSession);
            this.m_availableSessions.notifyAll();
        }
    }

    private SonicServerSession createServerSession() throws JMSException {
        SonicServerSession serverSession = new SonicServerSession(this);
        serverSession.setup();
        this.m_availableSessions.add(serverSession);
        RAUtils.printDebug("createServerSession() " + Thread.currentThread().getName() + " created serverSession #" + this.getSessionCount() + " " + String.valueOf(serverSession));
        return serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSessions() throws Exception {
        int initialSessionCount = this.m_activation.getActivationSpec().getMinSessionsAsInt();
        if (initialSessionCount > 0) {
            ArrayList arrayList = this.m_availableSessions;
            synchronized (arrayList) {
                for (int i = 0; i < initialSessionCount; ++i) {
                    this.createServerSession();
                }
            }
            RAUtils.printDebug("SonicServerSessionPool.setupSessions() " + Thread.currentThread().getName() + " minSessions=" + initialSessionCount + " maxSessions=" + this.m_activation.getActivationSpec().getMaxSessions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardownSessions() {
        ArrayList arrayList = this.m_availableSessions;
        synchronized (arrayList) {
            SonicServerSession session;
            int i;
            this.m_stopped = true;
            this.m_availableSessions.notifyAll();
            for (i = 0; i < this.m_availableSessions.size(); ++i) {
                session = (SonicServerSession)this.m_availableSessions.get(i);
                RAUtils.printDebug("SonicServerSessionPool.teardownSessions() " + Thread.currentThread().getName() + " teardown available session " + String.valueOf(session));
                session.teardown();
            }
            this.m_availableSessions.clear();
            if (this.m_sessionsInUse.size() > 0) {
                for (i = 0; i < this.m_sessionsInUse.size(); ++i) {
                    RAUtils.printDebug("teardownSessions() : tearing down session #" + i + " of " + this.m_sessionsInUse.size());
                    session = (SonicServerSession)this.m_sessionsInUse.get(i);
                    session.teardown();
                }
                this.m_sessionsInUse.clear();
            }
            RAUtils.printDebug("teardownSessions()  " + Thread.currentThread().getName());
        }
    }

    protected void setupConsumer() throws JMSException {
        Connection connection = this.m_activation.getConnection();
        SonicActivationSpec spec = this.m_activation.getActivationSpec();
        String selector = spec.getMessageSelector();
        int maxMessages = spec.getMaxMessagesAsInt();
        if (spec.isTopic()) {
            Topic topic = (Topic)this.m_activation.getDestination();
            String subscriptionName = spec.getSubscriptionName();
            if (spec.isDurable()) {
                this.m_consumer = connection.createDurableConnectionConsumer(topic, subscriptionName, selector, (ServerSessionPool)this, maxMessages);
                RAUtils.printDebug("SonicServerSessionPool.setupConsumer() created DurableConnectionConsumer " + String.valueOf(this.m_consumer) + " for Topic " + String.valueOf(topic) + " subscriptionName " + subscriptionName);
            } else {
                this.m_consumer = connection.createConnectionConsumer((Destination)topic, selector, (ServerSessionPool)this, maxMessages);
                RAUtils.printDebug("SonicServerSessionPool.setupConsumer() created ConnectionConsumer " + String.valueOf(this.m_consumer) + " for Topic " + String.valueOf(topic));
            }
        } else {
            Queue queue = (Queue)this.m_activation.getDestination();
            this.m_consumer = connection.createConnectionConsumer((Destination)queue, selector, (ServerSessionPool)this, maxMessages);
            RAUtils.printDebug("SonicServerSessionPool.setupConsumer() created ConnectionConsumer " + String.valueOf(this.m_consumer) + " for Queue " + String.valueOf(queue));
        }
    }

    protected void teardownConsumer() {
        try {
            if (this.m_consumer != null) {
                RAUtils.printDebug("teardownConsumer() closing the " + String.valueOf(this.m_consumer));
                this.m_consumer.close();
            }
        }
        catch (Throwable t) {
            RAUtils.printException("teardownConsumer() unable to close consumer " + String.valueOf(this.m_consumer), t);
        }
    }

    private int getSessionCount() {
        return this.m_availableSessions.size() + this.m_sessionsInUse.size();
    }
}

