/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ILifeCycleable;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicSession;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import org.w3c.dom.Document;
import progress.message.jclient.MultiTopic;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.Session;
import progress.message.jclient.XMLMessage;

public class SonicSessionWrapper
implements SonicSession,
ILifeCycleable {
    private Session m_session = null;
    private JMSSessionManagedConnection m_parentMC;
    private boolean m_closed = false;
    private boolean m_poolSessions = true;

    public SonicSessionWrapper(Session session, JMSSessionManagedConnection mc, boolean poolSessions) {
        this.m_session = session;
        this.m_parentMC = mc;
        this.m_parentMC.addChild(this);
        this.m_poolSessions = poolSessions;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.m_session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.m_session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.m_session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.m_session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.m_session.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.m_session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.m_session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.m_session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        return this.m_session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.m_session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.m_session.commit();
    }

    public void rollback() throws JMSException {
        this.m_session.rollback();
    }

    @Override
    public void close() throws JMSException {
        if (!this.m_closed) {
            this.m_closed = true;
            this.m_parentMC.sendEvent(1, null, this);
            this.m_parentMC.removeChild(this);
            this.m_session.close();
        }
    }

    @Override
    public void cleanup() throws ResourceException {
        if (!this.m_closed) {
            this.m_closed = true;
            this.m_parentMC.removeChild(this);
            try {
                this.m_session.close();
            }
            catch (JMSException e) {
                EISSystemException se = new EISSystemException(e.getMessage());
                se.setLinkedException((Exception)((Object)e));
                throw se;
            }
        }
    }

    public void recover() throws JMSException {
        this.m_session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.m_session.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.m_session.setMessageListener(messageListener);
    }

    public void run() {
        this.m_session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.m_session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.m_session.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.m_session.createConsumer(destination, selector);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.m_session.createConsumer(destination, selector, noLocal);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.m_session.createSharedConsumer(topic, sharedSubscriptionName);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.m_session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public Queue createQueue(String queue) throws JMSException {
        return this.m_session.createQueue(queue);
    }

    public Topic createTopic(String topic) throws JMSException {
        return this.m_session.createTopic(topic);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.m_session.createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.m_session.createDurableSubscriber(topic, name, selector, noLocal);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.m_session.createDurableConsumer(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.m_session.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.m_session.createSharedDurableConsumer(topic, name);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.m_session.createSharedDurableConsumer(topic, name, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.m_session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.m_session.createBrowser(queue, selector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.m_session.createTemporaryQueue();
    }

    public TemporaryQueue createTemporaryQueue(String customId) throws JMSException {
        return this.m_session.createTemporaryQueue(customId);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.m_session.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.m_session.unsubscribe(name);
    }

    @Override
    public void destroy() throws ResourceException {
        try {
            this.m_closed = true;
            this.m_parentMC.removeChild(this);
            this.m_session.close();
        }
        catch (JMSException e) {
            EISSystemException eis = new EISSystemException(e.getMessage());
            eis.setLinkedException((Exception)((Object)e));
            throw eis;
        }
    }

    @Override
    public void error(Exception e) throws ResourceException {
        this.destroy();
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
    }

    public XMLMessage createXMLMessage() throws JMSException {
        return this.m_session.createXMLMessage();
    }

    public XMLMessage createXMLMessage(String xml) throws JMSException {
        return this.m_session.createXMLMessage(xml);
    }

    public XMLMessage createXMLMessage(Document document) throws JMSException {
        return this.m_session.createXMLMessage(document);
    }

    public MultipartMessage createMultipartMessage() throws JMSException {
        return this.m_session.createMultipartMessage();
    }

    public void commit(String uuid) throws JMSException {
        this.m_session.commit(uuid);
    }

    public void commit(String uuid, long lifespan) throws JMSException {
        this.m_session.commit(uuid, lifespan);
    }

    public void setTxnBatchSize(int size) throws JMSException {
        this.m_session.setTxnBatchSize(size);
    }

    public int getTxnBatchSize() throws JMSException {
        return this.m_session.getTxnBatchSize();
    }

    public void setAckBatchingEnabled(boolean enabled) throws JMSException {
        this.m_session.setAckBatchingEnabled(enabled);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, long expiration) throws JMSException {
        return this.m_session.createDurableSubscriber(topic, name, expiration);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal, long expiration) throws JMSException {
        return this.m_session.createDurableSubscriber(topic, name, selector, noLocal, expiration);
    }

    public void setFlowControlDisabled(boolean disabled) {
        this.m_session.setFlowControlDisabled(disabled);
    }

    public void setDurableMessageOrder(boolean order) {
        this.m_session.setDurableMessageOrder(order);
    }

    public boolean getDurableMessageOrder() {
        return this.m_session.getDurableMessageOrder();
    }

    public void setFlowToDisk(int ftd) {
        this.m_session.setFlowToDisk(ftd);
    }

    public int getFlowToDisk() {
        return this.m_session.getFlowToDisk();
    }

    public MultiTopic createMultiTopic() throws JMSException {
        return this.m_session.createMultiTopic();
    }

    public void setSplitMultiTopicDelivery(boolean arg0) {
        this.m_session.setSplitMultiTopicDelivery(arg0);
    }

    public boolean getSplitMultiTopicDelivery() {
        return this.m_session.getSplitMultiTopicDelivery();
    }

    public String getSessionName() {
        return this.m_session.getSessionName();
    }

    public void setSendTimeout(int milliseconds) throws JMSException {
        this.m_session.setSendTimeout(milliseconds);
    }

    public int getSendTimeout() {
        return this.m_session.getSendTimeout();
    }
}

