/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicSessionWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXASessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicXAConnection;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import progress.message.jclient.xa.XAConnection;
import progress.message.jclient.xa.XASession;

public class SonicXAConnectionAdapter
extends SonicConnectionAdapter
implements SonicXAConnection {
    XAConnection m_connection;

    public SonicXAConnectionAdapter(ConnectionTracking tracking, XAConnection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        super(tracking, (progress.message.jclient.Connection)connection, cm, mcf);
        this.m_connection = connection;
    }

    public javax.jms.XASession createXASession() throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(true, true, 0, this, this.getConnectionID(), 3, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            return (SonicXASessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public javax.jms.XASession createXASession(String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(transacted, transacted, ackMode, this, this.getConnectionID(), 0, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            if (transacted) {
                SonicXASessionAdapter adapter = (SonicXASessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
                progress.message.jclient.Session session = (progress.message.jclient.Session)adapter.getSession();
                return new SonicSessionWrapper(session, adapter.getManagedConnection(), this.getPoolSessions());
            }
            return (SonicSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public Connection getConnection() throws JMSException {
        this.checkClosed();
        return this.m_connection.getConnection();
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        JMSSessionAdapter adapter = null;
        if (isXA) {
            javax.jms.XASession session = (javax.jms.XASession)mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createXASession();
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicXASessionAdapter((JMSConnectionAdapter)this, (XASession)session, mc);
        } else {
            Session session = mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createSession(isTransacted, ackMode);
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicSessionAdapter((JMSConnectionAdapter)this, (progress.message.jclient.Session)session, mc);
        }
        return adapter;
    }
}

