/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicQueueSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicQueueSessionWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXAConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXAQueueSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicXAQueueConnection;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.XAQueueSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import progress.message.jclient.xa.XAConnection;
import progress.message.jclient.xa.XAQueueConnection;

public class SonicXAQueueConnectionAdapter
extends SonicXAConnectionAdapter
implements SonicXAQueueConnection {
    XAQueueConnection m_connection;

    public SonicXAQueueConnectionAdapter(ConnectionTracking tracking, XAQueueConnection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        super(tracking, (XAConnection)connection, cm, mcf);
        this.m_connection = connection;
    }

    public QueueConnection getQueueConnection() throws JMSException {
        this.checkClosed();
        return this.m_connection.getQueueConnection();
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(true, true, 0, this, this.getConnectionID(), 5, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            return (SonicXAQueueSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public XAQueueSession createXAQueueSession(String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(transacted, transacted, ackMode, this, this.getConnectionID(), 2, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            if (transacted) {
                SonicXAQueueSessionAdapter adapter = (SonicXAQueueSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
                progress.message.jclient.QueueSession session = (progress.message.jclient.QueueSession)adapter.getSession();
                return new SonicQueueSessionWrapper(session, adapter.getManagedConnection(), this.getPoolSessions());
            }
            return (SonicQueueSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode, String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        this.checkClosed();
        throw new JMSException("Connection Consumer is not supported");
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        JMSSessionAdapter adapter = null;
        if (isXA) {
            XAQueueSession session = (XAQueueSession)mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createXAQueueSession();
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicXAQueueSessionAdapter((JMSConnectionAdapter)this, (progress.message.jclient.xa.XAQueueSession)session, mc);
        } else {
            QueueSession session = (QueueSession)mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createQueueSession(isTransacted, ackMode);
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicQueueSessionAdapter((JMSConnectionAdapter)this, (progress.message.jclient.QueueSession)session, mc);
        }
        return adapter;
    }
}

