/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.DummyLocalTransaction;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.DummyXAResource;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.IJMSXAResource;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ILifeCycleable;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ISessionCreator;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionEventListener;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSJCANotShareable;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.LocalTransactionImpl;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.MetaDataImpl;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.XAResourceWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicManagedXAConnectionFactory;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class JMSSessionManagedConnection
implements ManagedConnection,
ILifeCycleable {
    private JMSConnectionEventListener m_jmsConnEventListener;
    private PrintWriter m_logWriter = new PrintWriter(System.out);
    private Session m_jmsSession;
    private Connection m_jmsConnection;
    private JMSSessionAdapter m_adapter;
    private ISessionCreator m_sessionCreator;
    private JMSConnectionRequestInfo m_cri;
    private Subject m_subject;
    private boolean m_inUse = false;
    private Set m_childObjects = Collections.synchronizedSet(new HashSet());
    private ManagedConnectionMetaData m_metaData = null;
    private JMSManagedConnectionFactory m_mcf;
    private IJMSXAResource m_xaWrapper;
    private LocalTransaction m_localTransaction;
    private boolean m_poolSessions = true;
    private boolean m_isDestroyed = false;

    public JMSSessionManagedConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        this.m_jmsConnEventListener = new JMSConnectionEventListener(this);
        this.m_mcf = (JMSManagedConnectionFactory)mcf;
        this.m_cri = (JMSConnectionRequestInfo)info;
        this.m_subject = subject;
        if (info == null) {
            try {
                ConnectionFactory factory = (ConnectionFactory)mcf.createConnectionFactory();
                JMSConnectionAdapter connection = mcf instanceof SonicManagedXAConnectionFactory ? (JMSConnectionAdapter)((XAConnectionFactory)factory).createXAConnection() : (JMSConnectionAdapter)factory.createConnection();
                this.m_jmsConnection = connection;
                ConnectionTracking tracking = connection.getConnectionTracking();
                this.m_jmsSession = mcf instanceof SonicManagedXAConnectionFactory ? ((XAConnection)tracking.getConnection()).createXASession() : tracking.getConnection().createSession(false, 1);
                connection.trackSession(this);
                tracking.incReferenceCount();
                this.m_sessionCreator = connection;
                this.m_cri = mcf instanceof SonicManagedXAConnectionFactory ? new JMSConnectionRequestInfo(true, true, 0, connection, connection.getConnectionID(), 3, true, true) : new JMSConnectionRequestInfo(false, false, 1, connection, connection.getConnectionID(), 0, true, true);
                this.m_inUse = true;
                ConnectionMetaData metaData = tracking.getConnection().getMetaData();
                this.m_metaData = new MetaDataImpl(metaData.getJMSProviderName(), metaData.getProviderVersion(), this.m_mcf.getUsername());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ResourceException((Throwable)e);
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.m_inUse) {
            throw new JMSJCANotShareable();
        }
        if (this.m_adapter == null) {
            this.m_adapter = this.createConnection(subject, connectionRequestInfo);
        }
        this.m_inUse = true;
        return this.m_adapter;
    }

    private JMSSessionAdapter createConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            this.m_cri = (JMSConnectionRequestInfo)connectionRequestInfo;
            this.m_sessionCreator = this.m_cri.getSessionCreator();
            this.m_poolSessions = this.m_cri.poolSessions();
            JMSSessionAdapter jmsSessionAdapter = this.m_sessionCreator.createSession(this.m_cri.isXA(), this.m_cri.isTransacted(), this.m_cri.getAckMode(), this);
            if (this.m_metaData == null) {
                this.m_metaData = new MetaDataImpl(this.m_sessionCreator.getJMSProviderName(), this.m_sessionCreator.getJMSProviderVersion(), this.m_sessionCreator.getUsername());
            }
            this.m_jmsSession = jmsSessionAdapter.getWrappedSession();
            this.m_adapter = jmsSessionAdapter;
            return jmsSessionAdapter;
        }
        catch (JMSException e) {
            throw new ResourceException("Failed to allocate JMS session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ResourceException {
        if (RAUtils.isDebugEnabled()) {
            RAUtils.printDebug(Thread.currentThread().getName() + " DESTROYING SESSION " + this.m_jmsSession.hashCode() + (String)(this.m_jmsSession instanceof XASession ? " XAResource=" + ((XASession)this.m_jmsSession).getXAResource().hashCode() : ""));
        }
        this.m_isDestroyed = true;
        try {
            boolean wasInUse = this.m_inUse;
            this.m_inUse = false;
            if (this.m_jmsConnection != null) {
                try {
                    this.m_jmsConnection.close();
                }
                catch (JMSException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
            if (this.m_adapter != null) {
                this.m_adapter.setClosed();
            }
            Set e = this.m_childObjects;
            synchronized (e) {
                if (this.m_childObjects.size() > 0) {
                    Iterator iter = this.m_childObjects.iterator();
                    while (iter.hasNext()) {
                        ILifeCycleable lc = (ILifeCycleable)iter.next();
                        iter.remove();
                        lc.destroy();
                    }
                }
            }
            if (this.m_xaWrapper != null && this.m_xaWrapper instanceof XAResourceWrapper) {
                if (RAUtils.isDebugEnabled()) {
                    RAUtils.printDebug(Thread.currentThread().getName() + " CALLING XAResource.waitForCompletion ON SESSION " + this.m_jmsSession.hashCode() + " XAResource=" + this.m_xaWrapper.hashCode());
                }
                try {
                    ((XAResourceWrapper)this.m_xaWrapper).waitForCompletion();
                }
                catch (XAException e2) {
                    throw new ResourceException((Throwable)e2);
                }
            }
            if (RAUtils.isDebugEnabled()) {
                RAUtils.printDebug(Thread.currentThread().getName() + " CALLING CLOSE ON SESSION " + this.m_jmsSession.hashCode() + (String)(this.m_jmsSession instanceof XASession ? " XAResource=" + ((XASession)this.m_jmsSession).getXAResource().hashCode() : ""));
            }
            this.m_jmsSession.close();
            if (this.m_sessionCreator != null) {
                if (wasInUse) {
                    this.m_sessionCreator.cleanupSession(this);
                }
                this.m_sessionCreator.destroySession(this);
            }
            this.m_adapter = null;
            this.m_sessionCreator = null;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() throws ResourceException {
        if (!this.m_poolSessions) {
            RAUtils.printDebug("JCAJMSPoolSessions is false");
            if (this.m_xaWrapper != null && this.m_xaWrapper.isInTransaction()) {
                RAUtils.printDebug("The Managed connection is mid txn");
                if (!this.m_cri.preserveSessionsMidTxn()) {
                    this.sendEvent(5, null);
                    return;
                }
            } else {
                this.sendEvent(5, null);
                return;
            }
        }
        boolean wasInUse = this.m_inUse;
        this.m_inUse = false;
        RAUtils.printDebug("Cleaning up session");
        if (this.m_jmsConnection != null) {
            try {
                this.m_jmsConnection.close();
            }
            catch (JMSException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        if (this.m_sessionCreator != null && wasInUse) {
            this.m_sessionCreator.cleanupSession(this);
        }
        if (this.m_adapter != null) {
            this.m_adapter.setClosed();
        }
        Set set = this.m_childObjects;
        synchronized (set) {
            if (this.m_childObjects.size() > 0) {
                Iterator iter = this.m_childObjects.iterator();
                while (iter.hasNext()) {
                    ILifeCycleable lc = (ILifeCycleable)iter.next();
                    iter.remove();
                    lc.cleanup();
                }
            }
        }
        this.m_adapter = null;
    }

    public void associateConnection(Object object) throws ResourceException {
        throw new JMSJCANotShareable();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.m_jmsConnEventListener.addConnectorListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.m_jmsConnEventListener.removeConnectorListener(listener);
    }

    public void sendEvent(int eventType, Exception ex) {
        this.m_jmsConnEventListener.sendEvent(eventType, ex, null);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.m_jmsConnEventListener.sendEvent(eventType, ex, connectionHandle);
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.m_xaWrapper == null) {
            if (this.m_cri.isXA() && this.m_cri.isTransacted()) {
                if (this.m_adapter == null) {
                    this.createConnection(this.m_subject, this.m_cri);
                }
                this.m_xaWrapper = new XAResourceWrapper(((XASession)this.m_jmsSession).getXAResource(), this);
            } else {
                this.m_xaWrapper = new DummyXAResource();
            }
        }
        return this.m_xaWrapper;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.m_localTransaction == null) {
            this.m_localTransaction = this.m_cri.isTransacted() ? new LocalTransactionImpl(this.m_jmsSession) : new DummyLocalTransaction();
        }
        return this.m_localTransaction;
    }

    public ManagedConnectionMetaData getMetaData() {
        return this.m_metaData;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.m_logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.m_logWriter;
    }

    public boolean isCRIEqual(JMSConnectionRequestInfo cri) {
        return cri.equals(this.m_cri);
    }

    public boolean isDestroyed() {
        return this.m_isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        if (this.m_adapter != null) {
            this.m_adapter.close();
        }
        Set set = this.m_childObjects;
        synchronized (set) {
            if (this.m_childObjects.size() > 0) {
                Iterator iter = this.m_childObjects.iterator();
                while (iter.hasNext()) {
                    ILifeCycleable lc = (ILifeCycleable)iter.next();
                    System.out.println("ILifeCyleable object " + lc.getClass().getName());
                    iter.remove();
                    lc.close();
                }
            }
        }
    }

    @Override
    public void error(Exception e) {
        if (this.m_adapter != null) {
            this.m_adapter.setClosed();
        }
        this.sendEvent(5, e, this.m_adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        if (this.m_adapter != null) {
            this.m_adapter.stop();
        }
        Set set = this.m_childObjects;
        synchronized (set) {
            if (this.m_childObjects.size() > 0) {
                for (ILifeCycleable lc : this.m_childObjects) {
                    lc.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JMSException {
        if (this.m_adapter != null) {
            this.m_adapter.start();
        }
        Set set = this.m_childObjects;
        synchronized (set) {
            if (this.m_childObjects.size() > 0) {
                for (ILifeCycleable lc : this.m_childObjects) {
                    lc.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(ILifeCycleable child) {
        Set set = this.m_childObjects;
        synchronized (set) {
            this.m_childObjects.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ILifeCycleable child) {
        Set set = this.m_childObjects;
        synchronized (set) {
            this.m_childObjects.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        Set set = this.m_childObjects;
        synchronized (set) {
            return this.m_childObjects.size();
        }
    }

    public Session getJMSSession() {
        return this.m_jmsSession;
    }
}

