/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.JCAJMSTemporaryQueue;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ILifeCycleable;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;

public class JMSTemporaryQueueAdapter
implements JCAJMSTemporaryQueue,
ILifeCycleable {
    private TemporaryQueue m_tempQueue;
    private ConnectionTracking m_tracking;
    private long m_appID;

    public JMSTemporaryQueueAdapter(TemporaryQueue queue, long applicationID, ConnectionTracking tracking) throws JMSException {
        this.m_tempQueue = queue;
        this.m_tracking = tracking;
        this.m_appID = applicationID;
        tracking.addAppChildObject(applicationID, this);
    }

    public String getQueueName() throws JMSException {
        return this.m_tempQueue.getQueueName();
    }

    public String toString() {
        return this.m_tempQueue.toString();
    }

    public void delete() throws JMSException {
        this.m_tempQueue.delete();
        this.m_tracking.removeAppChildObject(this.m_appID, this);
    }

    @Override
    public void close() throws JMSException {
        this.delete();
    }

    @Override
    public void cleanup() throws ResourceException {
        this.destroy();
    }

    @Override
    public void destroy() throws ResourceException {
        try {
            this.close();
        }
        catch (JMSException e) {
            EISSystemException se = new EISSystemException(e.getMessage());
            se.setLinkedException((Exception)((Object)e));
            throw se;
        }
    }

    @Override
    public void error(Exception e) throws ResourceException {
        this.destroy();
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
    }
}

