/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl;

import com.sonicsw.sonicmq.j2ee.jmsra.JCAJMSTopicConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSTopicSessionAdapter;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;

public class JMSTopicConnectionAdapter
extends JMSConnectionAdapter
implements JCAJMSTopicConnection {
    private TopicConnection m_connection;

    public JMSTopicConnectionAdapter(ConnectionTracking tracking, TopicConnection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        super(tracking, (Connection)connection, cm, mcf);
        this.m_connection = connection;
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(false, transacted, ackMode, this, this.getConnectionID(), 1, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            return (JMSTopicSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.m_connection.createConnectionConsumer(topic, messageSelector, serverSessionPool, maxMessages);
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        TopicSession session = (TopicSession)mc.getJMSSession();
        if (session == null) {
            session = this.m_connection.createTopicSession(isTransacted, ackMode);
            JMSConnectionPool.addReference(this.getConnectionTracking());
            this.getConnectionTracking().addChildObject(mc);
        }
        this.trackSession(mc);
        return new JMSTopicSessionAdapter((JMSConnectionAdapter)this, session, mc);
    }
}

