/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.JCAGlobalProperties;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicActivationSpec;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicQueue;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicQueueConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicResourceAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicServerSessionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicTopic;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicTopicConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXAConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXAQueueConnectionFactoryAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXATopicConnectionFactoryAdapter;
import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.ErrorCodes;
import progress.message.jclient.QueueConnectionFactory;
import progress.message.jclient.TopicConnectionFactory;
import progress.message.jclient.xa.XAQueueConnectionFactory;
import progress.message.jclient.xa.XATopicConnectionFactory;

public class SonicActivation
implements ExceptionListener {
    public static final Method ONMESSAGE;
    private SonicResourceAdapter m_ra;
    private MessageEndpointFactory m_endpointFactory;
    private SonicActivationSpec m_spec;
    private ConnectionFactory m_cf;
    private Destination m_destination;
    private Connection m_connection;
    private SonicServerSessionPool m_pool;
    private int m_activationRetries = 0;
    private boolean m_deliveryTransacted;
    private boolean m_deliveryAllowed = true;
    int m_debugLevel = 0;

    public SonicActivation(SonicResourceAdapter ra, MessageEndpointFactory endpointFactory, SonicActivationSpec spec) throws ResourceException {
        this.m_ra = ra;
        this.m_endpointFactory = endpointFactory;
        this.m_spec = spec;
        try {
            this.m_deliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
            RAUtils.printDebug("SonicActivation CTOR " + String.valueOf(this) + " deliveryTransacted=" + this.m_deliveryTransacted);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public SonicActivationSpec getActivationSpec() {
        return this.m_spec;
    }

    private synchronized boolean isDeliveryAllowed() {
        return this.m_deliveryAllowed;
    }

    public Destination getDestination() {
        return this.m_destination;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public boolean isDeliveryTransacted() {
        return this.m_deliveryTransacted;
    }

    private synchronized void setDeliveryAllowed(boolean deliveryAllowed) {
        this.m_deliveryAllowed = deliveryAllowed;
    }

    public MessageEndpointFactory getEndpointFactory() {
        return this.m_endpointFactory;
    }

    public WorkManager getWorkManager() {
        return this.m_ra.getWorkManager();
    }

    public void start() throws ResourceException {
        if (this.isDeliveryAllowed()) {
            this.m_ra.getWorkManager().scheduleWork((Work)new SetupActivation());
        }
    }

    public void stop() {
        this.setDeliveryAllowed(false);
        this.teardown();
        if (this.m_debugLevel > 0) {
            JCAGlobalProperties.setDebugLevel(this.m_debugLevel * -1);
        }
    }

    protected void setup() throws Exception {
        try {
            this.m_debugLevel = Integer.parseInt(this.m_spec.getDebugLevel());
            if (this.m_debugLevel > 0) {
                JCAGlobalProperties.setDebugLevel(this.m_debugLevel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setupDestination();
        this.setupConnection();
        this.setupSessionPool();
    }

    protected void setupDestination() throws Exception {
        try {
            InitialContext ctx = new InitialContext();
            Object jndiObj = ctx.lookup(this.m_spec.getDestination());
            if (!(jndiObj instanceof Queue) && !(jndiObj instanceof Topic)) {
                throw new ResourceException("Destination " + this.m_spec.getDestination() + " has invalid type " + jndiObj.getClass().getName());
            }
            if (this.m_spec.isTopic() && !(jndiObj instanceof Topic) || this.m_spec.isQueue() && !(jndiObj instanceof Queue)) {
                throw new ResourceException("Incompatible activation-config-property specification destination=" + this.m_spec.getDestination() + " destinationType=" + this.m_spec.getDestinationType());
            }
            if (jndiObj instanceof Queue) {
                this.m_spec.setQueue();
            } else if (jndiObj instanceof Topic) {
                this.m_spec.setTopic();
            }
            this.m_destination = (Destination)jndiObj;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.m_destination == null) {
            if (this.m_spec.isTopic()) {
                this.m_destination = new SonicTopic(this.m_spec.getDestination());
            } else if (this.m_spec.isQueue()) {
                this.m_destination = new SonicQueue(this.m_spec.getDestination());
            }
        }
        if (this.m_destination == null) {
            throw new ResourceException("Unable to locate or instantiate Destination " + this.m_spec.getDestination());
        }
    }

    protected void teardownDestination() {
    }

    protected void setupConnection() throws Exception {
        String value;
        String cfConnectionURLs;
        block57: {
            if (this.m_spec.getConnectionFactory() != null && this.m_spec.getConnectionFactory().length() > 0) {
                try {
                    InitialContext ctx = new InitialContext();
                    Object ref = ctx.lookup(this.m_spec.getConnectionFactory());
                    if (ref instanceof ConnectionFactory) {
                        this.m_cf = (ConnectionFactory)ref;
                    } else if (ref instanceof SonicConnectionFactoryAdapter) {
                        this.m_cf = this.createMQConnectionFactory((SonicConnectionFactoryAdapter)ref);
                    } else {
                        throw new ResourceException("Invalid connectionFactory class: " + ref.getClass().getName() + "; must be MQ ConnectionFactory or JCA ConnectionFactory");
                    }
                    RAUtils.printDebug("SonicActivation.setupConnection() connection factory loaded from JNDI store" + String.valueOf(this.m_cf));
                    if (this.m_deliveryTransacted && !(this.m_cf instanceof XAConnectionFactory) || !this.m_deliveryTransacted && this.m_cf instanceof XAConnectionFactory) {
                        throw new Exception("Incompatible activation-config-property specification connectionFactory=" + this.m_spec.getConnectionFactory() + "; type of factory must be consistent with 'deliveryTransacted' setting");
                    }
                    break block57;
                }
                catch (NamingException ignore) {
                    RAUtils.printError("<Inbound Adapter> ConnectionFactory=" + this.m_spec.getConnectionFactory() + " cannot be found in underlying JNDI storage.");
                    return;
                }
            }
            this.m_cf = this.m_deliveryTransacted ? (this.m_spec.isTopic() ? new XATopicConnectionFactory() : new XAQueueConnectionFactory()) : (this.m_spec.isTopic() ? new TopicConnectionFactory() : new QueueConnectionFactory());
        }
        RAUtils.printDebug("SonicActivation.setupConnection() created connection factory " + String.valueOf(this.m_cf));
        String specConnectionURLs = this.m_spec.getConnectionURLs();
        if (specConnectionURLs == null || specConnectionURLs.length() == 0) {
            specConnectionURLs = this.m_spec.getBrokerURL();
        }
        if (specConnectionURLs != null && specConnectionURLs.length() > 0) {
            this.m_cf.setConnectionURLs(specConnectionURLs);
        }
        if ((cfConnectionURLs = this.m_cf.getConnectionURLs()) == null || cfConnectionURLs.length() == 0) {
            this.m_cf.setConnectionURLs("localhost");
        }
        if (this.m_spec.isTopic() && this.m_spec.isDurable()) {
            String clientID = this.m_spec.getClientID();
            if (clientID == null || clientID.length() == 0) {
                clientID = this.m_cf.getClientID();
            }
            if (clientID == null || clientID.length() == 0) {
                throw new InvalidPropertyException("No clientId was specified for a durable subscription");
            }
        }
        if ((value = this.m_spec.getClientID()) != null) {
            this.m_cf.setClientID(value);
        }
        if ((value = this.m_spec.getClientTransactionBufferSize()) != null) {
            this.m_cf.setClientTransactionBufferSize(Long.decode(value));
        }
        if ((value = this.m_spec.getConnectID()) != null) {
            this.m_cf.setConnectID(value);
        }
        if ((value = this.m_spec.getDefaultTxnBatchSize()) != null) {
            this.m_cf.setDefaultTxnBatchSize(Integer.decode(value).intValue());
        }
        if ((value = this.m_spec.getDurableMessageOrder()) != null) {
            this.m_cf.setDurableMessageOrder(Boolean.valueOf(value));
        }
        if ((value = this.m_spec.getEnableCompression()) != null) {
            this.m_cf.setEnableCompression(Boolean.valueOf(value).booleanValue());
        }
        if ((value = this.m_spec.getFaultTolerant()) != null) {
            this.m_cf.setFaultTolerant(Boolean.valueOf(value));
        }
        if ((value = this.m_spec.getFaultTolerantReconnectTimeout()) != null) {
            this.m_cf.setFaultTolerantReconnectTimeout(Integer.decode(value));
        }
        if ((value = this.m_spec.getFlowToDisk()) != null) {
            boolean flowOn = Boolean.valueOf(value);
            if (flowOn) {
                this.m_cf.setFlowToDisk(Integer.valueOf("1"));
            } else {
                this.m_cf.setFlowToDisk(Integer.valueOf("2"));
            }
        }
        if ((value = this.m_spec.getInitialConnectTimeout()) != null) {
            this.m_cf.setInitialConnectTimeout(Integer.decode(value));
        }
        if ((value = this.m_spec.getInitialRcvBufferSize()) != null) {
            this.m_cf.setInitialRcvBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getInitialSendBufferSize()) != null) {
            this.m_cf.setInitialSendBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getLGDownStreamNodeType()) != null) {
            this.m_cf.setLGDownStreamNodeType(Integer.decode(value).intValue());
        }
        if ((value = this.m_spec.getLoadBalancing()) != null) {
            boolean loadBalancing = Boolean.valueOf(value);
            if (this.m_deliveryTransacted && loadBalancing) {
                RAUtils.print("WARNING: Load balancing cannot be set to true when delivery is transacted, setting ignored.");
            } else {
                this.m_cf.setLoadBalancing(loadBalancing);
            }
        }
        if ((value = this.m_spec.getMaxDeliveryCount()) != null) {
            this.m_cf.setMaxDeliveryCount(Integer.decode(value));
        }
        if ((value = this.m_spec.getMaxRcvBufferSize()) != null) {
            this.m_cf.setMaxRcvBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getMaxSendBufferSize()) != null) {
            this.m_cf.setMaxSendBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getMinRcvBufferSize()) != null) {
            this.m_cf.setMinRcvBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getMinSendBufferSize()) != null) {
            this.m_cf.setMinSendBufferSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getMinimizeSubscriberTraffic()) != null) {
            this.m_cf.setMinimizeSubscriberTraffic(Boolean.valueOf(value).booleanValue());
        }
        if ((value = this.m_spec.getMonitorInterval()) != null) {
            this.m_cf.setMonitorInterval(Integer.decode(value));
        }
        if ((value = this.m_spec.getPersistentDelivery()) != null) {
            this.m_cf.setPersistentDelivery(Boolean.valueOf(value).booleanValue());
        }
        if ((value = this.m_spec.getPingInterval()) != null) {
            this.m_cf.setPingInterval(Long.decode(value).longValue());
        }
        if ((value = this.m_spec.getPrefetchCount()) != null) {
            this.m_cf.setPrefetchCount(Integer.decode(value).intValue());
        }
        if ((value = this.m_spec.getPrefetchThreshold()) != null) {
            this.m_cf.setPrefetchThreshold(Integer.decode(value).intValue());
        }
        if ((value = this.m_spec.getQopCacheSize()) != null) {
            this.m_cf.setQopCacheSize(Integer.decode(value));
        }
        if ((value = this.m_spec.getRequireActionalJMSNode()) != null) {
            this.m_cf.setRequireActionalJMSNode(Boolean.valueOf(value).booleanValue());
        }
        if ((value = this.m_spec.getRethrowCCRuntimeExceptions()) != null) {
            this.m_cf.setRethrowCCRuntimeExceptions(Boolean.valueOf(value));
        }
        if ((value = this.m_spec.getSelectorAtBroker()) != null) {
            this.m_cf.setSelectorAtBroker(Boolean.valueOf(value));
        }
        if ((value = this.m_spec.getSequential()) != null) {
            this.m_cf.setSequential(Boolean.valueOf(value).booleanValue());
        }
        if ((value = this.m_spec.getSocketConnectTimeout()) != null) {
            this.m_cf.setSocketConnectTimeout(Integer.decode(value));
        }
        if ((value = this.m_spec.getSplitMultiTopicDelivery()) != null) {
            this.m_cf.setSplitMultiTopicDelivery(Boolean.valueOf(value));
        }
        if ((value = this.m_spec.getTestCFBaseName()) != null) {
            try {
                String rootCtxName = "SonicTests";
                String actualCtxName = "actualCFs";
                String cfName = value;
                Context ctx = new InitialContext();
                try {
                    ctx = (Context)ctx.lookup(rootCtxName);
                }
                catch (NameNotFoundException e) {
                    ctx = ctx.createSubcontext(rootCtxName);
                }
                try {
                    ctx = (Context)ctx.lookup(actualCtxName);
                }
                catch (NameNotFoundException e) {
                    ctx = ctx.createSubcontext(actualCtxName);
                }
                ctx.bind(cfName, (Object)this.m_cf);
                RAUtils.printDebug("Bound " + rootCtxName + "/" + actualCtxName + "/" + cfName + " as " + String.valueOf(this.m_cf));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_connection = this.isDeliveryTransacted() ? (this.m_spec.getUsername() == null ? (this.m_cf.getDefaultUser() == null ? ((XAConnectionFactory)this.m_cf).createXAConnection() : ((XAConnectionFactory)this.m_cf).createXAConnection(this.m_cf.getDefaultUser(), this.m_cf.getDefaultPassword())) : ((XAConnectionFactory)this.m_cf).createXAConnection(this.m_spec.getUsername(), this.m_spec.getPassword())) : (this.m_spec.getUsername() == null ? (this.m_cf.getDefaultUser() == null ? this.m_cf.createConnection() : this.m_cf.createConnection(this.m_cf.getDefaultUser(), this.m_cf.getDefaultPassword())) : this.m_cf.createConnection(this.m_spec.getUsername(), this.m_spec.getPassword()));
        this.m_connection.setExceptionListener((ExceptionListener)this);
        RAUtils.printDebug("SonicActivation.setupConnection(), connection created: " + String.valueOf(this.m_connection) + ", ConnectID=" + ((progress.message.jclient.Connection)this.m_connection).getConnectID() + ", BrokerURL=" + ((progress.message.jclient.Connection)this.m_connection).getBrokerURL() + ", Username=" + (this.m_spec.getUsername() == null ? this.m_cf.getDefaultUser() : this.m_spec.getUsername()) + ", Password=" + (this.m_spec.getPassword() == null ? (this.m_cf.getDefaultPassword() == null ? "null" : "********") : "********"));
    }

    protected ConnectionFactory createMQConnectionFactory(SonicConnectionFactoryAdapter jcaCF) throws ResourceException {
        XAQueueConnectionFactory mqCF = null;
        try {
            if (jcaCF instanceof SonicXAQueueConnectionFactoryAdapter) {
                mqCF = new XAQueueConnectionFactory();
            } else if (jcaCF instanceof SonicXATopicConnectionFactoryAdapter) {
                mqCF = new XATopicConnectionFactory();
            } else if (jcaCF instanceof SonicXAConnectionFactoryAdapter) {
                mqCF = new progress.message.jclient.xa.XAConnectionFactory();
            } else if (jcaCF instanceof SonicQueueConnectionFactoryAdapter) {
                mqCF = new QueueConnectionFactory();
            } else if (jcaCF instanceof SonicTopicConnectionFactoryAdapter) {
                mqCF = new TopicConnectionFactory();
            } else if (jcaCF instanceof SonicConnectionFactoryAdapter) {
                mqCF = new ConnectionFactory();
            }
            String brokerURL = jcaCF.getBrokerURL();
            String connectionURLs = jcaCF.getConnectionURLs();
            if (brokerURL == null || brokerURL.length() == 0) {
                brokerURL = "localhost";
            }
            mqCF.setBrokerURL(brokerURL);
            if (connectionURLs != null) {
                mqCF.setConnectionURLs(connectionURLs);
            }
            mqCF.setDefaultUser(jcaCF.getUsername());
            mqCF.setDefaultPassword(jcaCF.getPassword());
            String value = jcaCF.getClientID();
            if (value != null) {
                mqCF.setClientID(value);
            }
            mqCF.setClientTransactionBufferSize(jcaCF.getClientTransactionBufferSize());
            value = jcaCF.getConnectID();
            if (value != null) {
                mqCF.setConnectID(value);
            }
            mqCF.setDefaultTxnBatchSize(jcaCF.getDefaultTxnBatchSize().intValue());
            mqCF.setDurableMessageOrder(jcaCF.getDurableMessageOrder());
            mqCF.setEnableCompression(jcaCF.getEnableCompression().booleanValue());
            mqCF.setFaultTolerant(jcaCF.getFaultTolerant());
            mqCF.setFaultTolerantReconnectTimeout(jcaCF.getFaultTolerantReconnectTimeout());
            mqCF.setFlowToDisk(jcaCF.getFlowToDisk());
            mqCF.setInitialConnectTimeout(jcaCF.getInitialConnectTimeout());
            mqCF.setInitialRcvBufferSize(jcaCF.getInitialRcvBufferSize());
            mqCF.setInitialSendBufferSize(jcaCF.getInitialSendBufferSize());
            mqCF.setLGDownStreamNodeType(jcaCF.getLGDownStreamNodeType().intValue());
            boolean loadBalancing = jcaCF.getLoadBalancing();
            if (this.m_deliveryTransacted && loadBalancing) {
                RAUtils.print("WARNING: Load balancing cannot be set to true when delivery is transacted, setting ignored.");
            } else {
                mqCF.setLoadBalancing(loadBalancing);
            }
            mqCF.setMaxDeliveryCount(jcaCF.getMaxDeliveryCount());
            mqCF.setMaxRcvBufferSize(jcaCF.getMaxRcvBufferSize());
            mqCF.setMaxSendBufferSize(jcaCF.getMaxSendBufferSize());
            mqCF.setMinRcvBufferSize(jcaCF.getMinRcvBufferSize());
            mqCF.setMinSendBufferSize(jcaCF.getMinSendBufferSize());
            mqCF.setMinimizeSubscriberTraffic(jcaCF.getMinimizeSubscriberTraffic().booleanValue());
            mqCF.setMonitorInterval(jcaCF.getMonitorInterval());
            mqCF.setPersistentDelivery(jcaCF.getPersistentDelivery().booleanValue());
            mqCF.setPingInterval(jcaCF.getPingInterval().longValue());
            mqCF.setPrefetchCount((int)jcaCF.getPrefetchCount().shortValue());
            mqCF.setPrefetchThreshold(jcaCF.getPrefetchThreshold().intValue());
            mqCF.setQopCacheSize(jcaCF.getQopCacheSize());
            mqCF.setRequireActionalJMSNode(jcaCF.getRequireActionalJMSNode().booleanValue());
            mqCF.setRethrowCCRuntimeExceptions(jcaCF.getRethrowCCRuntimeExceptions());
            mqCF.setSelectorAtBroker(jcaCF.getSelectorAtBroker());
            mqCF.setSequential(jcaCF.getSequential().booleanValue());
            mqCF.setSocketConnectTimeout(jcaCF.getSocketConnectTimeout());
            mqCF.setSplitMultiTopicDelivery(jcaCF.getSplitMultiTopicDelivery());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof ResourceException) {
                throw (ResourceException)((Object)e);
            }
            throw new ResourceException((Throwable)e);
        }
        return mqCF;
    }

    protected void teardownConnection() {
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable t) {
            RAUtils.printException("Error closing the connection " + String.valueOf(this.m_connection), t);
        }
    }

    protected void teardown() {
        this.teardownSessionPool();
        this.teardownConnection();
    }

    protected void setupSessionPool() throws Exception {
        if (this.m_connection == null) {
            return;
        }
        this.m_pool = new SonicServerSessionPool(this);
        this.m_pool.start();
        this.m_connection.start();
    }

    protected void teardownSessionPool() {
        try {
            if (this.m_connection != null) {
                this.m_connection.stop();
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable t) {
            RAUtils.printException("Error stopping delivery on connection " + String.valueOf(this.m_connection), t);
        }
        try {
            if (this.m_pool != null) {
                this.m_pool.stop();
            }
        }
        catch (Throwable t) {
            RAUtils.printException("Error clearing the pool " + String.valueOf(this.m_pool), t);
        }
    }

    public void handleFailure(Throwable failure) {
        RAUtils.printException("Failure in SonicActivation:", failure);
        String brokerURL = this.m_cf.getBrokerURL();
        boolean reconnected = false;
        long activationRetryTimeoutMillis = this.m_spec.getActivationRetryTimeoutMillis();
        long activationRetryTimeMillis = System.currentTimeMillis() + activationRetryTimeoutMillis;
        while (this.isDeliveryAllowed() && (activationRetryTimeoutMillis == 0L || System.currentTimeMillis() < activationRetryTimeMillis)) {
            ++this.m_activationRetries;
            this.teardown();
            try {
                Thread.sleep(this.m_spec.getActivationRetryIntervalMillis());
            }
            catch (InterruptedException e) {
                RAUtils.printException("Interrupted trying to reconnect to SonicMQ broker URL " + brokerURL, e);
                continue;
            }
            RAUtils.printDebug("Activation attempt " + this.m_activationRetries + " to SonicMQ broker URL " + brokerURL);
            try {
                this.setup();
                reconnected = true;
                break;
            }
            catch (Throwable t) {
                RAUtils.printException("Unable to activate to Message Driven Bean connecting to " + brokerURL + " on retry attempt " + this.m_activationRetries, t);
            }
        }
        if (!reconnected) {
            String msg = "Unable to activate Message Driven Bean after " + this.m_activationRetries + " attempts to connect to SonicMQ broker URL " + brokerURL + ".  No more activation attempts will be made because ";
            msg = this.isDeliveryAllowed() ? msg + "the activationRetryTimeout period of " + this.m_spec.getActivationRetryTimeout() + " minutes has expired." : msg + "activation of this bean has been stopped.";
            RAUtils.print(msg);
        } else {
            RAUtils.print("Message Driven Bean activation succeeded after " + this.m_activationRetries + " attempts to connect to SonicMQ broker URL " + brokerURL + ".");
            this.m_activationRetries = 0;
        }
    }

    public void onException(JMSException e) {
        RAUtils.printDebug("SonicActivation.onException() " + String.valueOf((Object)e) + " with error code " + e.getErrorCode());
        if (!ErrorCodes.testException((JMSException)e, (int)-15)) {
            this.handleFailure(e);
        }
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                SonicActivation.this.setup();
            }
            catch (Throwable t) {
                SonicActivation.this.handleFailure(t);
            }
        }

        public void release() {
        }
    }
}

