/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.JCAGlobalProperties;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicConnectionFactoryProperties;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import progress.message.jclient.ConnectionFactory;

public abstract class SonicConnectionFactoryPropertiesImpl
implements SonicConnectionFactoryProperties,
Serializable,
Referenceable {
    private ConnectionFactory m_factory;
    protected int m_maxReferencesPerConnection = 10;
    protected boolean m_poolSessions = true;
    protected boolean m_preserveSessionsMidTxn = false;

    protected void initFactory(ConnectionFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void setClientID(String clientId) {
        this.setClientId(clientId);
    }

    @Override
    public String getClientID() {
        return this.getClientId();
    }

    @Override
    public void setClientId(String clientId) {
        try {
            this.m_factory.setClientID(clientId);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    @Override
    public String getClientId() {
        return this.m_factory.getClientID();
    }

    @Override
    public void setUrl(String url) {
        this.m_factory.setConnectionURLs(url);
    }

    @Override
    public String getUrl() {
        return this.m_factory.getConnectionURLs();
    }

    @Override
    @Deprecated
    public void setBrokerURL(String url) {
        this.m_factory.setBrokerURL(url);
    }

    @Override
    @Deprecated
    public String getBrokerURL() {
        return this.m_factory.getBrokerURL();
    }

    @Override
    public void setUsername(String username) {
        this.m_factory.setDefaultUser(username);
    }

    @Override
    public String getUsername() {
        return this.m_factory.getDefaultUser();
    }

    @Override
    public void setPassword(String password) {
        this.m_factory.setDefaultPassword(password);
    }

    @Override
    public String getPassword() {
        return this.m_factory.getDefaultPassword();
    }

    @Override
    public void setPersistentDelivery(Boolean persistentDelivery) {
        this.m_factory.setPersistentDeliveryBoolean(persistentDelivery);
    }

    @Override
    public Boolean getPersistentDelivery() {
        return this.m_factory.getPersistentDeliveryBoolean();
    }

    @Override
    public void setLoadBalancing(Boolean loadBalancing) {
        if (loadBalancing.booleanValue() && this instanceof XAConnectionFactory) {
            RAUtils.print("WARNING: Load balancing cannot be set on XA Connection Factory, setting ignored.");
        } else {
            this.m_factory.setLoadBalancingBoolean(loadBalancing);
        }
    }

    @Override
    public Boolean getLoadBalancing() {
        return this.m_factory.getLoadBalancingBoolean();
    }

    @Override
    public void setSequential(Boolean sequential) {
        this.m_factory.setSequentialBoolean(sequential);
    }

    @Override
    public Boolean getSequential() {
        return this.m_factory.getSequentialBoolean();
    }

    @Override
    public void setPrefetchCount(Integer count) {
        this.m_factory.setPrefetchCountInteger(count);
    }

    @Override
    public Integer getPrefetchCount() {
        return this.m_factory.getPrefetchCountInteger();
    }

    @Override
    public void setPrefetchThreshold(Integer threshold) {
        this.m_factory.setPrefetchThresholdInteger(threshold);
    }

    @Override
    public Integer getPrefetchThreshold() {
        return this.m_factory.getPrefetchThresholdInteger();
    }

    @Override
    public void setPingInterval(Long interval) {
        this.m_factory.setPingIntervalLong(interval);
    }

    @Override
    public Long getPingInterval() {
        return this.m_factory.getPingIntervalLong();
    }

    @Override
    public void setMonitorInterval(Integer interval) {
        this.m_factory.setMonitorInterval(interval);
    }

    @Override
    public Integer getMonitorInterval() {
        return this.m_factory.getMonitorInterval();
    }

    @Override
    public void setSelectorAtBroker(Boolean selectorAtBroker) {
        this.m_factory.setSelectorAtBroker(selectorAtBroker);
    }

    @Override
    public Boolean getSelectorAtBroker() {
        return this.m_factory.getSelectorAtBroker();
    }

    @Override
    public void setDurableMessageOrder(Boolean durableMessageOrder) {
        this.m_factory.setDurableMessageOrder(durableMessageOrder);
    }

    @Override
    public Boolean getDurableMessageOrder() {
        return this.m_factory.getDurableMessageOrder();
    }

    @Override
    public Integer getDefaultTxnBatchSize() {
        return this.m_factory.getDefaultTxnBatchSizeInteger();
    }

    @Override
    public void setDefaultTxnBatchSize(Integer size) {
        this.m_factory.setDefaultTxnBatchSizeInteger(size);
    }

    @Override
    public String getLoginSPI() {
        return this.m_factory.getLoginSPI();
    }

    @Override
    public void setLoginSPI(String login) {
        this.m_factory.setLoginSPI(login);
    }

    @Override
    public Integer getReconnectInterval() {
        return this.m_factory.getReconnectIntervalInteger();
    }

    @Override
    public void setReconnectInterval(Integer reconnectInterval) {
        this.m_factory.setReconnectIntervalInteger(reconnectInterval);
    }

    @Override
    public Integer getReconnectTimeout() {
        return this.m_factory.getReconnectTimeoutInteger();
    }

    @Override
    public void setReconnectTimeout(Integer reconnectTimeout) {
        this.m_factory.setReconnectTimeoutInteger(reconnectTimeout);
    }

    @Override
    public String getConnectionURLs() {
        return this.m_factory.getConnectionURLs();
    }

    @Override
    public void setConnectionURLs(String connectionURLs) {
        this.m_factory.setConnectionURLs(connectionURLs);
    }

    @Override
    public Long getLocalStoreSize() {
        return this.m_factory.getLocalStoreSizeLong();
    }

    @Override
    public void setLocalStoreSize(Long size) {
        this.m_factory.setLocalStoreSizeLong(size);
    }

    @Override
    public Integer getLocalStoreWaitTime() {
        return this.m_factory.getLocalStoreWaitTime();
    }

    @Override
    public void setLocalStoreWaitTime(Integer waitTime) {
        this.m_factory.setLocalStoreWaitTime(waitTime);
    }

    @Override
    public void setFaultTolerant(Boolean ft) {
        this.m_factory.setFaultTolerant(ft);
    }

    @Override
    public Boolean getFaultTolerant() {
        return this.m_factory.getFaultTolerant();
    }

    @Override
    public void setFaultTolerantReconnectTimeout(Integer minutes) {
        this.m_factory.setFaultTolerantReconnectTimeout(minutes);
    }

    @Override
    public Integer getFaultTolerantReconnectTimeout() {
        return this.m_factory.getFaultTolerantReconnectTimeout();
    }

    @Override
    public void setClientTransactionBufferSize(Long size) {
        this.m_factory.setClientTransactionBufferSize(size);
    }

    @Override
    public Long getClientTransactionBufferSize() {
        return this.m_factory.getClientTransactionBufferSize();
    }

    @Override
    public void setFlowToDisk(Integer value) {
        this.m_factory.setFlowToDisk(value);
    }

    @Override
    public Integer getFlowToDisk() {
        return this.m_factory.getFlowToDisk();
    }

    @Override
    public String getLocalStoreDirectory() {
        return this.m_factory.getLocalStoreDirectory();
    }

    @Override
    public void setLocalStoreDirectory(String localStoreDirectory) {
        this.m_factory.setLocalStoreDirectory(localStoreDirectory);
    }

    @Override
    public String getConnectID() {
        return this.m_factory.getConnectID();
    }

    @Override
    public void setConnectID(String connectId) {
        this.m_factory.setConnectID(connectId);
    }

    @Override
    public void setInitialConnectTimeout(Integer minutes) {
        this.m_factory.setInitialConnectTimeout(minutes);
    }

    @Override
    public Integer getInitialConnectTimeout() {
        return this.m_factory.getInitialConnectTimeout();
    }

    @Override
    public Boolean getEnableCompression() {
        return this.m_factory.getEnableCompressionBoolean();
    }

    @Override
    public void setEnableCompression(Boolean enableCompression) {
        this.m_factory.setEnableCompressionBoolean(enableCompression);
    }

    @Override
    public Boolean getEnableLocalStore() {
        return this.m_factory.isEnableLocalStoreBoolean();
    }

    @Override
    public void setEnableLocalStore(Boolean enableLocalStore) {
        this.m_factory.setEnableLocalStoreBoolean(enableLocalStore);
    }

    @Override
    public void setMaxDeliveryCount(Integer count) {
        this.m_factory.setMaxDeliveryCount(count);
    }

    @Override
    public Integer getMaxDeliveryCount() {
        return this.m_factory.getMaxDeliveryCount();
    }

    @Override
    public void setQopCacheSize(Integer size) {
        this.m_factory.setQopCacheSize(size);
    }

    @Override
    public Integer getQopCacheSize() {
        return this.m_factory.getQopCacheSize();
    }

    @Override
    public void setSocketConnectTimeout(Integer milliseconds) {
        this.m_factory.setSocketConnectTimeout(milliseconds);
    }

    @Override
    public Integer getSocketConnectTimeout() {
        return this.m_factory.getSocketConnectTimeout();
    }

    @Override
    public Boolean getSplitMultiTopicDelivery() {
        return this.m_factory.getSplitMultiTopicDelivery();
    }

    @Override
    public void setSplitMultiTopicDelivery(Boolean split) {
        this.m_factory.setSplitMultiTopicDelivery(split);
    }

    public Integer getInitialSendBufferSize() {
        return this.m_factory.getInitialSendBufferSize();
    }

    public void setInitialSendBufferSize(Integer size) {
        this.m_factory.setInitialSendBufferSize(size);
    }

    public Integer getInitialRcvBufferSize() {
        return this.m_factory.getInitialRcvBufferSize();
    }

    public void setInitialRcvBufferSize(Integer size) {
        this.m_factory.setInitialRcvBufferSize(size);
    }

    public Integer getMinSendBufferSize() {
        return this.m_factory.getMinSendBufferSize();
    }

    public void setMinSendBufferSize(Integer size) {
        this.m_factory.setMinSendBufferSize(size);
    }

    public Integer getMinRcvBufferSize() {
        return this.m_factory.getMinRcvBufferSize();
    }

    public void setMinRcvBufferSize(Integer size) {
        this.m_factory.setMinRcvBufferSize(size);
    }

    public Integer getMaxSendBufferSize() {
        return this.m_factory.getMaxSendBufferSize();
    }

    public void setMaxSendBufferSize(Integer size) {
        this.m_factory.setMaxSendBufferSize(size);
    }

    public Integer getMaxRcvBufferSize() {
        return this.m_factory.getMaxRcvBufferSize();
    }

    public void setMaxRcvBufferSize(Integer size) {
        this.m_factory.setMaxRcvBufferSize(size);
    }

    @Override
    public Boolean getMinimizeSubscriberTraffic() {
        return this.m_factory.getMinimizeSubscriberTraffic();
    }

    @Override
    public void setMinimizeSubscriberTraffic(Boolean minimizeSubscriberTraffic) {
        this.m_factory.setMinimizeSubscriberTraffic(minimizeSubscriberTraffic.booleanValue());
    }

    @Override
    public Boolean getRethrowCCRuntimeExceptions() {
        return this.m_factory.getRethrowCCRuntimeExceptions();
    }

    @Override
    public void setRethrowCCRuntimeExceptions(Boolean rethrowCCRuntimeExceptions) {
        this.m_factory.setRethrowCCRuntimeExceptions(rethrowCCRuntimeExceptions);
    }

    @Override
    public Integer getLGDownStreamNodeType() {
        return this.m_factory.getLGDownStreamNodeType();
    }

    @Override
    public void setLGDownStreamNodeType(Integer lgDownStreamNodeType) {
        this.m_factory.setLGDownStreamNodeType(lgDownStreamNodeType.intValue());
    }

    @Override
    public Boolean getRequireActionalJMSNode() {
        return this.m_factory.getRequireActionalJMSNode();
    }

    @Override
    public void setRequireActionalJMSNode(Boolean requireActionalJMSNode) {
        this.m_factory.setRequireActionalJMSNode(requireActionalJMSNode.booleanValue());
    }

    @Override
    public void setJCAJMSMaxReferencesPerConnection(Integer value) throws ResourceException {
        if (this.m_maxReferencesPerConnection == 0) {
            this.m_maxReferencesPerConnection = value;
            return;
        }
        throw new IllegalStateException("Cannot set MaxReferencesPerConnection directly on the javax.jms.ConnectionFactory");
    }

    @Override
    public Integer getJCAJMSMaxReferencesPerConnection() {
        return new Integer(this.m_maxReferencesPerConnection);
    }

    @Override
    public void setDebugLevel(Integer value) {
        JCAGlobalProperties.setDebugLevel(value);
    }

    @Override
    public Integer getDebugLevel() {
        return new Integer(JCAGlobalProperties.getDebugLevel());
    }

    @Override
    public void setJCAJMSPoolSessions(Boolean poolSessions) {
        this.m_poolSessions = poolSessions;
    }

    @Override
    public Boolean getJCAJMSPoolSessions() {
        return new Boolean(this.m_poolSessions);
    }

    @Override
    public void setJCAJMSPreserveSessionsMidTxn(Boolean value) {
        this.m_preserveSessionsMidTxn = value;
    }

    @Override
    public Boolean getJCAJMSPreserveSessionsMidTxn() {
        return new Boolean(this.m_preserveSessionsMidTxn);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SonicConnectionFactoryPropertiesImpl) {
            return SonicUtils.sonicPropsEqual(this, (SonicConnectionFactoryPropertiesImpl)obj);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

