/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicFailureListenerWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicRejectionListenerWrapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.jclient.ConnectionStateChangeListener;
import progress.message.jclient.RejectionListener;
import progress.message.jimpl.Connection;

public class SonicConnectionTracking
extends ConnectionTracking {
    private Set m_connectionListeners = Collections.synchronizedSet(new HashSet());
    private Set m_rejectionListeners = Collections.synchronizedSet(new HashSet());
    private long m_pingInterval = -1L;
    private long m_monitorInterval = -1L;

    public SonicConnectionTracking(Object key, javax.jms.Connection connection, String username, String password) throws JMSException {
        super(key, connection, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListeners() throws JMSException {
        javax.jms.Connection connection;
        super.registerListeners();
        javax.jms.Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            boolean isClosed = ((Connection)connection).isClosed();
            boolean isClosing = ((Connection)connection).isClosing();
            if (isClosed || isClosing) {
                throw new IllegalStateException("Connection is closed");
            }
            ((progress.message.jclient.Connection)connection).setConnectionStateChangeListener((ConnectionStateChangeListener)new SonicFailureListenerWrapper(this));
        }
        ((progress.message.jclient.Connection)connection).setRejectionListener((RejectionListener)new SonicRejectionListenerWrapper(this));
    }

    public void addConnectionListener(ConnectionStateChangeListener listener) {
        if (listener != null) {
            this.m_connectionListeners.add(listener);
        }
    }

    public void removeConnectionListener(ConnectionStateChangeListener listener) {
        if (listener != null) {
            this.m_connectionListeners.remove(listener);
        }
    }

    public void addRejectionListener(RejectionListener listener) {
        if (listener != null) {
            this.m_rejectionListeners.add(listener);
        }
    }

    public void removeRejectionListener(RejectionListener listener) {
        if (listener != null) {
            this.m_rejectionListeners.remove(listener);
        }
    }

    public void fireConnectionStateChangeListeners(int state) {
        for (ConnectionStateChangeListener listener : this.m_connectionListeners) {
            listener.connectionStateChanged(state);
        }
    }

    public void fireRejectionListeners(Message m, JMSException e) {
        for (RejectionListener listener : this.m_rejectionListeners) {
            listener.onRejectedMessage(m, e);
        }
    }

    public void setPingInterval(long pingInterval) {
        if (this.m_pingInterval == -1L) {
            this.m_pingInterval = pingInterval;
            ((progress.message.jclient.Connection)this.getConnection()).setPingInterval(pingInterval);
        } else if (pingInterval < this.m_pingInterval) {
            this.m_pingInterval = pingInterval;
            ((progress.message.jclient.Connection)this.getConnection()).setPingInterval(pingInterval);
        }
    }

    public void setInitialPingInterval(long pingInterval) {
        this.m_pingInterval = pingInterval;
    }
}

