/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.RAUtils;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.XAResourceWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicActivation;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicActivationSpec;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicServerSessionPool;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class SonicServerSession
implements ServerSession,
MessageListener,
Work,
WorkListener {
    private final SonicServerSessionPool m_pool;
    private Session m_session = null;
    private XASession m_xaSession = null;
    private XAResourceWrapper m_xaResourceWrapper = null;
    private MessageEndpoint m_endpoint = null;

    public SonicServerSession(SonicServerSessionPool pool) {
        this.m_pool = pool;
    }

    public Session getSession() throws JMSException {
        return this.m_session;
    }

    public void start() throws JMSException {
        SonicActivation activation = this.m_pool.getActivation();
        WorkManager workManager = activation.getWorkManager();
        try {
            workManager.scheduleWork((Work)this, Long.MAX_VALUE, null, (WorkListener)this);
        }
        catch (WorkException e) {
            RAUtils.printException("SonicServerSession.start() unable to schedule work", e);
            throw new JMSException("Unable to schedule work: " + e.toString());
        }
    }

    public void setup() throws JMSException {
        SonicActivation activation = this.m_pool.getActivation();
        SonicActivationSpec spec = activation.getActivationSpec();
        Connection connection = activation.getConnection();
        if (connection instanceof XAConnection) {
            this.m_xaSession = ((XAConnection)connection).createXASession();
            this.m_session = this.m_xaSession.getSession();
            RAUtils.printDebug("setup() created XA session " + this.m_xaSession.hashCode() + " jms session " + this.m_session.hashCode());
        } else {
            boolean transacted = spec.isSessionTransacted();
            int ackMode = spec.getAcknowledgeModeAsInt();
            this.m_session = connection.createSession(transacted, ackMode);
            RAUtils.printDebug("setup() created jms session " + this.m_session.hashCode() + " transacted=" + transacted + " ackMode=" + ackMode);
        }
        MessageEndpointFactory endpointFactory = activation.getEndpointFactory();
        this.m_xaResourceWrapper = null;
        if (activation.isDeliveryTransacted() && this.m_xaSession != null) {
            this.m_xaResourceWrapper = new XAResourceWrapper(this.m_xaSession.getXAResource());
        }
        try {
            this.m_endpoint = endpointFactory.createEndpoint((XAResource)this.m_xaResourceWrapper);
        }
        catch (UnavailableException e) {
            JMSException je = new JMSException("Unable to setup ServerSession");
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
        this.m_session.setMessageListener((MessageListener)this);
    }

    void teardown() {
        RAUtils.printDebug("teardown(), this=" + String.valueOf(this) + " " + Thread.currentThread().getName());
        try {
            if (this.m_endpoint != null) {
                this.m_endpoint.release();
            }
            if (this.m_xaSession != null) {
                this.m_xaSession.close();
            }
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (Throwable t) {
            RAUtils.printException("SonicServerSession.teardown() ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Object msgInfo = " ";
        try {
            msgInfo = (message instanceof TextMessage ? ((TextMessage)message).getText() : "") + "\" " + (message.getJMSRedelivered() ? "re" : "") + "delivered with deliveryCount " + message.getIntProperty("JMSXDeliveryCount");
            RAUtils.printDebug("SonicServerSession.onMessage() entered on " + Thread.currentThread().getName() + " " + (String)msgInfo);
            try {
                if (message.getJMSRedelivered()) {
                    int deliveryCount = message.getIntProperty("JMSXDeliveryCount");
                    int maxDeliveryCount = this.m_pool.getActivation().getActivationSpec().getMaxDeliveryCountAsInt();
                    if (maxDeliveryCount > 0 && deliveryCount > maxDeliveryCount) {
                        RAUtils.printDebug("Message delivery on " + Thread.currentThread().getName() + " limited by Sonic Resource Adapter. JMSXDeliveryCount of " + deliveryCount + " exceeds maxDeliveryCount of " + maxDeliveryCount);
                        message.acknowledge();
                        return;
                    }
                }
            }
            catch (Exception deliveryCount) {
                // empty catch block
            }
            this.m_endpoint.beforeDelivery(SonicActivation.ONMESSAGE);
            try {
                ((MessageListener)this.m_endpoint).onMessage(message);
            }
            finally {
                try {
                    this.m_endpoint.afterDelivery();
                }
                catch (IllegalStateException ile) {
                    this.m_endpoint.beforeDelivery(SonicActivation.ONMESSAGE);
                    this.m_endpoint.afterDelivery();
                }
            }
        }
        catch (Throwable t) {
            RAUtils.printException("SonicServerSession.onMessage() exception occurred on message " + (String)msgInfo, t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void release() {
        RAUtils.printDebug("SonicServerSession.release() called by " + Thread.currentThread().getName());
    }

    public void run() {
        this.m_session.run();
    }

    public void workAccepted(WorkEvent event) {
    }

    public void workStarted(WorkEvent event) {
    }

    public void workCompleted(WorkEvent event) {
        this.m_pool.returnServerSession(this);
    }

    public void workRejected(WorkEvent event) {
        this.m_pool.returnServerSession(this);
    }
}

