/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic;

import com.sonicsw.sonicmq.j2ee.jmsra.impl.ConnectionTracking;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionPool;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSConnectionRequestInfo;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSManagedConnectionFactory;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.JMSSessionManagedConnection;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicTopicSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicTopicSessionWrapper;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXAConnectionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.impl.sonic.SonicXATopicSessionAdapter;
import com.sonicsw.sonicmq.j2ee.jmsra.sonicra.SonicXATopicConnection;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import progress.message.jclient.TopicSession;
import progress.message.jclient.xa.XAConnection;
import progress.message.jclient.xa.XATopicConnection;
import progress.message.jclient.xa.XATopicSession;

public class SonicXATopicConnectionAdapter
extends SonicXAConnectionAdapter
implements SonicXATopicConnection {
    XATopicConnection m_connection;

    public SonicXATopicConnectionAdapter(ConnectionTracking tracking, XATopicConnection connection, ConnectionManager cm, JMSManagedConnectionFactory mcf) {
        super(tracking, (XAConnection)connection, cm, mcf);
        this.m_connection = connection;
    }

    public TopicConnection getTopicConnection() throws JMSException {
        this.checkClosed();
        return this.m_connection.getTopicConnection();
    }

    public javax.jms.TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(transacted, transacted, ackMode, this, this.getConnectionID(), 1, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            if (transacted) {
                SonicXATopicSessionAdapter adapter = (SonicXATopicSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
                TopicSession session = (TopicSession)adapter.getSession();
                return new SonicTopicSessionWrapper(session, adapter.getManagedConnection(), this.getPoolSessions());
            }
            return (SonicTopicSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public javax.jms.TopicSession createTopicSession(boolean transacted, int ackMode, String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        this.checkClosed();
        throw new JMSException("Connection Consumer is not supported");
    }

    public javax.jms.XATopicSession createXATopicSession() throws JMSException {
        this.checkClosed();
        JMSConnectionRequestInfo ci = new JMSConnectionRequestInfo(true, true, 0, this, this.getConnectionID(), 4, this.getPoolSessions(), this.getPreserveSessionsMidTxn());
        try {
            return (SonicXATopicSessionAdapter)this.m_cm.allocateConnection(this.m_mcf, (ConnectionRequestInfo)ci);
        }
        catch (ResourceException e) {
            JMSException je = new JMSException(e.getMessage());
            je.setLinkedException((Exception)((Object)e));
            throw je;
        }
    }

    public javax.jms.XATopicSession createXATopicSession(String sessionName) throws JMSException {
        this.checkClosed();
        throw new JMSException("Creating JMS Sessions with explicit names is not supported in the JCA Resource Adapter");
    }

    @Override
    public JMSSessionAdapter createSession(boolean isXA, boolean isTransacted, int ackMode, JMSSessionManagedConnection mc) throws JMSException {
        JMSSessionAdapter adapter;
        if (isXA) {
            javax.jms.XATopicSession session = (javax.jms.XATopicSession)mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createXATopicSession();
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicXATopicSessionAdapter((JMSConnectionAdapter)this, (XATopicSession)session, mc);
        } else {
            javax.jms.TopicSession session = (javax.jms.TopicSession)mc.getJMSSession();
            if (session == null) {
                session = this.m_connection.createTopicSession(isTransacted, ackMode);
                JMSConnectionPool.addReference(this.getConnectionTracking());
                this.getConnectionTracking().addChildObject(mc);
            }
            this.trackSession(mc);
            adapter = new SonicTopicSessionAdapter((JMSConnectionAdapter)this, (TopicSession)session, mc);
        }
        return adapter;
    }
}

