/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor;

import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.util.NotificationForwarder;
import com.sonicsw.mf.jmx.client.MFNotification;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.HashMap;
import java.util.HashSet;

final class NotificationManager
implements INotificationHandler {
    private IFrameworkComponentContext m_context;
    private HashMap m_idMap = new HashMap();
    private long m_notificationSubscriptionRenewalInterval = 30000L;
    private boolean m_debug = false;
    private static final String[] EMPTY_STRING_ARRAY = IEmptyArray.EMPTY_STRING_ARRAY;

    NotificationManager(IFrameworkComponentContext context) {
        this.m_context = context;
    }

    void cleanup() {
        this.unsubscribe(null);
        this.m_idMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationHandler(String notificationSource, String[] notificationTypes, INotificationHandler handler) {
        boolean subscribe = false;
        HashMap hashMap = this.m_idMap;
        synchronized (hashMap) {
            HashMap notificationTypeMap = (HashMap)this.m_idMap.get(notificationSource);
            if (notificationTypeMap == null) {
                notificationTypeMap = new HashMap();
                this.m_idMap.put(notificationSource, notificationTypeMap);
            }
            for (int i = 0; i < notificationTypes.length; ++i) {
                HashSet<INotificationHandler> handlerSet = (HashSet<INotificationHandler>)notificationTypeMap.get(notificationTypes[i]);
                if (handlerSet == null) {
                    handlerSet = new HashSet<INotificationHandler>();
                    notificationTypeMap.put(notificationTypes[i], handlerSet);
                }
                if (handlerSet.contains(handler)) continue;
                handlerSet.add(handler);
                subscribe = true;
            }
        }
        if (subscribe) {
            this.subscribe(new String[]{notificationSource});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeNotificationHandler(String notificationSource, String[] notificationTypes, INotificationHandler handler) {
        boolean unsubscribe = false;
        HashMap hashMap = this.m_idMap;
        synchronized (hashMap) {
            HashMap notificationTypeMap = (HashMap)this.m_idMap.get(notificationSource);
            if (notificationTypeMap == null) {
                return;
            }
            for (int i = 0; i < notificationTypes.length; ++i) {
                HashSet handlerSet = (HashSet)notificationTypeMap.get(notificationTypes[i]);
                if (handlerSet == null) {
                    return;
                }
                handlerSet.remove(handler);
                if (!handlerSet.isEmpty()) continue;
                notificationTypeMap.remove(notificationTypes[i]);
                if (!notificationTypeMap.isEmpty()) continue;
                this.m_idMap.remove(notificationSource);
                unsubscribe = true;
            }
        }
        if (unsubscribe) {
            this.unsubscribe(new String[]{notificationSource});
        }
    }

    void subscribe(String[] notificationSources) {
        if (notificationSources == null) {
            notificationSources = this.getAllNotificationSources();
        }
        this.m_context.setNotificationSubscriptionRenewalInterval(new Long(this.m_notificationSubscriptionRenewalInterval));
        for (int i = 0; i < notificationSources.length; ++i) {
            String[] notificationTypes;
            HashMap notificationTypeMap = (HashMap)this.m_idMap.get(notificationSources[i]);
            String[] stringArray = notificationTypes = notificationTypeMap == null ? EMPTY_STRING_ARRAY : notificationTypeMap.keySet().toArray(EMPTY_STRING_ARRAY);
            if (notificationTypes.length == 0) {
                this.m_context.removeNotificationHandler(notificationSources[i], (INotificationHandler)this);
                continue;
            }
            this.m_context.addNotificationHandler(notificationSources[i], (INotificationHandler)this, notificationTypes);
        }
    }

    void unsubscribe(String[] notificationSources) {
        if (notificationSources == null) {
            notificationSources = this.getAllNotificationSources();
        }
        for (int i = 0; i < notificationSources.length; ++i) {
            this.m_context.removeNotificationHandler(notificationSources[i], (INotificationHandler)this);
        }
    }

    private String[] getAllNotificationSources() {
        return this.m_idMap.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    synchronized void setNotificationSubscriptionRenewalInterval(long notificationSubscriptionRenewalInterval) {
        this.m_notificationSubscriptionRenewalInterval = notificationSubscriptionRenewalInterval;
        this.m_context.setNotificationSubscriptionRenewalInterval(new Long(notificationSubscriptionRenewalInterval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(INotification notification) {
        HashSet keys;
        HashMap notificationTypeMap;
        if (this.m_debug) {
            this.m_context.logMessage("Notification [" + notification.getType() + "] received from " + notification.getSourceIdentity().getCanonicalName(), 7);
        }
        if ((notificationTypeMap = (HashMap)this.m_idMap.get(notification.getSourceIdentity().getCanonicalName())) == null) {
            return;
        }
        HashSet handlerSet = (HashSet)notificationTypeMap.get(notification.getType());
        if (handlerSet == null) {
            String notificationType = notification.getType();
            keys = notificationTypeMap.keySet();
            for (String key : keys) {
                String notificationTypeSubstring;
                if (!key.endsWith("*")) continue;
                int index = key.indexOf("*");
                String typeSubstring = key.substring(0, index - 1);
                if (notificationType.length() < index || !typeSubstring.equals(notificationTypeSubstring = notificationType.substring(0, index - 1))) continue;
                handlerSet = (HashSet)notificationTypeMap.get(key);
                break;
            }
        }
        if (handlerSet == null) {
            return;
        }
        Object[] handlers = null;
        keys = handlerSet;
        synchronized (keys) {
            handlers = handlerSet.toArray();
        }
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i] instanceof NotificationForwarder && notification instanceof MFNotification) {
                MFNotification clonedNotification = new MFNotification((MFNotification)notification);
                ((INotificationHandler)handlers[i]).handleNotification((INotification)clonedNotification);
                continue;
            }
            ((INotificationHandler)handlers[i]).handleNotification(notification);
        }
    }

    void setDebug(boolean debug) {
        this.m_debug = debug;
    }
}

