/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor.storage.jdbc;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.monitor.IHistoryStorageListener;
import com.sonicsw.mf.framework.monitor.storage.EventHolder;
import com.sonicsw.mf.framework.monitor.storage.IHistoryStorage;
import com.sonicsw.mf.framework.monitor.storage.StorageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public final class JDBCStorage
implements IHistoryStorage {
    public static final long DEFAULT_EXPIRE_AFTER = 172800000L;
    public static final long MIN_EXPIRE_AFTER = 3600000L;
    private static final String JDBC_DRIVER = "com.borland.datastore.jdbc.DataStoreDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:borland:dslocal:";
    private long m_expireAfter = 172800000L;
    private String m_url;
    private String m_user;
    private String m_password;
    private String m_blobSQLDatatype;
    private String m_tableNotFound;
    private String m_uniqueConstraint;
    private String m_tablePrefix;
    private Connection m_notificationConnection;
    private Connection m_metricConnection;
    private IComponentContext m_context;
    private Runnable m_expirationTask;
    private IHistoryStorageListener m_listener;

    public JDBCStorage(String driver, String url, String user, String password, String blobSQLDatatype, String tableNotFound, String uniqueConstraint, String instanceName, IComponentContext context) throws StorageException {
        this.m_context = context;
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        this.m_blobSQLDatatype = blobSQLDatatype;
        this.m_tableNotFound = tableNotFound;
        this.m_uniqueConstraint = uniqueConstraint;
        this.m_tablePrefix = instanceName.toUpperCase();
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            this.cleanup();
            throw new StorageException("Failed stoarge initialization", e);
        }
    }

    @Override
    public void open() throws StorageException {
        this.cleanup();
        try {
            this.m_notificationConnection = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
            this.m_notificationConnection.setTransactionIsolation(2);
            this.m_notificationConnection.setAutoCommit(true);
            this.m_metricConnection = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
            this.m_metricConnection.setTransactionIsolation(2);
            this.m_metricConnection.setAutoCommit(true);
            if (this.isNewStore()) {
                this.m_context.logMessage("Existing history storage not found, creating new tables", 3);
                this.setupNewStore();
            }
            this.m_expirationTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!JDBCStorage.this.m_notificationConnection.isClosed()) {
                            JDBCStorage.this.expireData(System.currentTimeMillis() - JDBCStorage.this.m_expireAfter);
                            JDBCStorage.this.m_context.scheduleTask(JDBCStorage.this.m_expirationTask, new Date(System.currentTimeMillis() + 30000L));
                        }
                    }
                    catch (Exception e) {
                        JDBCStorage.this.m_context.logMessage("Failed to delete expired history", (Throwable)e, 2);
                    }
                }
            };
            this.m_context.scheduleTask(this.m_expirationTask, new Date(System.currentTimeMillis() + 30000L));
        }
        catch (Exception e) {
            this.cleanup();
            throw new StorageException("Failed to open storage.", e);
        }
    }

    @Override
    public synchronized void close() throws StorageException {
        this.cleanup();
    }

    @Override
    public synchronized void setExpireAfter(long expireAfter) {
        if (expireAfter < 3600000L) {
            throw new IllegalArgumentException("Can use expiration > 3600000 milliseconds");
        }
        this.m_expireAfter = expireAfter;
    }

    @Override
    public synchronized long getExpireAfter() {
        return this.m_expireAfter;
    }

    @Override
    public void setMaxStorageSize(long maxStorageSize) {
        throw new RuntimeException("A maximum storage size may not be set for a JDBC store.");
    }

    @Override
    public long getMaxStorageSize() {
        throw new RuntimeException("A JDBC store may not have a maximum storage size");
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.expireData(Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new StorageException("Storage clear failure.", e);
        }
    }

    public void finalize() {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNotification(INotification notification) throws StorageException {
        Connection connection = this.m_notificationConnection;
        synchronized (connection) {
            Statement stmt = null;
            try {
                StringBuilder sbQuery = new StringBuilder("INSERT INTO ");
                sbQuery.append(this.m_tablePrefix).append("notifications VALUES (?, ?, ?, ?)");
                stmt = this.m_notificationConnection.prepareStatement(sbQuery.toString());
                stmt.setLong(1, notification.getTimeStamp());
                stmt.setString(2, notification.getType());
                stmt.setString(3, notification.getSourceIdentity().getCanonicalName());
                stmt.setBytes(4, this.toBytes((Serializable)notification));
                stmt.executeUpdate();
            }
            catch (Exception e) {
                if (e instanceof SQLException && ((SQLException)e).getSQLState().equals(this.m_uniqueConstraint)) {
                    return;
                }
                throw new StorageException("Storage insertion failure.", e);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_listener != null) {
            this.m_listener.onNotificationStored(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMetrics(IMetric[] metrics, String source) throws StorageException {
        Connection connection = this.m_metricConnection;
        synchronized (connection) {
            for (int i = 0; i < metrics.length; ++i) {
                Statement stmt = null;
                try {
                    StringBuilder sbQuery = new StringBuilder("INSERT INTO ");
                    sbQuery.append(this.m_tablePrefix).append("metrics VALUES (?, ?, ?, ?)");
                    stmt = this.m_metricConnection.prepareStatement(sbQuery.toString());
                    stmt.setLong(1, metrics[i].getCurrencyTimestamp());
                    stmt.setString(2, metrics[i].getMetricIdentity().getName());
                    stmt.setString(3, source);
                    stmt.setBytes(4, this.toBytes((Serializable)MetricsFactory.createMetric((String)source, (IMetric)metrics[i])));
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    if (e instanceof SQLException && ((SQLException)e).getSQLState().equals(this.m_uniqueConstraint)) {
                        return;
                    }
                    throw new StorageException("Storage insertion failure.", e);
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (this.m_listener == null) continue;
                this.m_listener.onMetricStored(metrics[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getNotifications(String[] notificationTypes, String[] notificationSources, long latest, long earliest) throws StorageException {
        int i;
        StringBuffer query = new StringBuffer();
        query.append("SELECT notification FROM " + this.m_tablePrefix + "notifications");
        query.append(" WHERE");
        query.append(" currency <= " + latest + " AND");
        query.append(" currency >= " + earliest + " AND");
        query.append(" (");
        for (i = notificationTypes.length - 1; i >= 0; --i) {
            query.append("type = '" + notificationTypes[i] + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" AND");
        query.append(" (");
        for (i = notificationSources.length - 1; i >= 0; --i) {
            query.append("source = '" + notificationSources[i] + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" ORDER BY currency DESC");
        Statement stmt = null;
        try {
            Connection connection = this.m_notificationConnection;
            synchronized (connection) {
                try {
                    stmt = this.prepareStatement(this.m_notificationConnection, query.toString());
                    ResultSet results = stmt.executeQuery();
                    ArrayList<EventHolder> notifications = new ArrayList<EventHolder>();
                    while (results.next()) {
                        byte[] bytes = results.getBytes(1);
                        try {
                            INotification notification = (INotification)this.fromBytes(bytes);
                            EventHolder holder = new EventHolder(notification, notification.getTimeStamp());
                            notifications.add(holder);
                        }
                        catch (Exception e) {
                            throw new StorageException("Storage retrieval failure.", e);
                        }
                    }
                    results.close();
                    Iterator iterator = notifications.iterator();
                    return iterator;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new StorageException("Storage retrieval failure.", e);
                    }
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getNotifications(String[] notificationSources, long latest, long earliest) throws StorageException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT notification FROM " + this.m_tablePrefix + "notifications");
        query.append(" WHERE");
        query.append(" currency <= " + latest + " AND");
        query.append(" currency >= " + earliest + " AND");
        query.append("type = *");
        query.append(" AND");
        query.append(" (");
        for (int i = notificationSources.length - 1; i >= 0; --i) {
            query.append("source = '" + notificationSources[i] + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" ORDER BY currency DESC");
        Statement stmt = null;
        try {
            Connection connection = this.m_notificationConnection;
            synchronized (connection) {
                try {
                    stmt = this.prepareStatement(this.m_notificationConnection, query.toString());
                    ResultSet results = stmt.executeQuery();
                    ArrayList<EventHolder> notifications = new ArrayList<EventHolder>();
                    while (results.next()) {
                        byte[] bytes = results.getBytes(1);
                        try {
                            INotification notification = (INotification)this.fromBytes(bytes);
                            EventHolder holder = new EventHolder(notification, notification.getTimeStamp());
                            notifications.add(holder);
                        }
                        catch (Exception e) {
                            throw new StorageException("Storage retrieval failure.", e);
                        }
                    }
                    results.close();
                    Iterator iterator = notifications.iterator();
                    return iterator;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new StorageException("Storage retrieval failure.", e);
                    }
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getMetrics(IMetricIdentity[] metricIDs, String[] componentIdentities, long latest, long earliest) throws StorageException {
        int i;
        StringBuffer query = new StringBuffer();
        query.append("SELECT metric FROM " + this.m_tablePrefix + "metrics");
        query.append(" WHERE");
        query.append(" currency <= " + latest + " AND");
        query.append(" currency >= " + earliest + " AND");
        query.append(" (");
        for (i = metricIDs.length - 1; i >= 0; --i) {
            query.append("name = '" + metricIDs[i].getName() + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" AND");
        query.append(" (");
        for (i = componentIdentities.length - 1; i >= 0; --i) {
            query.append("source = '" + componentIdentities[i] + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" ORDER BY currency DESC");
        Statement stmt = null;
        try {
            Connection connection = this.m_metricConnection;
            synchronized (connection) {
                try {
                    stmt = this.prepareStatement(this.m_metricConnection, query.toString());
                    ResultSet results = stmt.executeQuery();
                    ArrayList<EventHolder> metrics = new ArrayList<EventHolder>();
                    while (results.next()) {
                        byte[] bytes = results.getBytes(1);
                        try {
                            IHistoricalMetric metric = (IHistoricalMetric)this.fromBytes(bytes);
                            EventHolder holder = new EventHolder(metric, metric.getCurrencyTimestamp());
                            metrics.add(holder);
                        }
                        catch (Exception e) {
                            throw new StorageException("Storage retrieval failure.", e);
                        }
                    }
                    results.close();
                    Iterator iterator = metrics.iterator();
                    return iterator;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new StorageException("Storage retrieval failure.", e);
                    }
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getMetrics(String[] componentIdentities, long latest, long earliest) throws StorageException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT metric FROM " + this.m_tablePrefix + "metrics");
        query.append(" WHERE");
        query.append(" currency <= " + latest + " AND");
        query.append(" currency >= " + earliest + " AND");
        query.append("name = *");
        query.append(" AND");
        query.append(" (");
        for (int i = componentIdentities.length - 1; i >= 0; --i) {
            query.append("source = '" + componentIdentities[i] + '\'');
            if (i <= 0) continue;
            query.append(" OR ");
        }
        query.append(")");
        query.append(" ORDER BY currency DESC");
        Statement stmt = null;
        try {
            Connection connection = this.m_metricConnection;
            synchronized (connection) {
                try {
                    stmt = this.prepareStatement(this.m_metricConnection, query.toString());
                    ResultSet results = stmt.executeQuery();
                    ArrayList<EventHolder> metrics = new ArrayList<EventHolder>();
                    while (results.next()) {
                        byte[] bytes = results.getBytes(1);
                        try {
                            IHistoricalMetric metric = (IHistoricalMetric)this.fromBytes(bytes);
                            EventHolder holder = new EventHolder(metric, metric.getCurrencyTimestamp());
                            metrics.add(holder);
                        }
                        catch (Exception e) {
                            throw new StorageException("Storage retrieval failure.", e);
                        }
                    }
                    results.close();
                    Iterator iterator = metrics.iterator();
                    return iterator;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new StorageException("Storage retrieval failure.", e);
                    }
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    private void cleanup() {
        if (this.m_expirationTask != null) {
            this.m_context.cancelTask(this.m_expirationTask);
        }
        if (this.m_notificationConnection != null) {
            try {
                this.m_notificationConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.m_metricConnection != null) {
            try {
                this.m_metricConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewStore() throws Exception {
        Statement stmt = null;
        try {
            stmt = this.prepareStatement(this.m_notificationConnection, "SELECT currency FROM " + this.m_tablePrefix + "notifications WHERE currency > " + Long.MAX_VALUE);
            stmt.executeUpdate();
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = !e.getSQLState().equals(this.m_tableNotFound);
            return bl;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupNewStore() throws Exception {
        Statement stmt_notif_tab = null;
        Statement stmt_notif_idx = null;
        Statement stmt_metrics_tab = null;
        Statement stmt_metrics_idx = null;
        try {
            StringBuilder query = new StringBuilder("CREATE TABLE ");
            query.append(this.m_tablePrefix).append("notifications ").append("(currency VARCHAR(24) NOT NULL,");
            query.append(" type VARCHAR(128) NOT NULL,").append(" source VARCHAR(128) NOT NULL,");
            query.append(" notification ").append(this.m_blobSQLDatatype).append(" NOT NULL,");
            query.append(" PRIMARY KEY (currency, type, source))");
            String createTableQuery = query.toString();
            query = new StringBuilder("CREATE INDEX notificationsIdx ON ");
            query.append(this.m_tablePrefix).append("notifications ").append("(currency DESC, type, source)");
            String createIndexQuery = query.toString();
            stmt_notif_tab = this.prepareStatement(this.m_notificationConnection, createTableQuery);
            stmt_notif_tab.executeUpdate();
            stmt_notif_idx = this.prepareStatement(this.m_notificationConnection, createIndexQuery);
            stmt_notif_idx.executeUpdate();
            query = new StringBuilder("CREATE TABLE ");
            query.append(this.m_tablePrefix).append("metrics ").append("(currency VARCHAR(24) NOT NULL,");
            query.append(" name VARCHAR(256) NOT NULL,").append(" source VARCHAR(128) NOT NULL,");
            query.append(" metric ").append(this.m_blobSQLDatatype).append(" NOT NULL,");
            query.append(" PRIMARY KEY (currency, name, source))");
            createTableQuery = query.toString();
            query = new StringBuilder("CREATE INDEX metricsIdx ON ");
            query.append(this.m_tablePrefix).append("metrics ").append("(currency DESC, name, source)");
            createIndexQuery = query.toString();
            stmt_metrics_tab = this.prepareStatement(this.m_metricConnection, createTableQuery);
            stmt_metrics_tab.executeUpdate();
            stmt_metrics_idx = this.prepareStatement(this.m_metricConnection, createIndexQuery);
            stmt_metrics_idx.executeUpdate();
        }
        finally {
            try {
                stmt_notif_tab.close();
            }
            catch (Exception exception) {}
            try {
                stmt_notif_idx.close();
            }
            catch (Exception exception) {}
            try {
                stmt_metrics_tab.close();
            }
            catch (Exception exception) {}
            try {
                stmt_metrics_idx.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireData(long olderThan) throws Exception {
        Statement stmt_notif = null;
        Statement stmt_metrics = null;
        try {
            stmt_notif = this.prepareStatement(this.m_notificationConnection, "DELETE FROM " + this.m_tablePrefix + "notifications WHERE currency < " + olderThan);
            stmt_notif.executeUpdate();
            stmt_metrics = this.prepareStatement(this.m_metricConnection, "DELETE FROM " + this.m_tablePrefix + "metrics WHERE currency < " + olderThan);
            stmt_notif.executeUpdate();
        }
        finally {
            try {
                stmt_notif.close();
            }
            catch (Exception exception) {}
            try {
                stmt_metrics.close();
            }
            catch (Exception exception) {}
        }
    }

    private byte[] toBytes(Serializable object) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        return baos.toByteArray();
    }

    private Object fromBytes(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    private PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    @Override
    public void setHistoryStorageListener(IHistoryStorageListener listener) {
        this.m_listener = listener;
    }
}

