/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.monitor.CollectionsMonitor;
import com.sonicsw.mf.framework.monitor.offload.AnalyticsOffloadException;
import com.sonicsw.mf.framework.monitor.storage.StorageException;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

final class CollectionMonitor
implements Runnable {
    private String m_collectionConfigID;
    private IFrameworkComponentContext m_frameworkContext;
    private CollectionsMonitor m_parent;
    private long m_metricsRefreshInterval;
    private long m_lastRequestedPollTime;
    private HashSet m_components = new HashSet();
    private HashSet m_slowComponents = new HashSet();
    private HashSet m_forwardNotifications = new HashSet();
    private HashMap m_notificationMonitors = new HashMap();
    private HashSet m_monitorMetrics = new HashSet();
    private BrokerStatusCollector m_brStatusCollector;
    private HashSet m_brokerComponents = new HashSet();
    private HashSet m_activeComponents = new HashSet();
    private HashSet m_inactiveComponents = new HashSet();
    private Hashtable m_metricInfos = new Hashtable();
    private Hashtable m_notificationInfos = new Hashtable();
    private Vector m_componentsWithoutInfos = new Vector();
    private InfoGetter m_infoGetterThread;
    private HashSet m_unknownNotificationInfos = new HashSet();
    private HashMap m_forwardNotificationInfos = new HashMap();
    private HashSet m_unknownMetricInfos = new HashSet();
    private HashMap m_monitoredMetricInfos = new HashMap();
    private HashMap m_metricInstances = new HashMap();
    private boolean m_enterpriseMessageRequiredLogged = false;
    public static final String DEFAULT_DESCRIPTION = "<unknown>";
    public static final int WAITING = 1;
    public static final int STANDALONE = 2;
    public static final int ACTIVE = 3;
    public static final int STANDBY = 4;
    public static final int ACTIVE_SYNC = 5;
    public static final int STANDBY_SYNC = 6;
    public static final String MQ_BROKER = "/mq/brokers/";
    public static final String MQ_BACKUPBROKER = "/mq/backupbrokers/";
    public static final int METRICS_DAMP_FACTOR = 2;
    public static final String THRESHOLD_NOTIFICATION_TYPE = "Threshold";
    public static final long GET_METRICS_TIMEOUT = 30000L;
    public static final long SLOW_POLL_INTERVAL = 60000L;
    public static final int MIN_METRICS_REFRESH_INTERVAL = 5;
    public static final Integer DEFAULT_METRICS_REFRESH_INTERVAL = new Integer(60);
    private boolean m_isClosing = false;
    private SlowCollector m_slowCollector;
    private long m_lastRequestedSlowPollTime;
    private long m_lastReqStatusPollTime;
    private long m_metricsSlowRefreshInterval = 60000L;
    private static final IMetricInfo[] EMPTY_METRIC_INFO_ARRAY = new IMetricInfo[0];
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY = new MBeanNotificationInfo[0];
    private static final String[] GET_METRICS_DATA_SIGNATURE = new String[]{IMetricIdentity[].class.getName(), Boolean.class.getName()};
    private static final String[] ENABLE_METRICS_SIGNATURE = new String[]{IMetricIdentity[].class.getName()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CollectionMonitor(String configID, IFrameworkComponentContext frameworkContext, CollectionsMonitor parent) {
        IAttributeSet notificationMonitorSet;
        IAttributeSet componentSet;
        this.m_collectionConfigID = configID;
        this.m_frameworkContext = frameworkContext;
        this.m_parent = parent;
        IElement collectionElement = frameworkContext.getConfiguration(configID, true);
        IAttributeSet collectionAttributes = collectionElement.getAttributes();
        IAttributeList forwardNotifications = (IAttributeList)collectionAttributes.getAttribute("FORWARD_NOTIFICATIONS");
        if (forwardNotifications != null) {
            for (int i = forwardNotifications.getCount() - 1; i >= 0; --i) {
                this.addForwardNotification((String)forwardNotifications.getItem(i));
            }
        }
        if ((componentSet = (IAttributeSet)collectionAttributes.getAttribute("COMPONENTS")) != null) {
            for (IAttributeSet componentAttrs : componentSet.getAttributes().values()) {
                String compName = (String)componentAttrs.getAttribute("COMPONENT_RUNTIME_ID");
                String compType = ((Reference)componentAttrs.getAttribute("CONFIG_REF")).getElementName();
                if (compType.contains(MQ_BROKER) || compType.contains(MQ_BACKUPBROKER)) {
                    this.m_brokerComponents.add(compName);
                }
                this.addComponent(compName);
            }
        }
        if ((notificationMonitorSet = (IAttributeSet)collectionAttributes.getAttribute("NOTIFICATION_MONITORS")) != null) {
            HashMap notificationMonitors = notificationMonitorSet.getAttributes();
            for (String name : notificationMonitors.keySet()) {
                this.addNotificationMonitor(name, (IAttributeSet)notificationMonitors.get(name));
            }
        }
        this.setMetricsRefreshInterval((Integer)collectionAttributes.getAttribute("METRICS_REFRESH_INTERVAL_SECONDS"));
        this.handleChangeMonitorMetricsAttr();
        this.m_slowCollector = new SlowCollector();
        this.m_brStatusCollector = new BrokerStatusCollector();
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            this.scheduleBrokerStatePoll();
            this.scheduleMetricsPoll();
            this.scheduleMetricsSlowPoll();
        }
    }

    private synchronized void setMetricsRefreshInterval(Integer intervalParam) {
        Integer interval = intervalParam;
        if (interval == null) {
            interval = DEFAULT_METRICS_REFRESH_INTERVAL;
        }
        if (interval < 5) {
            this.m_frameworkContext.logMessage("Invalid metrics refresh interval [" + interval + "] for collection [" + this.m_collectionConfigID + "], defaulting to " + DEFAULT_METRICS_REFRESH_INTERVAL + " seconds", 3);
            interval = DEFAULT_METRICS_REFRESH_INTERVAL;
        }
        this.m_metricsRefreshInterval = interval * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleMetricsPoll() {
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            if (this.m_monitorMetrics.isEmpty()) {
                return;
            }
        }
        this.m_lastRequestedPollTime = this.updateLastRequestPollTime(this.m_lastRequestedPollTime, this.m_metricsRefreshInterval);
        this.m_frameworkContext.scheduleTask((Runnable)this, new Date(this.m_lastRequestedPollTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBrokerStatePoll() {
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            if (this.m_monitorMetrics.isEmpty()) {
                return;
            }
        }
        if (this.m_lastReqStatusPollTime > 0L) {
            do {
                this.m_lastReqStatusPollTime += this.m_metricsSlowRefreshInterval * 2L;
            } while (this.m_lastReqStatusPollTime <= System.currentTimeMillis());
        } else {
            this.m_lastReqStatusPollTime = System.currentTimeMillis();
        }
        this.m_frameworkContext.scheduleTask((Runnable)this.m_brStatusCollector, new Date(this.m_lastReqStatusPollTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleMetricsSlowPoll() {
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            if (this.m_monitorMetrics.isEmpty()) {
                return;
            }
        }
        this.m_lastRequestedSlowPollTime = this.updateLastRequestPollTime(this.m_lastRequestedSlowPollTime, this.m_metricsSlowRefreshInterval);
        this.m_frameworkContext.scheduleTask((Runnable)this.m_slowCollector, new Date(this.m_lastRequestedSlowPollTime));
    }

    private long updateLastRequestPollTime(long m_lastRequestedPollTimeParam, long m_metricsRefreshInterval) {
        long m_lastRequestedPollTime = m_lastRequestedPollTimeParam;
        if (m_lastRequestedPollTime > 0L) {
            while ((m_lastRequestedPollTime += m_metricsRefreshInterval) <= System.currentTimeMillis()) {
            }
        } else {
            m_lastRequestedPollTime = System.currentTimeMillis();
        }
        return m_lastRequestedPollTime;
    }

    synchronized void cleanup() {
        this.m_isClosing = true;
        this.m_frameworkContext.cancelTask((Runnable)this);
        this.m_frameworkContext.cancelTask((Runnable)this.m_slowCollector);
        String[] components = this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        String[] notifications = this.m_forwardNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        for (int i = 0; i < components.length; ++i) {
            this.m_parent.m_notificationManager.removeNotificationHandler(components[i], notifications, (INotificationHandler)this.m_parent.m_notificationForwarder);
        }
        String[] mons = this.m_notificationMonitors.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        for (int i = 0; i < mons.length; ++i) {
            this.removeNotificationMonitor(mons[i]);
        }
        this.m_components.clear();
        this.m_brokerComponents.clear();
        this.m_activeComponents.clear();
        this.m_inactiveComponents.clear();
        this.m_slowComponents.clear();
        this.m_forwardNotifications.clear();
        this.m_notificationMonitors.clear();
    }

    synchronized String[] getCollectionComponents() {
        return this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    synchronized String[] getFastCollectionComponents() {
        Set fast = (Set)this.m_components.clone();
        fast.removeAll(this.m_slowComponents);
        fast.removeAll(this.m_inactiveComponents);
        return fast.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    synchronized String[] getSlowCollectionComponents() {
        Set slow = (Set)this.m_slowComponents.clone();
        slow.removeAll(this.m_inactiveComponents);
        return slow.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    synchronized IMetricInfo[] getMonitoredMetricsInfo() {
        this.updateMonitoredMetricInfosAndInstances();
        return this.m_monitoredMetricInfos.values().toArray(EMPTY_METRIC_INFO_ARRAY);
    }

    String[] getInstanceMetricNames(IMetricIdentity id) {
        this.updateMonitoredMetricInfosAndInstances();
        HashSet set = (HashSet)this.m_metricInstances.get(id.getName());
        if (set == null || set.isEmpty()) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        return set.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    private synchronized void updateMonitoredMetricInfosAndInstances() {
        IMetricIdentity[] unknowns = this.m_unknownMetricInfos.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        for (int i = 0; i < unknowns.length; ++i) {
            String unknownName = unknowns[i].getName();
            for (IMetricInfo info : this.m_metricInfos.values()) {
                IMetricIdentity id = info.getMetricIdentity();
                String name = id.getName();
                if (unknownName.equals(name)) {
                    this.m_monitoredMetricInfos.put(name, info);
                    this.m_unknownMetricInfos.remove(unknowns[i]);
                    break;
                }
                if (!unknowns[i].isInstanceOf(id)) continue;
                this.m_monitoredMetricInfos.put(name, info);
                String[] nameComponents = unknowns[i].getNameComponents();
                HashSet<String> instanceNames = (HashSet<String>)this.m_metricInstances.get(name);
                if (instanceNames == null) {
                    instanceNames = new HashSet<String>();
                    this.m_metricInstances.put(name, instanceNames);
                }
                instanceNames.add(nameComponents[nameComponents.length - 1]);
                this.m_unknownMetricInfos.remove(unknowns[i]);
                this.m_monitoredMetricInfos.remove(unknownName);
                break;
            }
            if (!this.m_unknownMetricInfos.contains(unknowns[i]) || this.m_monitoredMetricInfos.containsKey(unknownName)) continue;
            IMetricInfo dummy = MetricsFactory.createMetricInfo((IMetricIdentity)unknowns[i], (short)0, (String)DEFAULT_DESCRIPTION, null, (boolean)false, (boolean)false);
            this.m_monitoredMetricInfos.put(unknownName, dummy);
        }
    }

    synchronized MBeanNotificationInfo[] getForwardedNotificationsInfo() {
        String[] unknownNotificationInfos = this.m_unknownNotificationInfos.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        for (int i = 0; i < unknownNotificationInfos.length; ++i) {
            MBeanNotificationInfo info = (MBeanNotificationInfo)this.m_notificationInfos.get(unknownNotificationInfos[i]);
            if (info == null) continue;
            this.m_forwardNotificationInfos.put(unknownNotificationInfos[i], info);
            this.m_unknownNotificationInfos.remove(unknownNotificationInfos[i]);
        }
        return this.m_forwardNotificationInfos.values().toArray(EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getComponentInfos() {
        if (this.m_componentsWithoutInfos.isEmpty()) {
            return;
        }
        if (this.m_infoGetterThread == null) {
            this.m_infoGetterThread = new InfoGetter();
            this.m_infoGetterThread.start();
        } else {
            Object object = this.m_infoGetterThread.getInforGetterLockObj();
            synchronized (object) {
                this.m_infoGetterThread.getInforGetterLockObj().notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_isClosing) {
            return;
        }
        String[] components = this.getFastCollectionComponents();
        if ((this.m_parent.m_traceMask & 0x800) > 0) {
            this.m_frameworkContext.logMessage("Starting metrics poll on collection [" + this.m_collectionConfigID + "] for [" + components.length + "] components...", 7);
        }
        IMetricIdentity[] metrics = null;
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            metrics = this.m_monitorMetrics.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        }
        ICollectiveOpStatus results = null;
        try {
            if (components != null && components.length > 0) {
                results = this.m_frameworkContext.invoke(components, "getMetricsData", new Object[]{metrics, Boolean.FALSE}, GET_METRICS_DATA_SIGNATURE, true, 30000L);
            }
        }
        catch (Exception e) {
            this.m_frameworkContext.logMessage("Failed to poll for metrics on collection [" + this.m_collectionConfigID + ']', 2);
        }
        if (results != null) {
            for (int i = results.getCount() - 1; i >= 0; --i) {
                String component = results.getComponentName(i);
                if (results.operationIsSuccessful(i)) {
                    IMetricsData resultMetrics = (IMetricsData)results.getReturnValue(i);
                    if (resultMetrics == null || component == null) continue;
                    HashSet missingMetrics = this.storeMetrics(component, resultMetrics);
                    this.enableMetrics(missingMetrics, component);
                    continue;
                }
                Throwable throwable = results.getThrowable(i);
                boolean relegate = false;
                if (throwable instanceof InvokeTimeoutException) {
                    if ((this.m_parent.m_traceMask & 0x80) > 0) {
                        this.m_frameworkContext.logMessage("Timeout of poll for metrics on component [" + component + ']', 7);
                    }
                    relegate = true;
                } else if (throwable instanceof NoSuchMethodException) {
                    if ((this.m_parent.m_traceMask & 0x200) > 0) {
                        this.m_frameworkContext.logMessage("Failed to poll for metrics on component [" + component + "]: component does not provide any metrics", 7);
                    }
                    relegate = true;
                } else {
                    ICanonicalName cmName = this.m_frameworkContext.getComponentName();
                    CanonicalName componentName = new CanonicalName(component);
                    if (!cmName.getContainerName().equals(componentName.getContainerName()) || this.m_frameworkContext.getContainer().isBooted()) {
                        this.m_frameworkContext.logMessage("Failed to poll for metrics on component [" + component + "]", 2);
                        if ((this.m_parent.m_traceMask & 0x200) > 0) {
                            this.m_frameworkContext.logMessage("...trace follows...", throwable, 7);
                        }
                    }
                    relegate = true;
                }
                if (!relegate) continue;
                this.relegateFastComponent(component);
            }
        }
        if ((this.m_parent.m_traceMask & 0x800) > 0) {
            this.m_frameworkContext.logMessage("...finished metrics poll on collection [" + this.m_collectionConfigID + "] for [" + components.length + "] components...", 7);
        }
        if (!this.m_isClosing) {
            this.scheduleMetricsPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet storeMetrics(String component, IMetricsData metricsData) {
        HashSet missingMetrics = null;
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            missingMetrics = (HashSet)this.m_monitorMetrics.clone();
        }
        IMetric[] metrics = metricsData.getMetrics();
        try {
            for (int i = 0; i < metrics.length; ++i) {
                Iterator it = missingMetrics.iterator();
                ArrayList<IMetricIdentity> al = new ArrayList<IMetricIdentity>();
                while (it.hasNext()) {
                    IMetricIdentity mid = (IMetricIdentity)it.next();
                    if (!CollectionMonitor.isMatchWithMissingMetric(mid, metrics[i].getMetricIdentity())) continue;
                    al.add(mid);
                }
                it = al.iterator();
                while (it.hasNext()) {
                    missingMetrics.remove(it.next());
                }
            }
            if (this.m_parent != null && this.m_parent.m_offloader != null) {
                if (this.m_parent.isEnterprise()) {
                    this.m_parent.m_offloader.offloadMetrics(metrics, component);
                } else if (!this.m_enterpriseMessageRequiredLogged) {
                    this.m_frameworkContext.logMessage("Analytics offload is not supported and requires Enterprise Sonic Messaging", 1);
                    this.m_enterpriseMessageRequiredLogged = true;
                }
            } else if (this.m_parent != null && this.m_parent.m_store != null) {
                this.m_parent.m_store.storeMetrics(metrics, component);
            }
        }
        catch (AnalyticsOffloadException e) {
            if (this.m_parent != null && (this.m_parent.m_traceMask & 0x1000) > 0) {
                this.m_frameworkContext.logMessage("Failed to offload metrics, trace follows...", (Throwable)e, 7);
            } else {
                this.m_frameworkContext.logMessage("Failed to offload metrics", 2);
            }
        }
        catch (StorageException e) {
            if (this.m_parent != null && (this.m_parent.m_traceMask & 0x40) > 0) {
                this.m_frameworkContext.logMessage("Failed to store metrics, trace follows...", (Throwable)e, 7);
            }
            this.m_frameworkContext.logMessage("Failed to store metrics", 2);
        }
        return missingMetrics;
    }

    static boolean isMatchWithMissingMetric(IMetricIdentity missingMetricId, IMetricIdentity metricNameToEvaluate) {
        if (missingMetricId == null || metricNameToEvaluate == null || missingMetricId.getNameComponents().length < 2) {
            return false;
        }
        IMetricInfo[] info = new IMetricInfo[1];
        String[] midComponents = Arrays.copyOf(missingMetricId.getNameComponents(), missingMetricId.getNameComponents().length - 1);
        StringBuilder queueCountBuilder = new StringBuilder();
        queueCountBuilder.append(midComponents[0]);
        for (int i = 1; i < midComponents.length; ++i) {
            queueCountBuilder.append(".").append(midComponents[i]);
        }
        info[0] = MetricsFactory.createMetricInfo((IMetricIdentity)MetricsFactory.createMetricIdentity((String)queueCountBuilder.toString()), (short)0, (String)"", null, (boolean)true, (boolean)true);
        MetricsManager metricsManager = new MetricsManager(info, false);
        IMetricIdentity[] ids2 = new IMetricIdentity[]{MetricsFactory.createMetricIdentity((String)missingMetricId.getAbsoluteName())};
        metricsManager.enableMetrics(ids2);
        return metricsManager.isInstanceEnabled(metricNameToEvaluate);
    }

    private void enableMetrics(String component, HashSet enableMetrics) {
        try {
            IMetricIdentity[] metrics = enableMetrics.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
            if ((this.m_parent.m_traceMask & 0x100) > 0) {
                StringBuffer msg = new StringBuffer();
                msg.append("Enabling metrics on component [" + component + "], metrics:");
                for (int i = 0; i < metrics.length; ++i) {
                    msg.append(IContainer.NEWLINE).append('\t').append(metrics[i].getName());
                }
                this.m_frameworkContext.logMessage(msg.toString(), 7);
            }
            this.m_frameworkContext.invoke(component, "enableMetrics", new Object[]{metrics}, ENABLE_METRICS_SIGNATURE, true, 0L);
        }
        catch (Exception e) {
            if ((this.m_parent.m_traceMask & 0x100) > 0) {
                this.m_frameworkContext.logMessage("Failed to enable metrics on component [" + component + ", trace follows...", (Throwable)e, 2);
            }
            this.m_frameworkContext.logMessage("Failed to enable metrics on component [" + component + ']', 2);
        }
    }

    synchronized void handleElementChange(IElementChange elementChange) {
        String configID = elementChange.getElement().getIdentity().getName();
        if (!configID.equals(this.m_collectionConfigID)) {
            return;
        }
        try {
            if (elementChange.getChangeType() == 1) {
                IDeltaElement changeElement = (IDeltaElement)elementChange.getElement();
                IDeltaAttributeSet attrs = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
                this.handleNewCollectionAttrs(attrs.getNewAttributesNames(), attrs);
                this.handleModifiedCollectionAttrs(attrs.getModifiedAttributesNames(), attrs);
                this.handleDeletedCollectionAttrs(attrs.getDeletedAttributesNames());
            }
        }
        catch (Throwable e) {
            this.m_frameworkContext.logMessage("Error handling configuration change, trace follows...", e, 2);
        }
    }

    private void handleNewCollectionAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            this.handleFirstAttrs(attrs, i, names);
            if (names[i].equals("NOTIFICATION_MONITORS")) {
                this.handleNewNotificationMonitorsAttrs((IAttributeSet)attrs.getNewValue("NOTIFICATION_MONITORS"));
            }
            this.handleMonitorAttrs(i, names);
        }
    }

    private void handleModifiedCollectionAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            this.handleFirstAttrs(attrs, i, names);
            if (names[i].equals("NOTIFICATION_MONITORS")) {
                this.handleChangeNotificationMonitorsAttrs((IDeltaAttributeSet)attrs.getNewValue("NOTIFICATION_MONITORS"));
            }
            this.handleMonitorAttrs(i, names);
        }
    }

    private void handleMonitorAttrs(int i, String[] names) {
        if (names[i].equals("MONITOR_METRICS")) {
            this.handleChangeMonitorMetricsAttr();
        }
    }

    private void handleFirstAttrs(IDeltaAttributeSet attrs, int i, String[] names) throws NotModifiedAttException {
        if (names[i].equals("METRICS_REFRESH_INTERVAL_SECONDS")) {
            this.setMetricsRefreshInterval((Integer)attrs.getNewValue("METRICS_REFRESH_INTERVAL_SECONDS"));
        }
        if (names[i].equals("COMPONENTS")) {
            this.handleChangeComponentsAttr();
        }
        if (names[i].equals("FORWARD_NOTIFICATIONS")) {
            this.handleChangeForwardNotificationsAttr();
        }
    }

    private void handleDeletedCollectionAttrs(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("METRICS_REFRESH_INTERVAL_SECONDS")) continue;
            this.setMetricsRefreshInterval(null);
        }
    }

    private void handleChangeComponentsAttr() {
        int i;
        IElement collectionElement = this.m_frameworkContext.getConfiguration(this.m_collectionConfigID, true);
        IAttributeSet collectionAttrs = collectionElement.getAttributes();
        ArrayList<String> componentList = new ArrayList<String>();
        IAttributeSet componentSet = (IAttributeSet)collectionAttrs.getAttribute("COMPONENTS");
        for (IAttributeSet componentAttrs : componentSet.getAttributes().values()) {
            String compName = (String)componentAttrs.getAttribute("COMPONENT_RUNTIME_ID");
            String compType = ((Reference)componentAttrs.getAttribute("CONFIG_REF")).getElementName();
            if (compType.contains(MQ_BROKER) || compType.contains(MQ_BACKUPBROKER)) {
                this.m_brokerComponents.add(compName);
            }
            componentList.add(compName);
        }
        String[] components = componentList.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        String[] monitoredComponents = this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        ArrayList deletedComponents = new ArrayList();
        ArrayList newComponents = this.processNotifications(deletedComponents, monitoredComponents, components);
        String[] componentIDs = new String[1];
        for (i = deletedComponents.size() - 1; i >= 0; --i) {
            componentIDs[0] = (String)deletedComponents.get(i);
            this.m_brokerComponents.remove(componentIDs[0]);
            this.removeComponent(componentIDs[0]);
            this.m_parent.m_notificationManager.unsubscribe(componentIDs);
        }
        for (i = newComponents.size() - 1; i >= 0; --i) {
            componentIDs[0] = (String)newComponents.get(i);
            this.addComponent(componentIDs[0]);
            this.m_parent.m_notificationManager.subscribe(componentIDs);
        }
    }

    private synchronized void addComponent(String componentID) {
        this.m_components.add(componentID);
        this.m_componentsWithoutInfos.add(componentID);
        String[] notifications = this.m_forwardNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        this.m_parent.m_notificationManager.addNotificationHandler(componentID, notifications, (INotificationHandler)this.m_parent.m_notificationForwarder);
        for (NotificationMonitor monitor : this.m_notificationMonitors.values()) {
            monitor.addComponent(componentID);
        }
        this.getComponentInfos();
        this.enableMetrics(this.m_monitorMetrics, componentID);
    }

    private void enableMetrics(HashSet m_monitorMetrics, String componentID) {
        if (!m_monitorMetrics.isEmpty()) {
            this.enableMetrics(componentID, m_monitorMetrics);
        }
    }

    private synchronized void removeComponent(String componentID) {
        this.m_components.remove(componentID);
        this.m_slowComponents.remove(componentID);
        this.m_componentsWithoutInfos.remove(componentID);
        String[] notifications = this.m_forwardNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        this.m_parent.m_notificationManager.removeNotificationHandler(componentID, notifications, (INotificationHandler)this.m_parent.m_notificationForwarder);
        for (NotificationMonitor monitor : this.m_notificationMonitors.values()) {
            monitor.removeComponent(componentID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangeForwardNotificationsAttr() {
        int i;
        IElement collectionElement = this.m_frameworkContext.getConfiguration(this.m_collectionConfigID, true);
        IAttributeSet collectionAttrs = collectionElement.getAttributes();
        IAttributeList notificationList = (IAttributeList)collectionAttrs.getAttribute("FORWARD_NOTIFICATIONS");
        String[] notifications = notificationList.getItems().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        String[] forwardedNotifications = null;
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            forwardedNotifications = this.m_forwardNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        }
        ArrayList deletedNotifications = new ArrayList();
        ArrayList newNotifications = this.processNotifications(deletedNotifications, forwardedNotifications, notifications);
        String[] componentIDs = this.getCollectionComponents();
        for (i = deletedNotifications.size() - 1; i >= 0; --i) {
            this.removeForwardNotification((String)deletedNotifications.get(i));
            this.m_parent.m_notificationManager.subscribe(componentIDs);
        }
        for (i = newNotifications.size() - 1; i >= 0; --i) {
            this.addForwardNotification((String)newNotifications.get(i));
            this.m_parent.m_notificationManager.subscribe(componentIDs);
        }
    }

    private ArrayList processNotifications(ArrayList deletedNotifications, String[] forwardedNotifications, String[] notifications) {
        block0: for (int i = 0; i < forwardedNotifications.length; ++i) {
            for (int j = 0; j < notifications.length; ++j) {
                if (notifications[j].equals(forwardedNotifications[i])) continue block0;
            }
            deletedNotifications.add(forwardedNotifications[i]);
        }
        ArrayList<String> newNotifications = new ArrayList<String>();
        block2: for (int i = 0; i < notifications.length; ++i) {
            for (int j = 0; j < forwardedNotifications.length; ++j) {
                if (notifications[i].equals(forwardedNotifications[j])) continue block2;
            }
            newNotifications.add(notifications[i]);
        }
        return newNotifications;
    }

    private synchronized void addForwardNotification(String notificationType) {
        this.m_forwardNotifications.add(notificationType);
        StringTokenizer st = new StringTokenizer(notificationType, ".");
        String[] notifTypes = new String[]{st.nextToken(), st.nextToken(), st.nextToken("\t").substring(1)};
        MBeanNotificationInfo info = new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", DEFAULT_DESCRIPTION);
        this.m_forwardNotificationInfos.put(notificationType, info);
        this.m_unknownNotificationInfos.add(notificationType);
        String[] componentIDs = this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        for (int i = 0; i < componentIDs.length; ++i) {
            this.m_parent.m_notificationManager.addNotificationHandler(componentIDs[i], new String[]{notificationType}, (INotificationHandler)this.m_parent.m_notificationForwarder);
        }
    }

    private synchronized void removeForwardNotification(String notificationType) {
        this.m_forwardNotifications.remove(notificationType);
        this.m_forwardNotificationInfos.remove(notificationType);
        this.m_unknownNotificationInfos.remove(notificationType);
        String[] componentIDs = this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        for (int i = 0; i < componentIDs.length; ++i) {
            this.m_parent.m_notificationManager.removeNotificationHandler(componentIDs[i], new String[]{notificationType}, (INotificationHandler)this.m_parent.m_notificationForwarder);
        }
    }

    private void handleChangeNotificationMonitorsAttrs(IDeltaAttributeSet attrs) throws Exception {
        this.handleNewNotificationMonitorsAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedNotificationMonitorsAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedNotificationMonitorsAttrs(attrs.getDeletedAttributesNames());
    }

    private void handleNewNotificationMonitorsAttrs(IAttributeSet attrs) throws Exception {
        for (Map.Entry entry : attrs.getAttributes().entrySet()) {
            String name = (String)entry.getKey();
            IAttributeSet monitorAttrs = (IAttributeSet)entry.getValue();
            this.addNotificationMonitor(name, monitorAttrs);
        }
    }

    private void handleNewNotificationMonitorsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            this.addNotificationMonitor(names[i], (IAttributeSet)attrs.getNewValue(names[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleModifiedNotificationMonitorsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            NotificationMonitor monitor = null;
            CollectionMonitor collectionMonitor = this;
            synchronized (collectionMonitor) {
                monitor = (NotificationMonitor)this.m_notificationMonitors.get(names[i]);
            }
            if (monitor == null) continue;
            monitor.handleElementChange((IDeltaAttributeSet)attrs.getNewValue(names[i]));
        }
    }

    private void handleDeletedNotificationMonitorsAttrs(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.removeNotificationMonitor(names[i]);
        }
    }

    private synchronized void addNotificationMonitor(String name, IAttributeSet attrs) {
        Integer highThreshold = (Integer)attrs.getAttribute("HIGH_THRESHOLD");
        Integer lowThreshold = (Integer)attrs.getAttribute("LOW_THRESHOLD");
        Integer intervalSeconds = (Integer)attrs.getAttribute("INTERVAL_SECONDS");
        IAttributeList monitorNotifications = (IAttributeList)attrs.getAttribute("MONITOR_NOTIFICATIONS");
        String[] types = new String[monitorNotifications.getCount()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (String)monitorNotifications.getItem(i);
        }
        NotificationMonitor notificationMonitor = new NotificationMonitor(name, highThreshold, lowThreshold, intervalSeconds, types);
        this.m_notificationMonitors.put(name, notificationMonitor);
    }

    private synchronized void removeNotificationMonitor(String name) {
        NotificationMonitor monitor = (NotificationMonitor)this.m_notificationMonitors.remove(name);
        monitor.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleChangeMonitorMetricsAttr() {
        HashSet<IMetricIdentity> monitorMetrics = new HashSet<IMetricIdentity>();
        IElement collectionElement = this.m_frameworkContext.getConfiguration(this.m_collectionConfigID, true);
        IAttributeSet collectionAttrs = collectionElement.getAttributes();
        this.m_monitoredMetricInfos.clear();
        this.m_metricInstances.clear();
        IAttributeList metricList = (IAttributeList)collectionAttrs.getAttribute("MONITOR_METRICS");
        if (metricList != null) {
            for (int i = metricList.getCount() - 1; i >= 0; --i) {
                IMetricIdentity metricID = MetricsFactory.createMetricIdentity((String)((String)metricList.getItem(i)));
                monitorMetrics.add(metricID);
                this.m_unknownMetricInfos.add(metricID);
            }
        }
        CollectionMonitor collectionMonitor = this;
        synchronized (collectionMonitor) {
            int previousMetricCount = this.m_monitorMetrics.size();
            this.m_monitorMetrics = monitorMetrics;
            if (previousMetricCount == 0) {
                this.m_lastRequestedPollTime = 0L;
                this.scheduleBrokerStatePoll();
                this.scheduleMetricsPoll();
                this.scheduleMetricsSlowPoll();
            }
        }
    }

    public synchronized void promoteSlowComponent(String component) {
        this.m_slowComponents.remove(component);
    }

    public synchronized void relegateFastComponent(String component) {
        this.m_slowComponents.add(component);
    }

    private class SlowCollector
    implements Runnable {
        private SlowCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CollectionMonitor.this.m_isClosing) {
                return;
            }
            String[] components = CollectionMonitor.this.getSlowCollectionComponents();
            if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x800) > 0) {
                CollectionMonitor.this.m_frameworkContext.logMessage("Starting metrics slow poll on collection [" + CollectionMonitor.this.m_collectionConfigID + "] for [" + components.length + "] components...", 7);
            }
            IMetricIdentity[] metrics = null;
            SlowCollector slowCollector = this;
            synchronized (slowCollector) {
                metrics = CollectionMonitor.this.m_monitorMetrics.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
            }
            ICollectiveOpStatus results = null;
            try {
                if (components != null && components.length > 0) {
                    results = CollectionMonitor.this.m_frameworkContext.invoke(components, "getMetricsData", new Object[]{metrics, Boolean.FALSE}, GET_METRICS_DATA_SIGNATURE, true, 30000L);
                }
            }
            catch (Exception e) {
                CollectionMonitor.this.m_frameworkContext.logMessage("Failed to slow poll for metrics on collection [" + CollectionMonitor.this.m_collectionConfigID + ']', 2);
            }
            if (results != null) {
                for (int i = results.getCount() - 1; i >= 0; --i) {
                    String component = results.getComponentName(i);
                    if (results.operationIsSuccessful(i)) {
                        HashSet missingMetrics;
                        IMetricsData resultMetrics = (IMetricsData)results.getReturnValue(i);
                        if (resultMetrics != null && component != null && !(missingMetrics = CollectionMonitor.this.storeMetrics(component, resultMetrics)).isEmpty()) {
                            CollectionMonitor.this.enableMetrics(component, missingMetrics);
                        }
                        CollectionMonitor.this.promoteSlowComponent(component);
                        continue;
                    }
                    Throwable throwable = results.getThrowable(i);
                    if (throwable instanceof InvokeTimeoutException) {
                        if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x80) <= 0) continue;
                        CollectionMonitor.this.m_frameworkContext.logMessage("Timeout of slow poll for metrics on component [" + component + ']', 7);
                        continue;
                    }
                    if (throwable instanceof NoSuchMethodException) {
                        if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x200) <= 0) continue;
                        CollectionMonitor.this.m_frameworkContext.logMessage("Failed to slow poll for metrics on component [" + component + "]: component does not provide any metrics", 7);
                        continue;
                    }
                    ICanonicalName cmName = CollectionMonitor.this.m_frameworkContext.getComponentName();
                    CanonicalName componentName = new CanonicalName(component);
                    if (cmName.getContainerName().equals(componentName.getContainerName()) && !CollectionMonitor.this.m_frameworkContext.getContainer().isBooted()) continue;
                    CollectionMonitor.this.m_frameworkContext.logMessage("Failed to slow poll for metrics on component [" + component + "]", 2);
                    if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x200) <= 0) continue;
                    CollectionMonitor.this.m_frameworkContext.logMessage("...trace follows...", throwable, 7);
                }
            }
            if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x800) > 0) {
                CollectionMonitor.this.m_frameworkContext.logMessage("...finished metrics slow poll on collection [" + CollectionMonitor.this.m_collectionConfigID + "] for [" + components.length + "] components...", 7);
            }
            if (!CollectionMonitor.this.m_isClosing) {
                CollectionMonitor.this.scheduleMetricsSlowPoll();
            }
        }
    }

    private class BrokerStatusCollector
    implements Runnable {
        private BrokerStatusCollector() {
        }

        @Override
        public void run() {
            if (CollectionMonitor.this.m_isClosing) {
                return;
            }
            if (CollectionMonitor.this.m_brokerComponents.size() > 0) {
                HashSet<String> activeComponents = new HashSet<String>();
                HashSet<String> inActiveComponents = new HashSet<String>();
                String[] brokerComponents = CollectionMonitor.this.m_brokerComponents.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                for (int i = 0; i < brokerComponents.length; ++i) {
                    try {
                        Integer nReplStateObj = (Integer)CollectionMonitor.this.m_frameworkContext.invoke(brokerComponents[i], "getReplicationState", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, 0L);
                        int nReplState = nReplStateObj;
                        if (nReplState == 2 || nReplState == 3 || nReplState == 5) {
                            activeComponents.add(brokerComponents[i]);
                            continue;
                        }
                        inActiveComponents.add(brokerComponents[i]);
                        continue;
                    }
                    catch (Exception e) {
                        CollectionMonitor.this.m_frameworkContext.logMessage("Failed to poll for getReplicationState on component [" + brokerComponents[i] + ']', 2);
                    }
                }
                CollectionMonitor.this.m_activeComponents = (HashSet)activeComponents.clone();
                CollectionMonitor.this.m_inactiveComponents = (HashSet)inActiveComponents.clone();
            }
            if (!CollectionMonitor.this.m_isClosing) {
                CollectionMonitor.this.scheduleBrokerStatePoll();
            }
        }
    }

    private class NotificationMonitor
    implements Runnable,
    INotificationHandler {
        String monitorName;
        Integer highThreshold;
        Integer lowThreshold;
        Integer intervalSeconds;
        String[] types = IEmptyArray.EMPTY_STRING_ARRAY;
        boolean isClosing = false;
        Object notificationLockObj = new Object();
        int count;
        long scheduledTime;

        private NotificationMonitor(String monitorName, Integer highThreshold, Integer lowThreshold, Integer intervalSeconds, String[] types) {
            this.monitorName = monitorName;
            this.highThreshold = highThreshold;
            this.lowThreshold = lowThreshold;
            this.intervalSeconds = intervalSeconds;
            this.updateHandledTypes(types);
            this.scheduledTime = System.currentTimeMillis() + (long)(this.intervalSeconds * 1000);
            CollectionMonitor.this.m_frameworkContext.scheduleTask((Runnable)this, new Date(this.scheduledTime));
        }

        private void cleanup() {
            this.isClosing = true;
            CollectionMonitor.this.m_frameworkContext.cancelTask((Runnable)this);
            this.updateHandledTypes(IEmptyArray.EMPTY_STRING_ARRAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateHandledTypes(String[] replacementTypes) {
            Object object = this.notificationLockObj;
            synchronized (object) {
                int j;
                ArrayList<String> addedTypes = new ArrayList<String>();
                for (int i = 0; i < replacementTypes.length; ++i) {
                    boolean found = false;
                    for (int j2 = 0; j2 < this.types.length; ++j2) {
                        if (!replacementTypes[i].equals(this.types[j2])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    addedTypes.add(replacementTypes[i]);
                }
                ArrayList<String> removedTypes = new ArrayList<String>();
                for (int i = 0; i < this.types.length; ++i) {
                    boolean found = false;
                    for (j = 0; j < replacementTypes.length; ++j) {
                        if (!this.types[i].equals(replacementTypes[j])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    removedTypes.add(this.types[i]);
                }
                if (!addedTypes.isEmpty()) {
                    String[] addTypes = addedTypes.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                    String[] components = CollectionMonitor.this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                    for (j = 0; j < components.length; ++j) {
                        ((CollectionMonitor)CollectionMonitor.this).m_parent.m_notificationManager.addNotificationHandler(components[j], addTypes, this);
                    }
                }
                if (!addedTypes.isEmpty() && !removedTypes.isEmpty()) {
                    try {
                        long timeout;
                        long waitTime = timeout = 2000L;
                        long startTime = System.currentTimeMillis();
                        while (waitTime > 0L) {
                            this.notificationLockObj.wait(waitTime);
                            waitTime = timeout - (System.currentTimeMillis() - startTime);
                        }
                    }
                    catch (Exception timeout) {
                        // empty catch block
                    }
                    if (CollectionMonitor.this.m_isClosing || this.isClosing) {
                        return;
                    }
                }
                if (!removedTypes.isEmpty()) {
                    String[] removeTypes = removedTypes.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                    String[] components = CollectionMonitor.this.m_components.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                    for (int j3 = 0; j3 < components.length; ++j3) {
                        ((CollectionMonitor)CollectionMonitor.this).m_parent.m_notificationManager.removeNotificationHandler(components[j3], removeTypes, this);
                    }
                }
                this.types = replacementTypes;
            }
        }

        void addComponent(String componentID) {
            ((CollectionMonitor)CollectionMonitor.this).m_parent.m_notificationManager.addNotificationHandler(componentID, this.types, this);
        }

        void removeComponent(String componentID) {
            ((CollectionMonitor)CollectionMonitor.this).m_parent.m_notificationManager.removeNotificationHandler(componentID, this.types, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CollectionMonitor.this.m_isClosing || this.isClosing) {
                return;
            }
            int lastCount = 0;
            Object object = this.notificationLockObj;
            synchronized (object) {
                lastCount = this.count;
                this.count = 0;
            }
            INotification notification = null;
            if (this.highThreshold != null && lastCount > this.highThreshold) {
                notification = this.configNotification();
                notification.setAttribute("HighThreshold", (Object)this.highThreshold.toString());
                notification.setAttribute("ActualCount", (Object)("" + lastCount));
                CollectionMonitor.this.m_frameworkContext.sendNotification(notification);
            }
            if (this.lowThreshold != null && lastCount < this.lowThreshold) {
                notification = this.configNotification();
                notification.setAttribute("LowThreshold", (Object)this.lowThreshold.toString());
                notification.setAttribute("ActualCount", (Object)("" + lastCount));
                CollectionMonitor.this.m_frameworkContext.sendNotification(notification);
            }
            if (notification != null && ((CollectionMonitor)CollectionMonitor.this).m_parent.m_saveThresholdNotifications) {
                try {
                    if (((CollectionMonitor)CollectionMonitor.this).m_parent.m_offloader != null) {
                        if (CollectionMonitor.this.m_parent.isEnterprise()) {
                            ((CollectionMonitor)CollectionMonitor.this).m_parent.m_offloader.offloadNotification(notification);
                        } else if (!CollectionMonitor.this.m_enterpriseMessageRequiredLogged) {
                            CollectionMonitor.this.m_frameworkContext.logMessage("Analytics offload is not supported and requires Enterprise Sonic Messaging", 1);
                            CollectionMonitor.this.m_enterpriseMessageRequiredLogged = true;
                        }
                    } else if (((CollectionMonitor)CollectionMonitor.this).m_parent.m_store != null) {
                        ((CollectionMonitor)CollectionMonitor.this).m_parent.m_store.storeNotification(notification);
                    }
                }
                catch (AnalyticsOffloadException e) {
                    if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x1000) > 0) {
                        CollectionMonitor.this.m_frameworkContext.logMessage("Failed to offload threshold notification, trace follows...", (Throwable)e, 7);
                    } else {
                        CollectionMonitor.this.m_frameworkContext.logMessage("Failed to offload threshold notification", 2);
                    }
                }
                catch (StorageException e) {
                    if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x40) > 0) {
                        CollectionMonitor.this.m_frameworkContext.logMessage("Failed to store threshold notification, trace follows...", (Throwable)e, 7);
                    }
                    CollectionMonitor.this.m_frameworkContext.logMessage("Failed to store threshold notification", 2);
                }
            }
            if (CollectionMonitor.this.m_isClosing || this.isClosing) {
                return;
            }
            this.scheduledTime += (long)(this.intervalSeconds * 1000);
            CollectionMonitor.this.m_frameworkContext.scheduleTask((Runnable)this, new Date(this.scheduledTime));
        }

        private INotification configNotification() {
            INotification notification = CollectionMonitor.this.m_frameworkContext.createNotification((short)0, INotification.SUBCATEGORY_TEXT[2], CollectionMonitor.THRESHOLD_NOTIFICATION_TYPE, 2);
            notification.setLogType((short)1);
            notification.setAttribute("CollectionConfigID", (Object)CollectionMonitor.this.m_collectionConfigID);
            notification.setAttribute("NotificationMonitor", (Object)this.monitorName);
            return notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(INotification notification) {
            Object object = this.notificationLockObj;
            synchronized (object) {
                ++this.count;
            }
            final INotification saveNotification = notification;
            Runnable saver = new Runnable(){

                @Override
                public void run() {
                    if (((CollectionMonitor)CollectionMonitor.this).m_parent.m_saveMonitoredNotifications) {
                        try {
                            if (((CollectionMonitor)CollectionMonitor.this).m_parent.m_offloader != null) {
                                if (CollectionMonitor.this.m_parent.isEnterprise()) {
                                    ((CollectionMonitor)CollectionMonitor.this).m_parent.m_offloader.offloadNotification(saveNotification);
                                } else if (!CollectionMonitor.this.m_enterpriseMessageRequiredLogged) {
                                    CollectionMonitor.this.m_frameworkContext.logMessage("Analytics offload is not supported and requires Enterprise Sonic Messaging", 1);
                                    CollectionMonitor.this.m_enterpriseMessageRequiredLogged = true;
                                }
                            } else if (((CollectionMonitor)CollectionMonitor.this).m_parent.m_store != null) {
                                ((CollectionMonitor)CollectionMonitor.this).m_parent.m_store.storeNotification(saveNotification);
                            }
                        }
                        catch (AnalyticsOffloadException e) {
                            if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x1000) > 0) {
                                CollectionMonitor.this.m_frameworkContext.logMessage("Failed to offload monitored notification, trace follows...", (Throwable)e, 7);
                            } else {
                                CollectionMonitor.this.m_frameworkContext.logMessage("Failed to offload monitored notification", 2);
                            }
                        }
                        catch (StorageException e) {
                            if ((((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x40) > 0) {
                                CollectionMonitor.this.m_frameworkContext.logMessage("Failed to store monitored notification, trace follows...", (Throwable)e, 7);
                            }
                            CollectionMonitor.this.m_frameworkContext.logMessage("Failed to store monitored notification", 2);
                        }
                    }
                }
            };
            CollectionMonitor.this.m_frameworkContext.scheduleTask(saver, new Date());
        }

        void handleElementChange(IDeltaAttributeSet attrs) throws Exception {
            this.handleNewNotificationMonitorsAttrs(attrs.getNewAttributesNames(), attrs);
            this.handleModifiedNotificationMonitorsAttrs(attrs.getModifiedAttributesNames(), attrs);
            this.handleDeletedNotificationMonitorsAttrs(attrs.getDeletedAttributesNames());
        }

        private void handleNewNotificationMonitorsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
            for (int i = 0; i < names.length; ++i) {
                this.handleThresholdAttrs(attrs, i, names);
                if (!names[i].equals("MONITOR_NOTIFICATIONS")) continue;
                IAttributeList attrList = (IAttributeList)attrs.getNewValue("MONITOR_NOTIFICATIONS");
                String[] monitorNotifications = attrList.getItems().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                this.updateHandledTypes(monitorNotifications);
            }
        }

        private void handleModifiedNotificationMonitorsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
            for (int i = 0; i < names.length; ++i) {
                this.handleThresholdAttrs(attrs, i, names);
                if (!names[i].equals("MONITOR_NOTIFICATIONS")) continue;
                Object list = attrs.getNewValue("MONITOR_NOTIFICATIONS");
                String[] updatedTypes = null;
                if (list instanceof IAttributeList) {
                    updatedTypes = ((IAttributeList)list).getItems().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                } else {
                    Object[] newNotifications;
                    IDeltaAttributeList deltaList = (IDeltaAttributeList)list;
                    updatedTypes = (String[])this.types.clone();
                    HashMap modified = deltaList.getModifiedItems();
                    for (Map.Entry entry : modified.entrySet()) {
                        updatedTypes[((Integer)entry.getKey()).intValue()] = (String)entry.getValue();
                    }
                    int[] removedNotifications = deltaList.getDeletedItemNumbers();
                    if (removedNotifications.length > 0) {
                        for (int j = 0; j < removedNotifications.length; ++j) {
                            updatedTypes[removedNotifications[j]] = null;
                        }
                        String[] tempTypes = new String[updatedTypes.length - removedNotifications.length];
                        int k = 0;
                        for (int j = 0; j < updatedTypes.length; ++j) {
                            if (updatedTypes[j] == null) continue;
                            tempTypes[k++] = updatedTypes[j];
                        }
                        updatedTypes = tempTypes;
                    }
                    if ((newNotifications = deltaList.getNewItems()).length > 0) {
                        String[] tempTypes = new String[updatedTypes.length + newNotifications.length];
                        System.arraycopy(updatedTypes, 0, tempTypes, 0, updatedTypes.length);
                        for (int j = 0; j < newNotifications.length; ++j) {
                            tempTypes[updatedTypes.length + j] = (String)newNotifications[j];
                        }
                        updatedTypes = tempTypes;
                    }
                }
                this.updateHandledTypes(updatedTypes);
            }
        }

        private void handleThresholdAttrs(IDeltaAttributeSet attrs, int i, String[] names) throws NotModifiedAttException {
            if (names[i].equals("HIGH_THRESHOLD")) {
                this.highThreshold = (Integer)attrs.getNewValue("HIGH_THRESHOLD");
            }
            if (names[i].equals("LOW_THRESHOLD")) {
                this.lowThreshold = (Integer)attrs.getNewValue("LOW_THRESHOLD");
            }
            if (names[i].equals("INTERVAL_SECONDS")) {
                this.intervalSeconds = (Integer)attrs.getNewValue("INTERVAL_SECONDS");
            }
        }

        private void handleDeletedNotificationMonitorsAttrs(String[] names) throws Exception {
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals("HIGH_THRESHOLD")) {
                    this.highThreshold = null;
                }
                if (names[i].equals("LOW_THRESHOLD")) {
                    this.lowThreshold = null;
                }
                if (names[i].equals("INTERVAL_SECONDS")) {
                    this.intervalSeconds = new Integer(60);
                }
                if (!names[i].equals("MONITOR_NOTIFICATIONS")) continue;
                this.updateHandledTypes(IEmptyArray.EMPTY_STRING_ARRAY);
            }
        }
    }

    private class InfoGetter
    extends Thread {
        long retryWait;
        Random random;
        Object infoGetterLockObj;

        private InfoGetter() {
            super("CM InfoGetter");
            this.retryWait = 4000L;
            this.random = new Random();
            this.infoGetterLockObj = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!InfoGetter.interrupted() && !CollectionMonitor.this.m_isClosing) {
                String componentID = null;
                Object object = CollectionMonitor.this;
                synchronized (object) {
                    if (CollectionMonitor.this.m_componentsWithoutInfos.isEmpty()) {
                        CollectionMonitor.this.m_infoGetterThread = null;
                        return;
                    }
                    int posn = 0;
                    try {
                        posn = Math.abs(this.random.nextInt() % CollectionMonitor.this.m_componentsWithoutInfos.size());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    componentID = (String)CollectionMonitor.this.m_componentsWithoutInfos.get(posn);
                    if (componentID == null) {
                        CollectionMonitor.this.m_componentsWithoutInfos.remove(posn);
                        continue;
                    }
                }
                try {
                    this.getComponentManagementInfo(componentID);
                    CollectionMonitor.this.m_componentsWithoutInfos.remove(componentID);
                    if (!CollectionMonitor.this.m_componentsWithoutInfos.isEmpty()) {
                        continue;
                    }
                }
                catch (InvokeTimeoutException invokeTimeoutException) {
                }
                catch (InfoGetterFailure e) {
                    this.logWarning(componentID, e.getMessage(), null);
                }
                catch (Exception e) {
                    this.logWarning(componentID, null, e);
                }
                if (CollectionMonitor.this.m_componentsWithoutInfos.size() > 1) continue;
                object = this.infoGetterLockObj;
                synchronized (object) {
                    try {
                        this.infoGetterLockObj.wait(this.retryWait);
                    }
                    catch (InterruptedException e) {
                        CollectionMonitor.this.m_infoGetterThread = null;
                        return;
                    }
                }
                if (this.retryWait >= 256000L) continue;
                this.retryWait += this.retryWait;
            }
        }

        private void logWarning(String componentID, String error, Exception e) {
            ICanonicalName cmName = CollectionMonitor.this.m_frameworkContext.getComponentName();
            CanonicalName componentName = new CanonicalName(componentID);
            if (!cmName.getContainerName().equals(componentName.getContainerName()) || CollectionMonitor.this.m_frameworkContext.getContainer().isBooted()) {
                boolean traceRequestFailures = (((CollectionMonitor)CollectionMonitor.this).m_parent.m_traceMask & 0x200) > 0;
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to obtain management information for component [").append(componentID).append("]");
                if (traceRequestFailures && error != null) {
                    sb.append(": ").append(error);
                }
                sb.append(", retry will be initiated later");
                if (traceRequestFailures && e != null) {
                    CollectionMonitor.this.m_frameworkContext.logMessage(sb.toString(), (Throwable)e, 2);
                } else {
                    CollectionMonitor.this.m_frameworkContext.logMessage(sb.toString(), 2);
                }
            }
        }

        private IMetricInfo[] getMetricInfo(String componentID, MBeanOperationInfo[] operationInfos) throws Exception {
            for (MBeanOperationInfo info : operationInfos) {
                if (!"getMetricsInfo".equals(info.getName())) continue;
                IMetricInfo[] metricInfos = (IMetricInfo[])CollectionMonitor.this.m_frameworkContext.invoke(componentID, "getMetricsInfo", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, 0L);
                if (metricInfos == null) {
                    throw new InfoGetterFailure("metrics information not available");
                }
                return metricInfos;
            }
            return EMPTY_METRIC_INFO_ARRAY;
        }

        private void getComponentManagementInfo(String componentID) throws Exception {
            MBeanInfo mBeanInfo = (MBeanInfo)CollectionMonitor.this.m_frameworkContext.invoke(componentID, "getMBeanInfo", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, 0L);
            if (mBeanInfo == null) {
                throw new InfoGetterFailure("management bean information not available");
            }
            MBeanNotificationInfo[] notificationInfos = mBeanInfo.getNotifications();
            IMetricInfo[] metricInfos = this.getMetricInfo(componentID, mBeanInfo.getOperations());
            for (MBeanNotificationInfo mBeanNotificationInfo : notificationInfos) {
                String[] notificationTypes = mBeanNotificationInfo.getNotifTypes();
                StringBuffer sb = new StringBuffer(notificationTypes[0]);
                if (notificationTypes.length > 1) {
                    for (int j = 1; j < notificationTypes.length; ++j) {
                        sb.append('.').append(notificationTypes[j]);
                    }
                }
                CollectionMonitor.this.m_notificationInfos.put(sb.toString(), mBeanNotificationInfo);
            }
            for (MBeanNotificationInfo mBeanNotificationInfo : metricInfos) {
                CollectionMonitor.this.m_metricInfos.put(mBeanNotificationInfo.getMetricIdentity(), mBeanNotificationInfo);
            }
        }

        public Object getInforGetterLockObj() {
            return this.infoGetterLockObj;
        }
    }

    private static class InfoGetterFailure
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InfoGetterFailure(String message) {
            super(message);
        }
    }
}

